/*
 * Tomiku
 *
 * Project homepage: http://tomiku.garage.maemo.org
 * Author homepage: http://www.aivokyyti.net
 *
 * Copyright (C) 2007 Tomi Pihlainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA. 
 *
 */

#ifndef _MAIN_WINDOW_H_
#define _MAIN_WINDOW_H_

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#ifdef CHINOOK
#include <hildon/hildon-program.h>
#else
#include <hildon-widgets/hildon-program.h>
#endif

#include <appdata.h>

/* Types */

typedef struct _MainWindow MainWindow;
struct _MainWindow
{
    AppData* appdata;

    /* Menu items */
    GtkWidget *item_game_pause;
    GtkWidget *item_game_continue;
    GtkWidget *item_show_full_screen;
    GtkWidget *item_show_subcell_dots;
    GtkWidget *item_show_incorrect_cells;

    GtkWidget* drawing_area;
    GtkWidget* main_view_event_box;
    
    GdkPixbuf* background_pixbuf;
    GdkPixbuf* cell_predefined_pixbuf;
    GdkPixbuf* cell_correct_pixbuf[9];
    GdkPixbuf* cell_incorrect_pixbuf[9];
    GdkPixbuf* subcell_pixbuf[9];
    GdkPixbuf* subcell_dots_pixbuf;
    GdkPixbuf* marker_button_selected;
    GdkPixbuf* marker_button_unselected;
    GdkPixbuf* submarker_button_selected;
    GdkPixbuf* submarker_button_unselected;
    
    gboolean subcell_dots;
    gboolean show_incorrect_cells;
    gboolean full_screen;
    
    guint32 game_duration_timer;
};

/* Interface functions */

MainWindow* main_window_new(AppData *appdata);
void main_window_destroy(MainWindow* main_window);
void main_view_new_game(MainWindow* main_window);

#endif /* _MAIN_WINDOW_H_ */
