/*
 * Tomiku
 *
 * Project homepage: http://tomiku.garage.maemo.org
 * Author homepage: http://www.aivokyyti.net
 *
 * Copyright (C) 2007 Tomi Pihlainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA. 
 *
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtkmain.h>

#ifdef CHINOOK
#include <hildon/hildon-program.h>
#include <hildon/hildon-help.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <osso-helplib.h>
#endif

#include "appdata.h"
#include "main_window.h"

#include <libintl.h>
#include <locale.h>
#include <libosso.h>

#define _(String) gettext(String)

#include <config.h>

int main(int argc, char* argv[])
{
    /* Initialise the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    /* Init the gtk - must be called before any hildon stuff */
    gtk_init(&argc, &argv);

    AppData appdata;
    appdata.osso_context = osso_initialize(PACKAGE, VERSION, TRUE, NULL);

    /* Create the hildon application and setup the title */
    appdata.program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name(_("Tomiku"));

    /* Create HildonWindow */
    MainWindow* main_window = main_window_new(&appdata);

    /* Connect signal to X in the upper corner */
    g_signal_connect(G_OBJECT(appdata.main_window), "delete_event", G_CALLBACK(gtk_main_quit), NULL);

    /* Create the board and start playing so that we have something fancy to show */   
    main_view_new_game(main_window);
    
    /* Begin the main application */
    gtk_widget_show_all(GTK_WIDGET(appdata.main_window));
    gtk_main();

    /* Clean up */
    main_window_destroy(main_window);

    return 0;
}     
