/*
 * Tomiku
 *
 * Project homepage: http://tomiku.garage.maemo.org
 * Author homepage: http://www.aivokyyti.net
 *
 * Copyright (C) 2007 Tomi Pihlainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA. 
 *
 */
 
#ifndef _GAME_H_
#define _GAME_H_

/* Game states */
#define GAME_STATE_PLAY 0
#define GAME_STATE_PAUSED 1
#define GAME_STATE_ENDED 2

/* Get game state */
int get_game_state();

/* Start new game */
int start_new_game();

/* Pause */
int pause_game();

/* Continue */
int continue_game();

/* End game */
int end_game();

/* Game duration */
time_t get_game_duration();

#endif /* _GAME_H_ */
