/*
 * Tomiku
 *
 * Project homepage: http://tomiku.garage.maemo.org
 * Author homepage: http://www.aivokyyti.net
 *
 * Copyright (C) 2007 Tomi Pihlainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA. 
 *
 */
 
#ifndef _BOARD_H_
#define _BOARD_H_

/* Board dimension. Same dimension for width (x) and height (y). */
#define BOARD_DIM 9

/* Cell is not marked */
#define CELL_NOT_MARKED -1
#define CELL_MARKED 1

/* Playing mode: whether user is marking the cells or just help numbers to subcells */
#define PLAY_MODE_MARK_CELL 0
#define PLAY_MODE_MARK_SUBCELL 1

/* Marking mode: is user using subcells for pointing the cell value or big number pad
   on the side of the board */
#define MARK_MODE_SUBCELL 0
#define MARK_MODE_NUMBER_PAD_1 1
#define MARK_MODE_NUMBER_PAD_2 2
#define MARK_MODE_NUMBER_PAD_3 3
#define MARK_MODE_NUMBER_PAD_4 4
#define MARK_MODE_NUMBER_PAD_5 5
#define MARK_MODE_NUMBER_PAD_6 6
#define MARK_MODE_NUMBER_PAD_7 7
#define MARK_MODE_NUMBER_PAD_8 8
#define MARK_MODE_NUMBER_PAD_9 9

/* Return values */
#define MARK_FAILED_PREDEFINED -1
#define MARK_OK 0

/* Cell structure */
typedef struct _cell t_cell;
struct _cell
{
    /* Cell is included in the problem */
    int predefined;
    
    /* User has marked the solution */
    int marker;
    
    /* User solution is correct */
    int correct;
    
    /* User has marked sub markers (helpers) */
    int submarker[BOARD_DIM];
};

/* Initialize cell data */
void init_cell_data();

/* Set playing mode */
void set_play_mode(int mode);

/* Get playing mode */
int get_play_mode();

/* Toggle marking mode */
void toggle_mark_mode(int mode);

/* Get marking mode */
int get_mark_mode();

/* Get cell value */
t_cell get_cell(int x, int y);

/* Get subcell value */
int get_subcell_marker(int x, int y, int subcell_index);

/* Toggle the marker information to one cell
   Return:
   MARK_FAILED_PREDEFINED
   MARK_OK */
int set_marker(int x, int y, int cell_value);

/* Toggle the subcell information to the cell */
void toggle_submarker(int x, int y, int subcell_index);

/* Checks if problem is solved correctly */
int is_solved();

/* Create the board data. */
int create_board();

#endif /* _BOARD_H_ */
