/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
 * aumiks 0.1
 * File:   Synth.hpp
 * Author: ivan
 *
 * Created on February 21, 2009, 1:50 PM
 */

#ifndef M_Synth_hpp
#define	M_Synth_hpp

#include "../aumiks.hpp"

#include "PluckedString.hpp"

namespace aumiks{

using namespace ting;

class Instrument : public aumiks::Sound{
public:

	class Channel : public aumiks::Channel{
	protected:
		int lastVolume;

	public:
		inline Channel() :
				lastVolume(-1)
		{};

		virtual void SetFrequency(float freq){}
	};

	virtual Ref<Instrument::Channel> CreateChannel() = 0;
};


class PluckedStringInstrument : public Instrument{
public:
	class Channel : public Instrument::Channel{
		PluckedString pluckedString;

		enum E_State{
			STOPPED,
			PLAYING,
			RELEASING
		} state;

		float curTime;

	public:
		Channel() :
				pluckedString(27.5),
				state(STOPPED)
		{
			this->pluckedString.SetFrequency(220);
			this->pluckedString.SetLoopGain(1);
			this->pluckedString.SetLoopFilterCoefs(0.95, 0.05);
		}

		//override
		void SetFrequency(float freq){
			this->pluckedString.SetFrequency(freq);
		}

	protected:
		//override
		void OnStart(){
			this->pluckedString.Pluck(1.0);
			this->state = PLAYING;
		}
	private:
		//override
		bool MixToMixBuf(Array<s32>& mixBuf);
	};

	//override
	Ref<Instrument::Channel> CreateChannel();
};


class SineWaveInstrument : public Instrument{
public:

	class Channel : public Instrument::Channel{
		float curPhase;

		float curTime;
		enum EEnvelopePhase{
			ATTACK,
			DECAY,
			SUSTAIN,
			RELEASE
		} envPhase;

		float frequency;
		float attackTime;//s
		float decayTime;//s
		float sustainLevel;
		float releaseTime;//s

		float releaseFromLevel;
	public:

		Channel() :
				curPhase(0),
				curTime(0),
				envPhase(ATTACK)
		{
			this->SetFrequency(440);
		};

		//override
		void SetFrequency(float freq){
			this->frequency = freq;
			this->attackTime = 20.0f/freq;
			this->decayTime = 20.0f/freq;
			this->sustainLevel = 0.4;
			this->releaseTime = 30.0f/freq;
		};

	private:
		//override
		bool MixToMixBuf(Array<s32>& mixBuf);
	};

	Ref<Instrument::Channel> CreateChannel();

};

}//~namespace
#endif	//~once
