/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/* 
 * File:   Preferences.hpp
 * Author: ivan
 *
 * Created on April 22, 2009, 2:31 PM
 */

#ifndef M_Preferences_hpp
#define	M_Preferences_hpp

#include <string>
#include <ting/types.hpp>



inline ting::uint DHighestOctave(){
	return 7;
}



class Preferences{
	std::string prefsFileName;

	ting::uint numOctaves;
	ting::uint basePitch;//step number starting from A0 (27.5Hz)
	bool lockCurrentOctave;
public:
	Preferences(const std::string& fileName) :
			prefsFileName(fileName),
			numOctaves(1),
			basePitch(12 * 4),//A4
			lockCurrentOctave(true),
			timbre(SINE_PLUS_ADSR)
	{}

	enum E_Timbre{
		SINE_PLUS_ADSR,
		PLUCKED_STRING,

		UNKNOWN, //NOTE: UNKNOWN must be last timbre in the list!!!

		NUM_TIMBRES
	};

private:
	E_Timbre timbre;
public:

	inline ting::uint GetNumOctaves()const{
		return this->numOctaves;
	}

	void SetNumOctaves(ting::uint numberOfOctaves){
		this->numOctaves = numberOfOctaves;
		this->ClampBasePitch();
	}

	inline ting::uint GetBasePitch()const{
		return this->basePitch;
	}
	
	void SetBasePitch(ting::uint newBasePitch){
		this->basePitch = newBasePitch;
		this->ClampBasePitch();
	}

	inline bool GetLockCurrentOctave()const{
		return this->lockCurrentOctave;
	}

	inline void SetLockCurrentOctave(bool lockOctave){
		this->lockCurrentOctave = lockOctave;
	}

	inline E_Timbre GetTimbre()const{
		return this->timbre;
	}

	inline void SetTimbre(E_Timbre newTimbre){
		this->timbre = newTimbre;
	}

	static std::string TimbreTypeToName(Preferences::E_Timbre timbre);
	static Preferences::E_Timbre TimbreNameToType(std::string name);

	void LoadFromFile();
	void SaveToFile();

private:
	void ClampBasePitch();
};

#endif//~once
