/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <hildonmm.h>
#include <gtkmm/main.h>

#include <ting/debug.hpp>

#include <aumiks/aumiks.hpp>

#include "MainWindow.hpp"

#include "FSFile.hpp"

int main(int argc, char *argv[]){
	LOG(<<"program start"<<std::endl)

	//Create .theremin directory in user's home if it does not exist
	{
		file::FSFile dir(file::File::GetHomeDir() + ".theremin/");
		if(!dir.Exists()){
			TRACE(<<"dir does not exist"<<std::endl)
			dir.MkDir();
		}else{
			TRACE(<<"dir already exists"<<std::endl)
		}
	}

	TRACE(<<"creating sndlib"<<std::endl)
#ifndef M_NO_AUDIO
	aumiks::Lib sndlib(2048);
#endif

	TRACE(<<"creating instrument"<<std::endl)

	// Initialize gtkmm:
	Gtk::Main kit(&argc, &argv);
	Hildon::init();

	osso_context_t* osso_context = osso_initialize(
			"org.maemo.garage.theremin",
			"1.0.1",
			TRUE /* deprecated parameter */,
			0 /* Use default Glib main loop context */
		);
	if(!osso_context){
		TRACE(<< "osso_initialize() failed." << std::endl)
		throw ting::Exc("osso_initialize() failed.");
	}


	Glib::set_application_name("Theremin");//shown in main window caption

	// Create Window and set it to the Program instance()
	MainWindow window;
	Hildon::Program::get_instance()->add_window(window);

	// Begin the main application
	kit.run(window);

	osso_deinitialize(osso_context);

	return 0;
};
