/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

/*
 * aumiks 0.1
 */

#include "PluckedString.hpp"

#include "../aumiks.hpp"

#include "synth.hpp"

#include <cmath>
#include <ting/math.hpp>
#include <ting/types.hpp>

using namespace aumiks;



bool SineWaveInstrument::Channel::MixToMixBuf(Array<s32>& mixBuf){
	bool stopPlaying = false;
	bool quit;
	ting::uint i = 0;//current sample
	do{//while(!quit)
		quit = true;
		switch(this->envPhase){
			case ATTACK:
				for(; i < mixBuf.Size();){
					float attack = this->curTime / this->attackTime;
					this->releaseFromLevel = attack;
					s32 smp = s32(float(0x7fff) * attack * sin(this->curPhase));
					this->curPhase += 2 * DPi<float>() * this->frequency * (1.0f / float(44100));
					this->curTime += 1.0f / float(44100);

					//apply volume
					smp = (smp * this->volume) / 0xff;

					mixBuf[i] += smp;
					++i;
					mixBuf[i] += smp;
					++i;

					if(this->curTime >= this->attackTime){
						this->curTime -= this->attackTime;
						quit = false;
						this->envPhase = DECAY;
//						TRACE(<< "switch to DECAY" << std::endl)
						break;//~for
					}
				}
				break;
			case DECAY:
				for(; i < mixBuf.Size();){
					float decay = float(1) - (1 - this->sustainLevel) * (this->curTime / this->decayTime);
					this->releaseFromLevel = decay;
					s32 smp = s32(float(0x7fff) * decay * sin(this->curPhase));
					this->curPhase += 2 * DPi<float>() * this->frequency * (1.0f / float(44100));
					this->curTime += 1.0f / float(44100);

					//apply volume
					smp = (smp * this->volume) / 0xff;

					mixBuf[i] += smp;
					++i;
					mixBuf[i] += smp;
					++i;

					if(this->curTime >= this->decayTime){
//						this->curTime = 0;
						quit = false;
						this->envPhase = SUSTAIN;
//						TRACE(<< "switch to SUSTAIN" << std::endl)
						break;//~for
					}
				}
				break;
			case SUSTAIN:
				if(this->stopFlag){
					this->stopFlag = false;
					this->curTime = 0;
					this->envPhase = RELEASE;
					quit = false;
			//		TRACE(<< "switch to RELEASE" << std::endl)
				}else{
					this->releaseFromLevel = this->sustainLevel;
					for(; i < mixBuf.Size();){
						s32 smp = s32(0x7fff * this->sustainLevel * sin(this->curPhase));
						this->curPhase += 2 * DPi<float>() * this->frequency * (1.0f / float(44100));
	//					this->curTime += 1.0f / float(44100);
				//		TRACE(<<"t =" << this->t)
				//		TRACE(<<"smp =" << smp)

						//apply volume
						smp = (smp * this->volume) / 0xff;

						mixBuf[i] += smp;
						++i;
						mixBuf[i] += smp;
						++i;
					}//~for
				}

				{
					float numPeriods = this->curPhase / (2 * DPi<float>());
					this->curPhase -= float(ting::uint(numPeriods)) * 2 * DPi<float>();
				}

				break;//~switch
			case RELEASE:
				for(; i < mixBuf.Size();){
					float release = this->releaseFromLevel * (1 - this->curTime / this->releaseTime);
					s32 smp = s32(float(0x7fff) * release * sin(this->curPhase));
					this->curPhase += 2 * DPi<float>() * this->frequency * (1.0f / float(44100));
					this->curTime += 1.0f / float(44100);

					//apply volume
					smp = (smp * this->volume) / 0xff;

					mixBuf[i] += smp;
					++i;
					mixBuf[i] += smp;
					++i;

					if(this->curTime >= this->releaseTime){
						this->curTime = 0;
						stopPlaying = true;
						this->envPhase = ATTACK;
//						TRACE(<< "switch to STOP playing" << std::endl)
						break;//~for
					}
				}
				break;
			default:
				ASSERT(false)
				break;
		}//~switch
	}while(!quit);
	
	return stopPlaying;
};



Ref<Instrument::Channel> SineWaveInstrument::CreateChannel(){
	Ref<SineWaveInstrument::Channel> ch(new SineWaveInstrument::Channel());
	return ch;
};

Ref<Instrument::Channel> PluckedStringInstrument::CreateChannel(){
	Ref<PluckedStringInstrument::Channel> ch(new PluckedStringInstrument::Channel());
	return ch;
}

bool PluckedStringInstrument::Channel::MixToMixBuf(Array<s32>& mixBuf){
	bool ret = false;

	switch(this->state){
		case PLAYING:
			if(this->stopFlag){
				this->state = RELEASING;
				this->curTime = 0.2;
				this->pluckedString.Mute();
			}
			break;
		case RELEASING:
			this->curTime -= float(mixBuf.Size()) / (2 * 44100.0f);
			if(curTime <= 0){
				this->state = STOPPED;
				ret = true;
			}
			break;
		default:
			break;
	}

	for(ting::uint i=0; i < mixBuf.Size();){
		float s = this->pluckedString.Tick();
		s32 smp = s32(0x7fff * s);

		//with distortion
//		s32 smp = s32( 0x7fff * (s > 0 ? tanh(4 * s) : s ) );

		//apply volume
		smp = (smp * this->volume) / 0xff;

		mixBuf[i] += smp;
		++i;
		mixBuf[i] += smp;
		++i;
	}//~for

	return ret;
}
