/* The MIT License:

Copyright (c) 2009 Ivan Gagis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE. */

#include <gtkmm/dialog.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm-2.4/gtkmm/container.h>
#include <gtkmm-2.4/gtkmm/radiobutton.h>
#include <gtkmm-2.4/gtkmm/togglebutton.h>

#include "stdafx.hpp"
#include "OptionsDialog.hpp"


OptionsDialog::OptionsDialog(Gtk::Window &parent) :
		Gtk::Dialog("Options", parent, true),
		octavesFrame("Number of octaves"),
		oneOctaveRadioButton("One octave"),
		twoOctavesRadioButton("Two octaves"),
		threeOctavesRadioButton("Three octaves"),
		timbreFrame("Timbre"),
		sinePlusADSRButton("Sine + ADSR"),
		pluckedStringButton("Plucked string")
{
	this->get_vbox()->add(this->hBox);
	this->hBox.add(this->octavesFrame);
	this->octavesFrame.add(this->octavesBox);

	{//group octaves radio buttons
		Gtk::RadioButtonGroup gr = this->oneOctaveRadioButton.get_group();
		this->twoOctavesRadioButton.set_group(gr);
		this->threeOctavesRadioButton.set_group(gr);
	}
	this->octavesBox.add(this->oneOctaveRadioButton);
	this->oneOctaveRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
	this->octavesBox.add(this->twoOctavesRadioButton);
	this->twoOctavesRadioButton.set_size_request(-1, DFingerFriendlyMinSize());
	this->octavesBox.add(this->threeOctavesRadioButton);
	this->threeOctavesRadioButton.set_size_request(-1, DFingerFriendlyMinSize());


	this->hBox.add(this->timbreFrame);
	this->timbreFrame.add(this->timbreBox);

	{//group timbre radio buttons
		Gtk::RadioButtonGroup gr = this->sinePlusADSRButton.get_group();
		this->pluckedStringButton.set_group(gr);
	}
	this->timbreBox.add(this->sinePlusADSRButton);
	this->sinePlusADSRButton.set_size_request(-1, DFingerFriendlyMinSize());
	this->timbreBox.add(this->pluckedStringButton);
	this->pluckedStringButton.set_size_request(-1, DFingerFriendlyMinSize());


	this->add_button("Ok", 0);
	this->add_button("Cancel", 1);

	this->show_all_children();//Show all window child widgets
};

ting::uint OptionsDialog::GetNumOctaves()const{
	if(this->oneOctaveRadioButton.get_active())
		return 1;
	else if(this->twoOctavesRadioButton.get_active())
		return 2;
	else if(this->threeOctavesRadioButton.get_active())
		return 3;
	else
		return 0;
};

void OptionsDialog::SetNumOctaves(ting::uint num){
	switch(num){
		case 1:
			this->oneOctaveRadioButton.set_active(true);
			break;
		case 2:
			this->twoOctavesRadioButton.set_active(true);
			break;
		case 3:
			this->threeOctavesRadioButton.set_active(true);
		default:
			break;
	}
};

OptionsDialog::E_Timbre OptionsDialog::GetTimbre()const{
	if(this->sinePlusADSRButton.get_active())
		return SINE_PLUS_ADSR;
	else if(this->pluckedStringButton.get_active())
		return PLUCKED_STRING;
	else
		return UNKNOWN;
}

void OptionsDialog::SetTimbre(E_Timbre timbre){
	switch(timbre){
		case SINE_PLUS_ADSR:
			this->sinePlusADSRButton.set_active(true);
			break;
		case PLUCKED_STRING:
			this->pluckedStringButton.set_active(true);
			break;
		default:
			break;
	}
}

//static
std::string OptionsDialog::TimbreTypeToName(E_Timbre timbre){
	switch(timbre){
		default:
		case SINE_PLUS_ADSR:
			return "SineWave";
			break;
		case PLUCKED_STRING:
			return "PluckedString";
			break;
	}
}

//static
OptionsDialog::E_Timbre OptionsDialog::TimbreNameToType(std::string name){
	for(ting::uint t = 0; t < ting::uint(NUM_TIMBRES); ++t){
		if(OptionsDialog::TimbreTypeToName(E_Timbre(t)).compare(name) == 0)
			return E_Timbre(t);
	}
	return SINE_PLUS_ADSR;
}
