/*
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/* Adapted to Maemo platform by Olivier ROLAND */

#include "config.h"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include "sg-util.h"
#include "sgtk-dialog.h"
#include "sgtk-hig.h"
#include "st-about-dialog.h"
#include "st-link.h"
#include "st-settings.h"
#include "sg-util.h"
#include "st-handler.h"
#include "st-util.h"

/*** function declarations ***************************************************/

static void      st_about_dialog_init		(STAboutDialog *dialog);

/*** implementation **********************************************************/

GType
st_about_dialog_get_type (void)
{
  static GType about_dialog_type = 0;
  
  if (! about_dialog_type)
    {
      static const GTypeInfo about_dialog_info = {
	sizeof(STAboutDialogClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(STAboutDialog),
	0,
	(GInstanceInitFunc) st_about_dialog_init,
      };
      
      about_dialog_type = g_type_register_static(SGTK_TYPE_DIALOG,
						 "STAboutDialog",
						 &about_dialog_info,
						 0);
    }

  return about_dialog_type;
}

static void
st_about_dialog_init (STAboutDialog *dialog)
{
  GtkWidget *box;
  GtkWidget *close;
  GtkWidget *logo;
  GtkWidget *version;
  GtkWidget *link;
  GtkWidget *link_maemo;
  char *tmp;

  close = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);
  gtk_widget_grab_focus(close);

  gtk_window_set_title(GTK_WINDOW(dialog), _("About streamtuner"));
  gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);

  /* create the logo */

  logo = st_logo_new();

  /* create the version and copyright */

  tmp = g_strdup_printf(_("\nversion %s\n%s\n%s\n"), VERSION, ST_COPYRIGHT, ST_MAEMO_PORT);
  version = gtk_label_new(tmp);
  g_free(tmp);

  gtk_label_set_selectable(GTK_LABEL(version), TRUE);
  gtk_label_set_justify(GTK_LABEL(version), GTK_JUSTIFY_CENTER);

  /* create the homepage link */

  link = st_link_new();
  st_link_set_text(ST_LINK(link), ST_HOME);
  st_link_set_uri(ST_LINK(link), ST_HOME);
  link_maemo = st_link_new();
  st_link_set_text(ST_LINK(link_maemo), ST_MAEMO_HOME);
  st_link_set_uri(ST_LINK(link_maemo), ST_MAEMO_HOME);


  /* pack the widgets */

  box = gtk_vbox_new(FALSE, 0);

  gtk_box_pack_start(GTK_BOX(box), logo, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), version, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), link, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), link_maemo, FALSE, FALSE, 0);

  gtk_container_add(GTK_CONTAINER(SGTK_DIALOG(dialog)->contents), box);
  gtk_widget_show_all(box);
}

GtkWidget *
st_about_dialog_new (GtkWindow *parent)
{
  STAboutDialog *dialog;

  dialog = g_object_new(ST_TYPE_ABOUT_DIALOG, NULL);

  if (parent)
    gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);

  return GTK_WIDGET(dialog);
}
