markets = ["Dow Jones Industrial", "NASDAQ 100", "S&P 500", "IBEX35", "SPANISH MERCADO CONTINUO", "IBEX NUEVO MERCADO", "FTSE 100", "EURO STOXX 50", "S&P / MIB INDX", "MIB 30", "MIDEX"]
idmarket = ["dow", "nasdaq", "sp500", "ibex35", "mc", "ibexnm", "ftse100", "eurostoxx50", "spmib", "mib30", "midex"]

#EUROSTOXX50:
eurostoxx50_symbols=['AABA.AS', 'ACA.PA', 'AGN.AS', 'AH.AS', 'AI.PA', 'AIB.IR', 'ALV.DE', 'BAS.DE', 'BAY.DE', 'BBVA.MC', 'BN.PA', 'BNP.PA', 'CA.PA', 'ALU.PA', 'CS.PA', 'DAI.DE', 'DBK.DE', 'DTE.DE', 'ELE.MC', 'ENEL.MI', 'ENI.MI', 'EOA.DE', 'FORA.AS', 'FP.PA', 'FTE.PA', 'G.MI', 'GLE.PA', 'IBE.MC', 'ING.AS', 'ISP.MI', 'LG.PA', 'MC.PA', 'MUV2.DE', 'NOA3.DE', 'OR.PA', 'PHIA.AS', 'REP.MC', 'RNO.PA', 'RWE.DE', 'SAN.MC', 'SAN.PA', 'SAP.DE', 'SGO.PA', 'SIE.DE', 'SZE.PA', 'TEF.MC', 'TIT.MI', 'UCG.MI', 'UNA.AS', 'VIV.PA']
eurostoxx50_names=['ABN AMRO HOLDING', 'CREDIT AGRICOLE', 'AEGON', 'AHOLD', 'AIR LIQUIDE', 'ALLIED IRISH BANKS', 'ALLIANZ N', 'BASF', 'BAYER', 'BBVA R', 'DANONE', 'BNP PARIBAS', 'CARREFOUR', 'ALCATEL-LUCENT', 'AXA', 'DAIMLER N', 'DEUTSCHE BANK N', 'DEUTSCHE TELEKOM N', 'ENDESA', 'ENEL', 'ENI', 'E.ON AG', 'FORTIS', 'TOTAL', 'FRANCE TELECOM', 'GENERALI', 'STE GENERALE-A-', 'IBERDROLA', 'ING GROEP', 'INTESA SANPAOLO', 'LAFARGE', 'LVMH', 'MUENCH RUECKVERS N', 'NOKIA', "L'OREAL", 'ROY.PHILIPS ELECTR', 'REPSOL YPF', 'RENAULT', 'RWE -A-', 'BANCO SANTANDER R', 'SANOFI-AVENTIS', 'SAP', 'SAINT GOBAIN', 'SIEMENS N', 'SUEZ (ROMPUS)', 'TELEFONICA', 'TELECOM ITALIA', 'UNICREDIT', 'UNILEVER CERT', 'VIVENDI']

#IBEX35
ibex35_symbols=['ABE.MC', 'ABG.MC', 'ACS.MC', 'ACX.MC', 'ANA.MC', 'BBVA.MC', 'BKT.MC', 'BME.MC', 'TEF.MC', 'BTO.MC', 'CIN.MC', 'CRI.MC', 'ELE.MC', 'ENG.MC', 'FCC.MC', 'FER.MC', 'GAM.MC', 'GAS.MC', 'GRF.MC', 'IBE.MC', 'IBLA.MC', 'IBR.MC', 'IDR.MC', 'ITX.MC', 'MAP.MC', 'OHL.MC', 'POP.MC', 'REE.MC', 'REP.MC', 'SAB.MC', 'SAN.MC', 'SYV.MC', 'TL5.MC', 'TRE.MC', 'UNF.MC']
ibex35_names=['ABERTIS -A-', 'ABENGOA', 'ACS', 'ACERINOX', 'ACCIONA', 'BBVA R', 'BANKINTER R', 'BME', 'TELEFONICA', 'BANESTO R', 'CINTRA', 'CRIT.CAIXACORP', 'ENDESA', 'ENAGAS', 'FCC', 'GRUPO FERROVIAL', 'GAMESA', 'GAS NATURAL SDG', 'GRIFOLS A', 'IBERDROLA', 'IBERIA', 'IBERDROLA RENOVABLE', 'INDRA SISTEMAS -A-', 'INDITEX R', 'MAPFRE', 'HUARTE LAIN', 'BANCO POPULAR R', 'RED EL CORPORACION', 'REPSOL YPF', 'BANCO SABADELL R', 'BANCO SANTANDER R', 'SACYR VALLEHERMOSO', 'TELECINCO', 'TECNICAS REUNIDAS', 'UNION FENOSA']

#DOW JONES
dow_jones_symbols=['AA', 'AXP', 'BA', 'BAC', 'C', 'CAT', 'CVX', 'DD', 'DIS', 'GE', 'GM', 'HD', 'HPQ', 'IBM', 'INTC', 'JNJ', 'JPM', 'KFT', 'KO', 'MCD', 'MMM', 'MRK', 'MSFT', 'PFE', 'PG', 'T', 'UTX', 'VZ', 'WMT', 'XOM']
dow_jones_names=['ALCOA INC', 'AMER EXPRESS INC', 'BOEING CO', 'BK OF AMERICA CP', 'CITIGROUP INC', 'CATERPILLAR INC', 'CHEVRON CORP', 'DU PONT E I DE NEM', 'WALT DISNEY-DISNEY C', 'GEN ELECTRIC CO', 'GEN MOTORS', 'HOME DEPOT INC', 'HEWLETT PACKARD CO', 'INTL BUSINESS MACH', 'Intel Corporation', 'JOHNSON AND JOHNS DC', 'JP MORGAN CHASE CO', 'KRAFT FOODS INC', 'COCA COLA CO THE', 'MCDONALDS CP', '3M COMPANY', 'MERCK CO INC', 'Microsoft Corporation', 'PFIZER INC', 'PROCTER GAMBLE CO', 'AT&T INC.', 'UNITED TECH', 'VERIZON COMMUN', 'WAL MART STORES', 'EXXON MOBIL CP']

#NASDAQ 100
nasdaq_symbols=['AAPL', 'ADBE', 'ADP', 'ADSK', 'AKAM', 'ALTR', 'AMAT', 'AMGN', 'AMZN', 'APOL', 'ATVI', 'BBBY', 'BIDU', 'BIIB', 'BRCM', 'CA', 'CELG', 'CEPH', 'CHKP', 'CHRW', 'CMCSA', 'COST', 'CSCO', 'CTAS', 'CTSH', 'CTXS', 'DELL', 'DISH', 'DTV', 'EBAY', 'ERTS', 'ESRX', 'EXPD', 'EXPE', 'FAST', 'FISV', 'FLEX', 'FLIR', 'FSLR', 'FWLT', 'GENZ', 'GILD', 'GOOG', 'GRMN', 'HANS', 'HOLX', 'HSIC', 'IACI', 'ILMN', 'INFY', 'INTC', 'INTU', 'ISRG', 'JAVA', 'JBHT', 'JNPR', 'JOYG', 'KLAC', 'LBTYA', 'LIFE', 'LINTA', 'LLTC', 'LOGI', 'LRCX', 'MCHP', 'MICC', 'MRVL', 'MSFT', 'MXIM', 'NIHD', 'NTAP', 'NVDA', 'NWSA', 'ORCL', 'ORLY', 'PAYX', 'PCAR', 'PDCO', 'PPDI', 'QCOM', 'RIMM', 'ROST', 'RYAAY', 'SBUX', 'SHLD', 'SIAL', 'SPLS', 'SRCL', 'STLD', 'STX', 'SYMC', 'TEVA', 'URBN', 'VRSN', 'VRTX', 'WCRX', 'WYNN', 'XLNX', 'XRAY', 'YHOO']
nasdaq_names=['Apple Inc.', 'Adobe Systems Incorporated', 'Automatic Data Processing, Inc.', 'Autodesk, Inc.', 'Akamai Technologies, Inc.', 'Altera Corporation', 'Applied Materials, Inc.', 'Amgen Inc.', 'Amazon.com, Inc.', 'Apollo Group, Inc.', 'Activision Blizzard, Inc', 'Bed Bath & Beyond Inc.', 'Baidu, Inc.', 'Biogen Idec Inc', 'Broadcom Corporation', 'CA Inc.', 'Celgene Corporation', 'Cephalon, Inc.', 'Check Point Software Technologi', 'C.H. Robinson Worldwide, Inc.', 'Comcast Corporation', 'Costco Wholesale Corporation', 'Cisco Systems, Inc.', 'Cintas Corporation', 'Cognizant Technology Solutions', 'Citrix Systems, Inc.', 'Dell Inc.', 'DISH Network Corporation', 'The DIRECTV Group, Inc.', 'eBay Inc.', 'Electronic Arts Inc.', 'Express Scripts, Inc.', 'Expeditors International of Was', 'Expedia, Inc.', 'Fastenal Company', 'Fiserv, Inc.', 'Flextronics International Ltd.', 'FLIR Systems, Inc.', 'First Solar, Inc.', 'Foster Wheeler AG.', 'Genzyme Corporation', 'Gilead Sciences, Inc.', 'Google Inc.', 'Garmin Ltd.', 'Hansen Natural Corporation', 'Hologic, Inc.', 'Henry Schein, Inc.', 'IAC/InterActiveCorp', 'Illumina, Inc.', 'Infosys Technologies Limited', 'Intel Corporation', 'Intuit Inc.', 'Intuitive Surgical, Inc.', 'Sun Microsystems, Inc.', 'J.B. Hunt Transport Services, I', 'Juniper Networks, Inc.', 'Joy Global Inc.', 'KLA-Tencor Corporation', 'Liberty Global, Inc.', 'Life Technologies Corporation', 'Liberty Media Corporation', 'Linear Technology Corporation', 'Logitech International S.A.', 'Lam Research Corporation', 'Microchip Technology Incorporat', 'Millicom International Cellular', 'Marvell Technology Group, Ltd.', 'Microsoft Corporation', 'Maxim Integrated Products, Inc.', 'NII Holdings, Inc.', 'NetApp, Inc.', 'NVIDIA Corporation', 'News Corporation', 'Oracle Corporation', "O'Reilly Automotive, Inc.", 'Paychex, Inc.', 'PACCAR Inc.', 'Patterson Companies Inc.', 'Pharmaceutical Product Developm', 'QUALCOMM Incorporated', 'Research In Motion Limited', 'Ross Stores, Inc.', 'Ryanair Holdings plc', 'Starbucks Corporation', 'Sears Holdings Corporation', 'Sigma-Aldrich Corporation', 'Staples, Inc.', 'Stericycle, Inc.', 'Steel Dynamics, Inc.', 'Seagate Technology', 'Symantec Corporation', 'Teva Pharmaceutical Industries', 'Urban Outfitters, Inc.', 'VeriSign, Inc.', 'Vertex Pharmaceuticals Incorpor', 'Warner Chilcott Limited', 'Wynn Resorts, Limited', 'Xilinx, Inc.', 'DENTSPLY International Inc.', 'Yahoo! Inc.']

#IBEXNM
ibexnm_symbols=['ABG.MC', 'AMP.MC', 'AVZ.MC', 'BIO.MC', 'BMA.MC', 'TEC.MC', 'IDR.MC', 'JAZ.MC', 'NTC.MC', 'TPI.MC', 'ZEL.MC']
ibexnm_names=['ABENGOA', 'AMPER', 'AVANZIT', 'PULEVA BIOTECH', 'BEFESA ', 'TECNOCOM', 'INDRA SISTEMAS -A-', 'JAZZTEL', 'NATRACEUTICAL', 'YELL PUBLICIDAD', 'ZELTIA']

#SPANISH MERCADO CONTINUO
mc_symbols=['ABE.MC', 'ACS.MC', 'ACX.MC', 'ADZ.MC', 'AGS.MC', 'ALB.MC', 'ALT.MC', 'AMP.MC', 'ANA.MC', 'ASA.MC', 'AVZ.MC', 'AZKYF.MC', 'BBVA.MC', 'BDL.MC', 'BES.MC', 'BIO.MC', 'BKT.MC', 'BVA.MC', 'BVIS.MC', 'CAF.MC', 'CEP.MC', 'COL.MC', 'CPF.MC', 'CPL.MC', 'CUN.MC', 'DGI.MC', 'DIN.MC', 'EAD.MC', 'ECR.MC', 'ELE.MC', 'ENC.MC', 'EVA.MC', 'FAE.MC', 'FCC.MC', 'FER.MC', 'FUN.MC', 'GAM.MC', 'GAS.MC', 'GCO.MC', 'GUI.MC', 'IBE.MC', 'IBG.MC', 'IBLA.MC', 'IDR.MC', 'ITX.MC', 'ITI.MC', 'JAZ.MC', 'LOG.MC', 'MAP.MC', 'MCM.MC', 'MDF.MC', 'MLX.MC', 'MTS.MC', 'MVC.MC', 'NAT.MC', 'NEA.MC', 'NHH.MC', 'OHL.MC', 'PAC.MC', 'PAT.MC', 'POP.MC', 'PRS.MC', 'PSG.MC', 'PVA.MC', 'RDM.MC', 'REE.MC', 'REP.MC', 'RIO.MC', 'SAB.MC', 'SAN.MC', 'SED.MC', 'SGC.MC', 'SNC.MC', 'SOL.MC', 'SOS.MC', 'SPS.MC', 'SYV.MC', 'TAZ.MC', 'TEF.MC', 'TEC.MC', 'TPI.MC', 'TPZ.MC', 'TUB.MC', 'UBS.MC', 'UNF.MC', 'UPL.MC', 'URA.MC', 'URB.MC', 'VID.MC', 'ZEL.MC', 'ZOT.MC']
mc_names=['ABERTIS -A-', 'ACS', 'ACERINOX', 'ADOLFO DOMINGUEZ', 'AGUAS BARCELONA -A-', 'CORP FIN ALBA', 'ALTADIS R', 'AMPER', 'ACCIONA', 'TAVEX ALGODONERA', 'AVANZIT', 'AZKOYEN', 'BBVA R', 'BARON DE LEY', 'INBESOS', 'PULEVA BIOTECH', 'BANKINTER R', 'BCO DE VALENCIA R', 'VISCOFAN', 'CONSTR AUXIL FERROC', 'CEPSA', 'INMOB COLONIAL', 'CAMPOFRIO FOOD GRP', 'CEMENTOS PORTLAND V', 'VINICOLA NORTE ESP', 'DOGI INT FABRICS', 'DINAMIA', 'EADS', 'ERCROS', 'ENDESA', 'ENCE', 'EBRO PULEVA', 'FAES FARMA R', 'FCC', 'GRUPO FERROVIAL', 'FUNESPANA', 'GAMESA', 'GAS NATURAL SDG', 'GRUPO CATALANA', 'GUIPUZCOANO', 'IBERDROLA', 'IBERPAPEL', 'IBERIA', 'INDRA SISTEMAS -A-', 'INDITEX R', 'ITINERE', 'JAZZTEL', 'DISTRIBUCION INT', 'MAPFRE', 'MIQUEL Y COSTAS', 'DURO FELGUERA', 'MECALUX', 'ARCELORMITTAL REG', 'METROVACESA', 'NATRA', 'NICOLAS CORREA', 'NH HOTELES', 'HUARTE LAIN', 'EUROPAC', 'FEDERICO PATERNINA', 'BANCO POPULAR R', 'PRISA A', 'PROSEGUR R', 'PESCANOVA', 'RENO DE MEDICI', 'RED EL CORPORACION', 'REPSOL YPF', 'BODEGAS RIOJANAS', 'BANCO SABADELL R', 'BANCO SANTANDER R', 'LA SEDA BARCELONA', 'SOGECABLE R A', 'SNIACE', 'SOL MELIA', 'SOS CUETARA', 'SERVICE POINT', 'SACYR VALLEHERMOSO', 'TRANSPORTES AZKAR', 'TELEFONICA', 'TECNOCOM', 'YELL PUBLICIDAD', 'TELE PIZZA', 'TUBACEX', 'URBAS', 'UNION FENOSA', 'UNIPAPEL', 'URALITA', 'INMOBILIARIA URBIS', 'VIDRALA', 'ZELTIA', 'ZARDOYA OTIS']

#FTSE 100
ftse100_symbols=['AAL.L', 'ABF.L', 'ADM.L', 'AMEC.L', 'AML.L', 'ANTO.L', 'ATST.L', 'AU.L', 'AV.L', 'AZN.L', 'BA.L', 'BARC.L', 'BATS.L', 'BAY.L', 'BBY.L', 'BG.L', 'BLND.L', 'BLT.L', 'BNZL.L', 'BP.L', 'BSY.L', 'BT-A.L', 'CBRY.L', 'CCL.L', 'CNA.L', 'CNE.L', 'COB.L', 'CPG.L', 'CPI.L', 'CW.L', 'DGE.L', 'DRX.L', 'EMG.L', 'ENRC.L', 'EXPN.L', 'FP.L', 'FRCL.L', 'FRES.L', 'GFS.L', 'GSK.L', 'HMSO.L', 'HOME.L', 'HSBA.L', 'IAP.L', 'IHG.L', 'IMT.L', 'IPR.L', 'ISAT.L', 'ISYS.L', 'ITRK.L', 'JMAT.L', 'KAZ.L', 'KGF.L', 'LAND.L', 'LGEN.L', 'LII.L', 'LLOY.L', 'LMI.L', 'MKS.L', 'MRW.L', 'NG.L', 'NXT.L', 'OML.L', 'PFC.L', 'PNN.L', 'PRU.L', 'PSON.L', 'RB.L', 'RBS.L', 'RDSA.L', 'RDSB.L', 'REL.L', 'REX.L', 'RIO.L', 'RR.L', 'RRS.L', 'RSA.L', 'SAB.L', 'SBRY.L', 'SDR.L', 'SDRC.L', 'SGE.L', 'SHP.L', 'SL.L', 'SMIN.L', 'SN.L', 'SRP.L', 'SSE.L', 'STAN.L', 'SVT.L', 'TCG.L', 'TLW.L', 'TRIL.L', 'TSCO.L', 'TT.L', 'ULVR.L', 'UU.L', 'VED.L', 'VOD.L', 'WPP.L', 'WTB.L', 'XTA.L']
ftse100_names=['ANGLO AMERICAN', 'ASSOCIAT BRIT FOODS', 'ADMIRAL GROUP', 'AMEC', 'AMLIN', 'ANTOFAGASTA', 'ALLIANCE TRUST', 'AUTONOMY CORP', 'AVIVA', 'ASTRAZENECA', 'BAE SYSTEMS', 'BARCLAYS', 'BRIT AMER TOBACCO', 'BRITISH AIRWAYS', 'BALFOUR BEATTY', 'BG GROUP', 'BRIT LAND CO REIT', 'BHP BILLITON', 'BUNZL', 'BP', 'B SKY B GROUP', 'BT GROUP', 'CADBURY ADR', 'CARNIVAL', 'CENTRICA', 'CAIRN ENERGY', 'COBHAM', 'COMPASS GROUP', 'CAPITA GRP', 'CABLE & WIRELESS', 'DIAGEO', 'DRAX GROUP', 'MAN GROUP', 'EURASIAN NATURAL', 'EXPERIAN', 'FRIENDS PROVIDENT', 'FOREIGN&COL INV TST', 'FRESNILLO', 'G4S', 'GLAXOSMITHKLINE', 'HAMMERSON REIT', 'HOME RETAIL GROUP', 'HSBC HLDG', 'ICAP', 'INTERCONT HOTELS', 'IMPERIAL TOBACCO', 'INTERNATIONAL POWER', 'INMARSAT', 'INVENSYS', 'INTERTEK GROUP', 'JOHNSON MATTHEY PLC', 'KAZAKHMYS', 'KINGFISHER', 'LAND SEC R.E.I.T.', 'LEGAL & GENERAL', 'LIBERTY INT R.E.I.T', 'LLOYDS BANKING GRP', 'LONMIN', 'MARKS & SPENCER', 'MORRISON SUPERMKTS', 'NATIONAL GRID', 'NEXT', 'OLD MUTUAL', 'PETROFAC', 'PENNON GRP', 'PRUDENTIAL', 'PEARSON', 'RECKITT BENCK GRP', 'ROYAL BK SCOTL GR', 'ROYAL DUTCH SHELL-A', 'ROYAL DUTCH SHELL-B', 'REED ELSEVIER', 'REXAM', 'RIO TINTO', 'ROLLS-ROYCE GROUP', 'RANDGOLD RESOURCES', 'RSA INSUR GRP', 'SABMILLER', 'SAINSBURY', 'SCHRODERS', 'SCHRODERS NVTG', 'SAGE GRP', 'SHIRE', 'STANDARD LIFE', 'SMITHS GROUP', 'SMITH & NEPHEW', 'SERCO GROUP', 'SCOT & STHN ENERGY', 'STANDARD CHARTERED', 'SEVERN TRENT', 'THOMAS COOK GRP', 'TULLOW OIL', 'THOMSON REUTERS', 'TESCO PLC', 'TUI TRAVEL', 'UNILEVER', 'UNITED UTILITIES', 'VEDANTA RESOURCES', 'VODAFONE GRP', 'WPP', 'WHITBREAD', 'XSTRATA']

#S&P MIB
spmib_symbols=['A2A.MI', 'AGL.MI', 'AL.MI', 'ATL.MI', 'BMPS.MI', 'BP.MI', 'BUL.MI', 'BZU.MI', 'CIR.MI', 'CPR.MI', 'ENEL.MI', 'ENI.MI', 'F.MI', 'FNC.MI', 'FSA.MI', 'G.MI', 'GEO.MI', 'IPG.MI', 'ISP.MI', 'IT.MI', 'LTO.MI', 'LUX.MI', 'MB.MI', 'MED.MI', 'MN.MI', 'MS.MI', 'PLT.MI', 'PMI.MI', 'PRY.MI', 'SPM.MI', 'SRG.MI', 'STM.MI', 'STS.MI', 'TEN.MI', 'TIT.MI', 'TRN.MI', 'UBI.MI', 'UCG.MI', 'UNI.MI']
spmib_names=['A2A', 'AUTOGRILL', 'ALLEANZA', 'ATLANTIA', 'BANCA MPS', 'BANCO POPOLARE', 'BULGARI', 'BUZZI UNICEM', 'CIR-COMP IND RIUNIT', 'CAMPARI', 'ENEL', 'ENI', 'FIAT', 'FINMECCANICA', 'FONDIARIA-SAI', 'GENERALI', 'GEOX', 'IMPREGILO', 'INTESA SANPAOLO', 'ITALCEMENTI', 'LOTTOMATICA', 'LUXOTTICA GROUP', 'MEDIOBANCA', 'MEDIOLANUM', 'MONDADORI EDIT', 'MEDIASET', 'PARMALAT', 'BCA POP. MILANO', 'PRYSMIAN', 'SAIPEM', 'SNAM RETE GAS', 'STMICROELECTRONICS', 'ANSALDO STS', 'TENARIS', 'TELECOM ITALIA', 'TERNA', 'UBI BANCA', 'UNICREDIT', 'UNIPOL']

#MIB30
mib30_symbols=['AL.MI', 'ATL.MI', 'BIL.MI', 'BMPS.MI', 'BPI.MI', 'BPU.MI', 'BPVN.MI', 'ENEL.MI', 'ENI.MI', 'ERG.MI', 'F.MI', 'FNC.MI', 'G.MI', 'ISP.MI', 'LTO.MI', 'LUX.MI', 'MB.MI', 'MED.MI', 'MS.MI', 'PLT.MI', 'PMI.MI', 'SPM.MI', 'SRG.MI', 'STM.MI', 'TEN.MI', 'TIT.MI', 'TRN.MI', 'UCG.MI']
mib30_names=['ALLEANZA', 'ATLANTIA', 'BANCA ITALEASE', 'BANCA MPS', 'BCA POP ITALIANA', 'BANCHE POP UNITE', 'BP VERONA E NOVARA', 'ENEL', 'ENI', 'ERG', 'FIAT', 'FINMECCANICA', 'GENERALI', 'INTESA SANPAOLO', 'LOTTOMATICA', 'LUXOTTICA GROUP', 'MEDIOBANCA', 'MEDIOLANUM', 'MEDIASET', 'PARMALAT', 'BCA POP. MILANO', 'SAIPEM', 'SNAM RETE GAS', 'STMICROELECTRONICS', 'TENARIS', 'TELECOM ITALIA', 'TERNA', 'UNICREDIT']

#MIBTEL
#mibtel_symbols=








#MIDEX
midex_symbols=['ACE.MI', 'AT.MI', 'AZM.MI', 'BEN.MI', 'BIL.MI', 'BNS.MI', 'CASS.MI', 'CE.MI', 'CRG.MI', 'CVAL.MI', 'EDN.MI', 'EN.MI', 'ERG.MI', 'ES.MI', 'EXO.MI', 'FWB.MI', 'GEM.MI', 'HER.MI', 'IND.MI', 'IRD.MI', 'MI.MI', 'MT.MI', 'PG.MI', 'RCS.MI', 'REC.MI', 'SIS.MI', 'SRS.MI', 'TIS.MI', 'TOD.MI']
midex_names=['ACEA', 'AUTOSTRADA TO-MI', 'AZIMUT HOLDING', 'BENETTON GROUP', 'BANCA ITALEASE', 'BENI STABILI', 'CATTOLICA ASS', 'CREDITO EMILIANO', 'BANCA CARIGE', 'CRED. VALTELLINESE', 'EDISON', 'ENIA', 'ERG', "GR EDIT L'ESPRESSO", 'EXOR', 'FASTWEB', 'GEMINA', 'HERA', 'INDESIT COMPANY', 'IRIDE', 'MILANO ASS.', 'MAIRE TECNIMONT', 'SEAT PAGINE GIALLE', 'RCS MEDIAGROUP', 'RECORDATI', 'SIAS', 'SARAS', 'TISCALI', "TOD'S"]

#S&P 500
sp500_symbols=['A', 'AA', 'AAPL', 'ABC', 'ABT', 'ACS', 'ADBE', 'ADI', 'ADM', 'ADP', 'ADSK', 'AEE', 'AEP', 'AES', 'AET', 'AFL', 'AGN', 'AIG', 'AIV', 'AIZ', 'AKAM', 'AKS', 'ALL', 'ALTR', 'AMAT', 'AMD', 'AMGN', 'AMP', 'AMT', 'AMZN', 'AN', 'ANF', 'AOC', 'APA', 'APC', 'APD', 'APH', 'APOL', 'ATI', 'AVB', 'AVP', 'AVY', 'AXP', 'AYE', 'AZO', 'BA', 'BAC', 'BAX', 'BBBY', 'BBT', 'BBY', 'BCR', 'BDK', 'BDX', 'BEN', 'BF-B', 'BHI', 'BIG', 'BIIB', 'BJS', 'BK', 'BLL', 'BMC', 'BMS', 'BMY', 'BNI', 'BRCM', 'BSX', 'BTU', 'BXP', 'C', 'CA', 'CAG', 'CAH', 'CAM', 'CAT', 'CB', 'CBE', 'CBG', 'CBS', 'CCE', 'CCL', 'CEG', 'CELG', 'CEPH', 'CF', 'CHK', 'CHRW', 'CI', 'CIEN', 'CINF', 'CIT', 'CL', 'CLX', 'CMA', 'CMCSA', 'CME', 'CMI', 'CMS', 'CNP', 'CNX', 'COF', 'COG', 'COH', 'COL', 'COP', 'COST', 'COV', 'CPB', 'CPWR', 'CRM', 'CSC', 'CSCO', 'CSX', 'CTAS', 'CTL', 'CTSH', 'CTX', 'CTXS', 'CVG', 'CVH', 'CVS', 'CVX', 'D', 'DD', 'DE', 'DELL', 'DF', 'DFS', 'DGX', 'DHI', 'DHR', 'DIS', 'DNB', 'DNR', 'DO', 'DOV', 'DOW', 'DPS', 'DRI', 'DTE', 'DTV', 'DUK', 'DVA', 'DVN', 'DYN', 'EBAY', 'ECL', 'ED', 'EFX', 'EIX', 'EK', 'EL', 'EMC', 'EMN', 'EMR', 'EOG', 'EP', 'EQ', 'EQR', 'EQT', 'ERTS', 'ESRX', 'ESV', 'ETFC', 'ETN', 'ETR', 'EXC', 'EXPD', 'EXPE', 'F', 'FAST', 'FCX', 'FDO', 'FDX', 'FE', 'FHN', 'FII', 'FIS', 'FISV', 'FITB', 'FLIR', 'FLR', 'FLS', 'FO', 'FPL', 'FRX', 'FTR', 'GAS', 'GCI', 'GD', 'GE', 'GENZ', 'GILD', 'GIS', 'GLW', 'GM', 'GME', 'GNW', 'GOOG', 'GPC', 'GPS', 'GR', 'GS', 'GT', 'GWW', 'HAL', 'HAR', 'HAS', 'HBAN', 'HCBK', 'HCN', 'HCP', 'HD', 'HES', 'HIG', 'HNZ', 'HOG', 'HON', 'HOT', 'HPQ', 'HRB', 'HRL', 'HRS', 'HSP', 'HST', 'HSY', 'HUM', 'IBM', 'ICE', 'IFF', 'IGT', 'INTC', 'INTU', 'IP', 'IPG', 'IR', 'IRM', 'ISRG', 'ITT', 'ITW', 'IVZ', 'JAVA', 'JBL', 'JCI', 'JCP', 'JDSU', 'JEC', 'JNJ', 'JNPRJNS', 'JPM', 'JWN', 'K', 'KBH', 'KEY', 'KFT', 'KG', 'KIM', 'KLAC', 'KMB', 'KO', 'KR', 'KSS', 'L', 'LEG', 'LEN', 'LH', 'LIFE', 'LLL', 'LLTC', 'LLY', 'LM', 'LMT', 'LNC', 'LO', 'LOW', 'LSI', 'LTD', 'LUK', 'LUV', 'LXK', 'M', 'MA', 'MAR', 'MAS', 'MAT', 'MBI', 'MCD', 'MCHP', 'MCK', 'MCO', 'MDP', 'MDT', 'MEE', 'MET', 'MFE', 'MHP', 'MHS', 'MI', 'MIL', 'MKC', 'MMC', 'MMM', 'MO', 'MOLX', 'MON', 'MOT', 'MRK', 'MRO', 'MS', 'MSFT', 'MTB', 'MTW', 'MU', 'MUR', 'MWV', 'MWW', 'MYL', 'NBL', 'NBR', 'NDAQ', 'NEM', 'NI', 'NKE', 'NOC', 'NOV', 'NOVL', 'NSC', 'NSM', 'NTAP', 'NTRS', 'NU', 'NUE', 'NVDA', 'NVLS', 'NWL', 'NWSA', 'NYT', 'NYX', 'ODP', 'OI', 'OMC', 'ORCL', 'ORLY', 'OXY', 'PAYX', 'PBCT', 'PBG', 'PBI', 'PCAR', 'PCG', 'PCL', 'PCP', 'PDCO', 'PEG', 'PEP', 'PFE', 'PFG', 'PG', 'PGN', 'PGR', 'PH', 'PHM', 'PKI', 'PLD', 'PLL', 'PM', 'PNC', 'PNW', 'POM', 'PPG', 'PPL', 'PRU', 'PSA', 'PTV', 'PX', 'PXD', 'Q', 'QCOM', 'QLGC', 'R', 'RAI', 'RDC', 'RF', 'RHI', 'RL', 'ROK', 'RRC', 'RRD', 'RSG', 'RSH', 'RTN', 'RX', 'S', 'SBUX', 'SCG', 'SCHW', 'SE', 'SEE', 'SGP', 'SHLD', 'SHW', 'SIAL', 'SII', 'SJM', 'SLB', 'SLE', 'SLM', 'SNA', 'SNDK', 'SNI', 'SO', 'SPG', 'SPLS', 'SRCL', 'SRE', 'STI', 'STJ', 'STR', 'STT', 'STZ', 'SUN', 'SVU', 'SWK', 'SWN', 'SWY', 'SYK', 'SYMC', 'SYY', 'T', 'TAP', 'TDC', 'TE', 'TEG', 'TEL', 'TER', 'TGT', 'THC', 'TIE', 'TIF', 'TJX', 'TLAB', 'TMK', 'TMO', 'TROW', 'TRV', 'TSN', 'TSO', 'TSS', 'TWC', 'TWX', 'TXN', 'TXT', 'UNH', 'UNM', 'UNP', 'UPS', 'USB', 'UTX', 'VAR', 'VFC', 'VIA-B', 'VLO', 'VMC', 'VNO', 'VRSN', 'VTR', 'VZ', 'WAG', 'WAT', 'WEC', 'WFC', 'WFMI', 'WFR', 'WHR', 'WIN', 'WLP', 'WMB', 'WMI', 'WMT', 'WPI', 'WPO', 'WU', 'WY', 'WYE', 'WYN', 'WYNN', 'X', 'XEL', 'XL', 'XLNX', 'XOM', 'XRAY', 'XRX', 'XTO', 'YHOO', 'YUM', 'ZION', 'ZMH']
sp500_names=['AGILENT TECH INC', 'ALCOA INC', 'Apple Inc.', 'AMERISOURCEBERGEN CP', 'ABBOTT LABORATORIES', 'AFFILIATED COMP SVCS', 'Adobe Systems Incorporated', 'ANALOG DEVICES', 'ARCHER DANIELS MDLND', 'Automatic Data Processing, Inc.', 'Autodesk, Inc.', 'AMEREN CP', 'AMER ELECTRIC POW CO', 'AES CORPORATION', 'AETNA INC. NEW', 'A F L A C INC', 'ALLERGAN INC', 'AMER INTL GROUP INC', 'APT INV & MNGMNT CO', 'ASSURANT INC', 'Akamai Technologies, Inc.', 'A K STEEL HLDG CORP', 'ALLSTATE CP', 'Altera Corporation', 'Applied Materials, Inc.', 'ADV MICRO DEVICES', 'Amgen Inc.', 'AMERIPRISE FINANCIAL', 'AMER TOWER CP', 'Amazon.com, Inc.', 'AUTONATION INC', 'ABERCROMBIE & FITCH', 'AON CORP', 'APACHE CP', 'ANADARKO PETROLEUM', 'AIR PRODUCTS CHEM', 'AMPHENOL CP', 'Apollo Group, Inc.', 'ALLEGHENY TECH NEW', 'AVALONBAY CMTYS', 'AVON PRODUCTS INC', 'AVERY DENNISON CP', 'AMER EXPRESS INC', 'ALLEGHENY ENERGY INC', 'AUTOZONE INC', 'BOEING CO', 'BK OF AMERICA CP', 'BAXTER INTL INC', 'Bed Bath & Beyond Inc.', 'BB&T CP', 'BEST BUY CO INC', 'BARD C R INC', 'BLACK DECKER CP', 'BECTON DICKINSON CO', 'FRANKLIN RES INC', 'BROWN FORMAN INC B', 'BAKER HUGHES INTL', 'BIG LOTS INC', 'Biogen Idec Inc', 'BJ SERVICES CO', 'BANK OF NY MELLON CP', 'BALL CP', 'B M C SOFTWARE', 'BEMIS CO INC', 'BRISTOL MYERS SQIBB', 'BURLINGTN N SANTE FE', 'Broadcom Corporation', 'BOSTON SCIENTIFIC CP', 'PEABODY ENERGY CORP', 'BOSTON PPTYS INC', 'CITIGROUP INC', 'CA Inc.', 'CONAGRA FOOD INC', 'CARDINAL HEALTH INC', 'CAMERON INTL CP', 'CATERPILLAR INC', 'CHUBB CP THE', 'COOPER INDS CL A', 'CB RICHARD ELLIS GRP', 'CBS CORP CL B', 'COCA COLA ENTRPR INC', 'CARNIVAL CORP', 'CONSTELLATION ENGY', 'Celgene Corporation', 'Cephalon, Inc.', 'CF IND HLDGS INC', 'CHESAPEAKE ENERGY CP', 'C.H. Robinson Worldwide, Inc.', 'CIGNA CP', 'Ciena Corporation', 'Cincinnati Financial Corporatio', 'CIT GROUP INC (DEL)', 'COLGATE PALMOLIVE', 'CLOROX CO', 'COMERICA INC', 'Comcast Corporation', 'CME Group Inc.', 'CUMMINS INC', 'CMS ENERGY CP', 'CENTERPOINT ENERGY', 'CONS ENERGY INC', 'CAPITAL ONE FINANCIA', 'CABOT OIL GAS CP', 'COACH INC', 'ROCKWELL COLLINS INC', 'CONOCOPHILLIPS', 'Costco Wholesale Corporation', 'COVIDIEN LTD', 'CAMPBELL SOUP CO', 'Compuware Corporation', 'SALESFORCE.COM INC', 'COMPUTER SCIENCES CP', 'Cisco Systems, Inc.', 'C S X CP', 'Cintas Corporation', 'CENTURYTEL INC', 'Cognizant Technology Solutions ', 'CENTEX CP', 'Citrix Systems, Inc.', 'CONVERGYS CP', 'COVENTRY HLTH CARE', 'CVS CAREMARK CP', 'CHEVRON CORP', 'DOMINION RES NEW', 'DU PONT E I DE NEM', 'DEERE CO', 'Dell Inc.', 'DEAN FOODS CO', 'DISCOVER FIN SVCS', 'QUEST DIAGNOSTC', 'D R HORTON INC', 'DANAHER CP', 'WALT DISNEY-DISNEY C', 'THE NEW D&B CORP', 'DENBURY RES INC (HLD', 'DIAMOND OFFSHORE DRL', 'DOVER CP', 'DOW CHEMICAL', 'DR PEPPER SNAPPLE GP', 'DARDEN RESTAURANTS', 'D T E ENERGY CO HLDG', 'The DIRECTV Group, Inc.', 'DUKE ENERGY CP HL CO', 'DAVITA INC', 'DEVON ENERGY CP (OK)', 'DYNEGY INC CL A NEW', 'eBay Inc.', 'ECOLAB INC', 'CONS EDISON INC', 'EQUIFAX INC', 'EDISON INTL', 'EASTMAN KODAK CO', 'ESTEE LAUDER COS INC', 'E M C CP', 'EASTMAN CHEM CO', 'EMERSON ELEC CO', 'EOG RESOURCES INC', 'EL PASO CORPORATION', 'EMBARQ CORP', 'EQUITY RESIDENTAL', 'EQT CORPORATION', 'Electronic Arts Inc.', 'Express Scripts, Inc.', 'ENSCO INTL INC', 'E', 'EATON CP', 'ENTERGY CP', 'EXELON CORPORATION', 'Expeditors International of Was', 'Expedia, Inc.', 'FORD MOTOR CO', 'Fastenal Company', 'FREEPORT MCMORAN B', 'FAMILY DOLLAR STORES', 'FEDEX CORP', 'FIRSTENERGY CP', 'FIRST HORIZON NTL CP', 'FEDERATED INV INC', 'FIDELITY NAT INF SVC', 'Fiserv, Inc.', 'Fifth Third Bancorp', 'FLIR Systems, Inc.', 'FLUOR CP (NEW)', 'FLOWSERVE CP', 'FORTUNE BRANDS INC', 'F P L GROUP INC', 'FOREST LABS CL A', 'FRONTIER COMMUN CP', 'NICOR INC', 'GANNETT CO INC', 'GEN DYNAMICS CP', 'GEN ELECTRIC CO', 'Genzyme Corporation', 'Gilead Sciences, Inc.', 'GEN MILLS INC', 'CORNING INC', 'GEN MOTORS', 'GAMESTOP CORP', 'GENWORTH FINANCIAL', 'Google Inc.', 'GENUINE PARTS CO', 'GAP INC', 'GOODRICH CORPORATION', 'GOLDMAN SACHS GRP', 'GOODYEAR TIRE RUBBER', 'GRAINGER W W INC', 'HALLIBURTON CO', 'HARMAN INTL INDS', 'HASBRO INC', 'Huntington Bancshares Incorpora', 'Hudson City Bancorp, Inc.', 'HEALTH CARE REIT', 'HCP, INC.', 'HOME DEPOT INC', 'HESS CP', 'HARTFORD FIN SVC', 'HEINZ H J CO', 'HARLEY DAVIDSON', 'HONEYWELL INTL INC', 'STARWOOD HOTELS&RES', 'HEWLETT PACKARD CO', 'H R BLOCK INC', 'HORMEL FOODS CP', 'HARRIS CP', 'HOSPIRA INC', 'HOST HOTELS & RESORT', 'THE HERSHEY COMPANY', 'HUMANA INC', 'INTL BUSINESS MACH', 'INTERCNTNTLEXCHANGE', 'INTL FLAVORS FRAG', 'INTL GAME TECH', 'Intel Corporation', 'Intuit Inc.', 'INTL PAPER', 'INTERPUBLIC GROUP', 'INGERSOLL RAND LTD A', 'IRON MOUNTAIN (DEL)', 'Intuitive Surgical, Inc.', 'I T T CORPORATION', 'ILL TOOL WORKS INC', 'INVESCO PLC NEW', 'Sun Microsystems, Inc.', 'JABIL CIRCUIT INC', 'JOHNSON CONTROLS INC', 'PENNEY J C CO HOLDIN', 'JDS Uniphase Corporation', 'JACOBS ENGINEERNG GP', 'JOHNSON AND JOHNS DC', 'JANUS CAP GP CMN STK', 'JP MORGAN CHASE CO', 'NORDSTROM INC', 'KELLOGG CO', 'KB HOME', 'KEYCORP', 'KRAFT FOODS INC', 'KING PHARMACEUTICALS', 'KIMCO REALTY CP', 'KLA-Tencor Corporatio', 'KIMBERLY CLARK CP', 'COCA COLA CO THE', 'KROGER CO', 'KOHLS CP', 'LOEWS CP', 'LEGGETT PLATT INC', 'LENNAR CP CL A', 'LABORATORY CORP NEW', 'Life Technologies Corporation', 'L-3 COMM HLDGS INC', 'Linear Technology Corporation', 'LILLY ELI CO', 'LEGG MASON INC', 'LOCKHEED MARTIN CP', 'LINCOLN NATL CP', 'LORILLARD, INC', 'LOWES COMPANIES', 'LSI CORPORATION', 'LIMITED BRANDS INC', 'LEUCADIA NATL CP', 'SOUTHWEST AIRLINES', 'LEXMARK INTL INC', "MACY'S INC", 'MASTERCARD INC', 'MARRIOT INT CL A', 'MASCO CP', 'MATTEL INC', 'M B I A INC', 'MCDONALDS CP', 'Microchip Technology Incorporat', 'MCKESSON CORP', "MOODY'S CORP", 'MEREDITH CP', 'MEDTRONIC INC', 'MASSEY ENERGY CO', 'METLIFE INC', 'MCAFEE, INC', 'MCGRAW HILL COS THE', 'MEDCOHEALTH SOLUTNS', 'NEW M&I CORPORATION', 'MILLIPORE CP', 'MCCORMICK & CO', 'MARSH MCLENNAN CO', '3M COMPANY', 'ALTRIA GROUP INC', 'Molex Incorporated', 'MONSANTO COMPANY', 'MOTOROLA INC', 'MERCK CO INC', 'MARATHON OIL CORP', 'MORGAN STANLEY', 'Microsoft Corporation', 'M&T BANK CORP', 'MANITOWOC CO INC', 'MICRON TECHNOLOGY', 'MURPHY OIL CP HLDG', 'MEADWESTVACO CORP', 'MONSTER WORLDWIDE', 'Mylan Inc.', 'NOBLE ENERGY INC', 'NABORS INDS INC NEW', 'The NASDAQ OMX Group, Inc.', 'NEWMONT MIN CP (HLDG', 'NISOURCE INC HLDG CO', 'NIKE INC CL B', 'NORTHROP GRUM HOL CO', 'NATL OILWELL VARCO', 'Novell, Inc.', 'NORFOLK SO CP', 'NATL SEMICONDUCTOR', 'NetApp, Inc.', 'Northern Trust Corporation', 'NORTHEAST UTIL', 'NUCOR CP', 'NVIDIA Corporation', 'Novellus Systems, Inc.', 'NEWELL RUBBERMAID', 'News Corporation', 'N Y TIMES CL A', 'NYSE EURONEXT', 'OFFICE DEPOT INC', 'OWENS ILLINOIS', 'OMNICOM GP INC', 'Oracle Corporation', "O'Reilly Automotive, Inc.", 'OCCIDENTAL PET', 'Paychex, Inc.', "People's United Financial, Inc.", 'PEPSI BOTTLING GRP', 'PITNEY BOWES INC', 'PACCAR Inc.', 'PG&E CP', 'PLUM CREEK TIM REIT', 'PRECISION CASTPARTS', 'Patterson Companies Inc.', 'PUB ENTRPR GP', 'PEPSICO INC', 'PFIZER INC', 'PRINCIPAL FINL GROUP', 'PROCTER GAMBLE CO', 'PROGRESS ENERGY INC', 'PROGRESSIVE CP', 'PARKER HANNIFIN CP', 'PULTE HOMES, INC.', 'PERKIN ELMER INC', 'PROLOGIS SBI', 'PALL CP', 'PHILIP MORRIS INTL', 'P N C FIN SVCS GR', 'PINNACLE WEST CAP', 'PEPCO HOLDINGS INC', 'P P G IND', 'PPL CORP', 'PRUDENTIAL FINCL INC', 'PUBLIC STG', 'PACTIV CORP', 'PRAXAIR INC', 'PIONEER NATURAL RES', 'QWEST COMM INTL INC', 'QUALCOMM Incorporated', 'QLogic Corporation', 'RYDER SYSTEM INC', 'REYNOLDS AMERICAN', 'ROWAN COS INC', 'REGIONS FINANCIAL CP', 'ROBERT HALF INTL INC', 'RALPH LAUREN POLO CP', 'ROCKWELL AUTOMAT INC', 'RANGE RES CORP', 'RR DONNELLEY SONS', 'REPUBLIC SVCS INC', 'RADIOSHACK CORP', 'RAYTHEON CO (NEW)', 'IMS HEALTH INC', 'SPRINT NXTEL CP', 'Starbucks Corporation', 'SCANA CP NEW', 'The Charles Schwab Corporation', 'SPECTRA ENERGY', 'SEALED AIR CP NEW', 'SCHERING PLOUGH CP', 'Sears Holdings Corporation', 'SHERWIN WILLIAMS CO', 'Sigma-Aldrich Corporation', 'SMITH INTL INC', 'SMUCKERS J M NEW', 'SCHLUMBERGER LTD', 'SARA LEE CP', 'SLM CORPORATION', 'SNAP ON INC', 'SanDisk Corporation', 'SCRIPPS NETWORKS INT', 'SOUTHERN CO', 'SIMON PPTY GRP INC', 'Staples, Inc.', 'Stericycle, Inc.', 'SEMPRA ENERGY', 'SUNTRUST BANKS', 'ST. JUDE MEDICAL', 'QUESTAR CP', 'STATE STREET CP', 'CONSTELLATION BRD A', 'SUNOCO INC', 'SUPERVALU INC', 'STANLEY WORKS THE', 'SOUTHWESTERN ENERGY', 'SAFEWAY STORES INC', 'STRYKER CP', 'Symantec Corporation', 'SYSCO CP', 'AT&T INC.', 'MOLSON COORS CO CL B', 'TERADATA CORP', 'TECO ENERGY INC', 'INTEGRYS ENERGY GRP', 'TYCO ELECTRONICS', 'TERADYNE INC', 'TARGET CP', 'TENET HLTHCRE CP', 'TITANIUM METALS CORP', 'TIFFANY AND CO', 'T J X COS INC', 'Tellabs, Inc.', 'TORCHMARK CP', 'THERMO FISHER SCIENT', 'T. Rowe Price Group, Inc.', 'THE TRAVELERS CO', 'TYSON FOODS INC CL A', 'TESORO CORP', 'TOTAL SYSTEM SVC INC', 'TIME WARNER CABLE', 'TIME WARNER INC NEW', 'TEXAS INSTRUMENTS', 'TEXTRON INC', 'UNITEDHEALTH GROUP', 'UNUM GROUP', 'UNION PACIFIC', 'UNITED PARCEL SVC', 'US BANCORP', 'UNITED TECH', 'VARIAN MED SYS INC', 'V F CP', 'VIACOM INC CL B', 'VALERO ENERGY CP', 'VULCAN MATERIALS HC', 'VORNADO REALTY TRUST', 'VeriSign, Inc.', 'VENTAS INC', 'VERIZON COMMUN', 'WALGREEN CO', 'WATERS CP', 'WISCONSIN ENERGY CP', 'WELLS FARGO & CO NEW', 'Whole Foods Market, Inc.', 'MEMC ELECTRONIC MTRL', 'WHIRLPOOL CP', 'WINDSTREAM CORP', 'WELLPOINT INC.', 'WILLIAMS COS', 'WASTE MGMT INC', 'WAL MART STORES', 'WATSON PHARMACEUTCLS', 'WASHINGTN POST CO B', 'WESTERN UNION COMPAN', 'WEYERHAEUSER CO', 'WYETH', 'WYNDHAM WORLDWIDE', 'Wynn Resorts, Limited', 'UNITED STATES STEEL', 'XCEL ENERGY INC', 'XL CAPITAL LTD', 'Xilinx, Inc.', 'EXXON MOBIL CP', 'DENTSPLY International Inc.', 'XEROX CP', 'XTO ENERGY INC', 'Yahoo! Inc.', 'YUM BRANDS INC', 'Zions Bancorporation', 'ZIMMER HOLDINGS INC']


localmarkets = [dow_jones_names, nasdaq_names, sp500_names, ibex35_names, mc_names, ibexnm_names, ftse100_names, eurostoxx50_names, spmib_names, mib30_names, midex_names]
localids = [dow_jones_symbols, nasdaq_symbols, sp500_symbols, ibex35_symbols, mc_symbols, ibexnm_symbols, ftse100_symbols, eurostoxx50_symbols, spmib_symbols, mib30_symbols, midex_symbols]

