import os
import sys
import subprocess
import socket
import fcntl
import struct
import urllib
#from settings import security_mode
user_settings = []
add_for_files_url = []



def get_interface_ip(ifname):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    return socket.inet_ntoa(fcntl.ioctl(
                    s.fileno(),
                    0x8915,  # SIOCGIFADDR
                    struct.pack('256s', ifname[:15])
            )[20:24])
def get_lan_ip():
    ip = socket.gethostbyname(socket.gethostname())
    if ip.startswith("127.") and os.name != "nt":
        interfaces = ["eth0","eth1","eth2","wlan0","wlan1","wifi0","ath0","ath1","ppp0"]
        for ifname in interfaces:
                try:
                        ip = get_interface_ip(ifname)
                        break;
                except IOError:
                        pass
    return ip




def set_init_triples(user, presentation_id, dic_it, speaker):
    
    
    import user_profile
    user_settings = user_profile.Settings_data()
    add_for_files_url = "http://"+get_lan_ip()+":"+user_settings.http_server_port+"/"
    
    if user_settings.security_mode == True:
        try :
            from security import RSA
        except :
            user_settings.security_mode = False
    
    
    #try :
    if user_settings.security_mode == True:
        rsa = RSA(1024,4,65537)
        rsa.load_keys_from_file()
    #except :
        #rsa.generate () 
        #rsa.save_key_pair_into_files()
        dic_it[0] = rsa.encrypt(dic_it[0])
        dic_it[1] = rsa.encrypt(dic_it[1])
        dic_it[2] = rsa.encrypt(dic_it[2])
        dic_it[3] = rsa.encrypt(dic_it[3])
        dic_it[4] = rsa.encrypt(dic_it[4])
        dic_it[5] = rsa.encrypt(dic_it[5])
        dic_it[6] = rsa.encrypt(dic_it[6])
        dic_it[7] = rsa.encrypt(dic_it[7])
    
    
    
    #print rsa.decrypt(dic_it[0])
    #===========================================================================
    # for i in range(0,len(dic_it)):
    #    if i >= 0 and i<=7:
    #        dic_it[i] = rsa.encrypt(dic_it[i])
    #===========================================================================      
    language = "en"
    if dic_it[8] == "Finnish" :
		language = "fi"
    elif dic_it[8] == "English" :
		language = "en"
    elif dic_it[8] == "Russian" :
		language = "ru"
    if speaker:
	      	init_triples = [(("Space", "visited_by", user), "uri", "literal"),
                    ((user, "is", dic_it[1]), "uri", "literal"),
		        	((user, "photoURI", add_for_files_url + os.path.split(dic_it[0])[1]), "uri", "literal"),
		        	((user, "interests", dic_it[6]), "uri", "literal"),
		        	((user, "email", dic_it[2]), "uri", "literal"),
		        	((user, "phone", dic_it[3]), "uri", "literal"),
		        	((user, "language", language), "uri", "literal"),
		        	((user, "presents", presentation_id), "uri", "literal"),
		        	((presentation_id, "Title", dic_it[4]), "uri", "literal"),
		        	((presentation_id, "Keywords", dic_it[7]), "uri", "literal"),
                    ((presentation_id, "duration", dic_it[11]), "uri", "literal"),
                    ((presentation_id, "url", add_for_files_url + os.path.split(dic_it[5])[1]), "uri", "literal"),
                    ((presentation_id, "video_url", add_for_files_url + os.path.split(dic_it[13])[1]), "uri", "literal")]
    else:
	      	init_triples = [(("Space", "visited_by", user), "uri", "literal"),
                    ((user, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type', 
                      'http://www.smartconference.org/ontologies/smartconference.owl#Spectator'), "uri", "literal"),
                    ((user, "is", dic_it[1]), "uri", "literal"),
		        	((user, "photoURI", add_for_files_url + os.path.split(dic_it[0])[1]), "uri", "literal"),
		        	((user, "interests", dic_it[6]), "uri", "literal"),
		        	((user, "email", dic_it[2]), "uri", "literal"),
		        	((user, "phone", dic_it[3]), "uri", "literal"),
		        	((user, "language", language), "uri", "literal"),
                    ((user, "presents", "None"), "uri", "literal")]

    return init_triples

def open_AVI(path):
	command = "kmplayer -fs " + path + " &" #http://192.168.0.101/phpwcms/Nokia/1.avi"
	try:
		retcode = subprocess.call(command, shell=True)
		if retcode == 0:
			print "play video file"
	except Exception, e:
           print "error play video file"
    #os.system("vlc --play-and-exit --fullscreen http://192.168.0.177/var/www/1.avi")

def get_init_triples_from_ss(item, node, ss_handle):
        qs = node.CreateQueryTransaction(ss_handle)
        result1 = qs.rdf_query([((item, "is", None), "literal")])
        UserName = ''
        for item1 in result1:
            UserName = item1[0][2]
        result1 = qs.rdf_query([((item, "presents", None), "literal")])
        PresentationID = ""
        for item1 in result1:
            PresentationID = item1[0][2]
        result1 = qs.rdf_query([((PresentationID, "Title", None), "literal")])
        PresentationTitle = ""
        for item1 in result1:
            PresentationTitle = item1[0][2]
        result1 = qs.rdf_query([((item, "photoURI", None), "literal")])
        photo = ''
        for item1 in result1:
            photo = item1[0][2]
        result1 = qs.rdf_query([((item, "interests", None), "literal")])
        interest = ''
        for item1 in result1:
            interest = item1[0][2]
        result1 = qs.rdf_query([((item, "phone", None), "literal")])
        phone = ''
        for item1 in result1:
            phone = item1[0][2]
        result1 = qs.rdf_query([((item, "email", None), "literal")])
        email = ''
        for item1 in result1:
            email = item1[0][2]
        result1 = qs.rdf_query([((PresentationID, "Keywords", None), "literal")])
        Keywords = ""
        for item1 in result1:
            Keywords = item1[0][2]
        result1 = qs.rdf_query([((PresentationID, "duration", None), "literal")])
        Duration = ""
        for item1 in result1:
            Duration = item1[0][2]
        result1 = qs.rdf_query([((PresentationID, "url", None), "literal")])
        pres_url = ""
        for item1 in result1:
            pres_url = item1[0][2]
            
        init_triples = [((item, "is", UserName), "uri", "literal"),
                        ((item, "photoURI", photo), "uri", "literal"),
                        ((item, "interests", interest), "uri", "literal"),
                        ((item, "email", email), "uri", "literal"),
                        ((item, "phone", phone), "uri", "literal"),
                        ((item, "language", "None"), "uri", "literal"),
                        ((item, "presents", PresentationID), "uri", "literal"),
                        ((PresentationID, "Title", PresentationTitle), "uri", "literal"),
                        ((PresentationID, "Keywords", Keywords), "uri", "literal"),
                        ((PresentationID, "duration", Duration), "uri", "literal"),
                        ((PresentationID, "url", pres_url), "uri", "literal")]
        node.CloseQueryTransaction(qs)
        return init_triples

def set_presentation(dic_it):
    import user_profile
    user_settings = user_profile.Settings_data()
    add_for_files_url = "http://"+get_lan_ip()+":"+user_settings.http_server_port+"/"
    presentation = [(('PresentationURI', 'is', add_for_files_url + os.path.split(dic_it[5])[1]), "uri", "literal")]
    return presentation



def get_inf(filename):
	infile = None
        infile = open(filename, 'rb')
        if infile != None :
            string = infile.read()
            j = 0
            el = []
            for i in range(0,len(string)):
            	if string[i] == ';':
            		tmp = string[j:i]
            		j=i+1
            		el.append(tmp)
            infile.close()
            return el

def parse_rule(rule):
    subject = ""
    predicate = ""
    object = ""
    current_string = ""
    for item in rule:
        if item != ",":
           if item != " ":
              current_string = current_string + item
        else:
             if subject == "":
                subject = current_string
             else:
                 if predicate == "":
                    predicate = current_string
             current_string = ""
    object = current_string

    #print "Subject: ", subject, "Predicate: ", predicate, "Object: ", object
    return subject, predicate, object

def timeslot2time(timeslot,unode, uss_handle):
    qs = unode.CreateQueryTransaction(uss_handle)
    result = qs.rdf_query([((timeslot, "is", None), "literal")])
    for item in result:
        unode.CloseQueryTransaction(qs)
        return item[0][2]
    unode.CloseQueryTransaction(qs)

def progress(bl, blsize, size):
    import time
    start_t = time.time()
    dldsize = min(bl*blsize, size)
    if size != -1:
      p = float(dldsize) / size
      try:
        elapsed = time.time() - start_t 
        est_t = elapsed / p - elapsed
      except:
        est_t = 0
      print "%6.2f %% %6.0f s %6.0f s %6i / %-6i bytes" % (
          p*100, elapsed, est_t, dldsize, size)
    else:
      print "%6i / %-6i bytes" % (dldsize, size)



def download_file(url,path):
    #import time
    try:
        urllib.urlretrieve(url, path)#,progress)
    #time.sleep(2)
        return 1
    except:
        return 0

def usersimulation(user, init_triples, presentation, unode, uss_handle):
    #from smart_m3 import Node
    import time
    import sys
    
    qs = unode.CreateQueryTransaction(uss_handle)
    result = qs.rdf_query([((None, "have", user), "literal")])
    for item in result:
    	TS = item[0][0]
    unode.CloseQueryTransaction(qs)
    
    timeslot_index = 0
    #print "Try to occupy timeslot: ", TS
    time_slot = [((TS,"is_occupied_by",user), "uri", "literal")]
    pro = unode.CreateInsertTransaction(uss_handle)
    pro.send(time_slot, confirm = True)
    unode.CloseInsertTransaction(pro)

    old = get_init_triples_from_ss(user, unode, uss_handle)
    
    cng = unode.CreateRemoveTransaction(uss_handle)
    cng.remove(old, confirm = True)
    unode.CloseRemoveTransaction(cng)
    
    pro = unode.CreateInsertTransaction(uss_handle)
    pro.send(init_triples, confirm = True)
    unode.CloseInsertTransaction(pro)

