/*
 * This file is part of MapWidget
 *
 * Copyright (C) 2007 Pekka Rönkkö (pronkko@gmail.com).
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <libosso.h>
#include <stdlib.h>
#include <hildon/hildon.h>
#include <gtk/gtkenums.h>
#include <gdk/gdkkeysyms.h>
#include <errno.h>
#include "map_widget.h"

const gchar * TEST_MAP_DBUS_SERVICE = "org.cityguide.simplemapper";
const gchar * TEST_MAP_DBUS_OBJECT_PATH = "/org/cityguide/simplemapper";
const gchar * TEST_MAP_DBUS_INTERFACE = "org.cityguide.simplemapper";

GtkWidget* label_coord;

typedef struct _Adata Adata;
struct _Adata 
{
    GtkWidget *window;
    GtkWidget *table;

    GtkWidget *dmap;
    osso_context_t *osso;
    GtkWidget* label_curr_zoom;
    GtkWidget* entry_maptype;
};
gboolean is_fullscreen;

gint dbus_req_handler(const gchar * interface, const gchar * method, GArray * arguments, gpointer data, osso_rpc_t * retval) {
	return OSSO_OK;
}

static gboolean window_state_event(GtkWidget* widget, GdkEventWindowState* event, HildonWindow* window) {
	if (event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) {
		is_fullscreen = event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN;
	}

	return FALSE;
}

static gboolean key_press_event(GtkWidget* widget, GdkEventKey* event, HildonWindow* window) {
	switch (event->keyval) {
		case GDK_F6:
			if (is_fullscreen) {
				gtk_window_unfullscreen(GTK_WINDOW(window));
			} else {
				gtk_window_fullscreen(GTK_WINDOW(window));
			}
			return TRUE;
	}

	return FALSE;
}


void screen_clicked(GtkWidget *dmap, gint x, gint y, gfloat lat, gfloat lon)
{
    printf("\n\n x/y: %d/%d ja lat/lon %f/%f\n",x,y,lat,lon);
    gtk_label_set_text(GTK_LABEL(label_coord),g_strdup_printf("lat:%f , lon: %f",lat,lon));



    MapPoint *center;
    center = g_new0(MapPoint, 1);
    center->latitude = lat;
    center->longitude =lon;

    map_widget_set_current_location(dmap,center);
 

}
void zoom_in(GtkWidget * widget, gpointer data)
{
    guint zoom;
    Adata *adata= (Adata*)data;


    zoom = map_widget_get_current_zoom_level(adata->dmap) + 1;

    if (zoom >1 && zoom <18)
    {
    	map_widget_set_zoom(adata->dmap, zoom);
	gtk_label_set_text(GTK_LABEL(adata->label_curr_zoom),g_strdup_printf("%d",zoom));
    }



}
void zoom_out(GtkWidget * widget, gpointer data)
{
    guint zoom;
    Adata *adata= (Adata*)data;

    zoom = map_widget_get_current_zoom_level(adata->dmap) - 1;

    if (zoom >1 && zoom <18)
    {
    	map_widget_set_zoom(adata->dmap, zoom);
	gtk_label_set_text(GTK_LABEL(adata->label_curr_zoom),g_strdup_printf("%d",zoom));
    }



}
void goto_lat_lon(GtkWidget * widget, gpointer data)
{
    Adata *adata = (Adata*)data;

    GtkWidget *dialog = NULL;
    GtkWidget *table = NULL;
    GtkWidget *label = NULL;
    GtkWidget *entry_lat = NULL;
    GtkWidget *entry_lon = NULL;
    const gchar *buffer= NULL;

    MapPoint *center;
    center = g_new0(MapPoint, 1);

    dialog = gtk_dialog_new_with_buttons("Goto lat/lon", NULL,
					 GTK_DIALOG_MODAL |
					 GTK_DIALOG_DESTROY_WITH_PARENT,
					 GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
					 GTK_STOCK_CANCEL,
					 GTK_RESPONSE_REJECT, NULL);

    table = gtk_table_new(2, 2, TRUE);


    label = gtk_label_new("Lat:");
    gtk_misc_set_alignment((GtkMisc *) label, 0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);

    entry_lat = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(table), entry_lat, 1, 2, 0, 1);
    hildon_gtk_entry_set_input_mode (GTK_ENTRY(entry_lat),  HILDON_GTK_INPUT_MODE_NUMERIC | HILDON_GTK_INPUT_MODE_SPECIAL );

    label = gtk_label_new("Lon:");
    gtk_misc_set_alignment((GtkMisc *) label, 0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

    entry_lon = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(table), entry_lon, 1, 2, 1, 2);
    hildon_gtk_entry_set_input_mode (GTK_ENTRY(entry_lon),  HILDON_GTK_INPUT_MODE_NUMERIC | HILDON_GTK_INPUT_MODE_SPECIAL );
 
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), table);

    gtk_widget_show_all(table);
    gtk_widget_show_all(dialog);

    if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT) {

	buffer = gtk_entry_get_text(GTK_ENTRY(entry_lat));
	center->latitude = atof(buffer);

	buffer = gtk_entry_get_text(GTK_ENTRY(entry_lon));
	center->longitude = atof(buffer);

    map_widget_show_location(adata->dmap , center);
    }
    gtk_widget_destroy(dialog);
}
void change_maptype(GtkWidget * widget, gpointer data)
{
    Adata *adata = (Adata*)data;
    gchar *maptype;
    maptype = gtk_entry_get_text ( GTK_ENTRY (adata->entry_maptype) );

    map_widget_change_maptype(adata->dmap,maptype);
}
int main(int argc, char **argv)
{

    gint maptileloader;
    
    /* if Maptile-loader not already running -> start 
	Maptile-loader */

    maptileloader = system("pidof maptile-loader");
    if ( maptileloader != 0)
        system("run-standalone.sh maptile-loader &");


    HildonProgram* program;
    GtkWidget *window;
    GtkWidget *table;
    GtkWidget *button;
    GtkWidget *dmap;
    GtkWidget* label;
    osso_context_t *_osso = NULL;

    Adata *adata;
    adata = g_new0(Adata, 1);
 
    MapPoint *center;
    center = g_new0(MapPoint, 1);
    center->latitude = 65.013;
    center->longitude = 25.509;

    gtk_init(&argc, &argv);

    _osso = osso_initialize ( TEST_MAP_DBUS_SERVICE, "0.1", TRUE, NULL );
    g_assert ( _osso );


    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("Simple Mapper");

//    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    window = hildon_window_new();
    hildon_program_add_window(program, HILDON_WINDOW(window));
    table = gtk_table_new(20, 20, TRUE);
    gtk_container_add(GTK_CONTAINER(window), table);
    g_signal_connect(window, "destroy", G_CALLBACK(gtk_main_quit), NULL);
    g_signal_connect(G_OBJECT(window), "window_state_event", G_CALLBACK(window_state_event), window);
    g_signal_connect(G_OBJECT(window), "key_press_event", G_CALLBACK(key_press_event), window);

    /* Create base of new MapWidget and attach that to toplevel window */

    dmap = map_widget_create();
    gtk_table_attach_defaults(GTK_TABLE(table), dmap, 0, 20, 2, 18);


    /* After MapWidget attached to toplevel, must call map_widget_new_ function
       with parameters wanted. 
       This case parameters are :
	@center = MapPoint, that contains coordinates in WGS84 form.  
	@zoom level = 0.0 whole world .
	@orientation = Only MAP_ORIENTATION_NORTH supported.
	@maptype = Maptype used. Check maptile-loader.conf for supported maptypes.
	@osso = osso
    */
    map_widget_new_from_center_zoom_type(dmap, center, 14.0,
					 MAP_ORIENTATION_NORTH,
					 "Open Street",_osso);

    
    label_coord = gtk_label_new(g_strdup_printf("Lat: %f | Lon: %f",center->latitude,center->longitude));
    gtk_table_attach_defaults(GTK_TABLE(table), label_coord, 0, 9, 0, 2);

    /* fill Adata struct */   
    adata->window = window;
    adata->table = table;
    adata->dmap = dmap;
    adata->osso = _osso;



    button = gtk_button_new_with_label("Goto lat/lon");
    gtk_table_attach_defaults(GTK_TABLE(adata->table), button, 0, 4, 18, 20);
    g_signal_connect(G_OBJECT(button), "clicked",
		     G_CALLBACK(goto_lat_lon), adata);

    button = gtk_button_new_with_label("Zoom Out");
    gtk_table_attach_defaults(GTK_TABLE(adata->table), button, 5, 8, 18, 20 );
    g_signal_connect(G_OBJECT(button), "clicked",
		     G_CALLBACK(zoom_out), adata);

    adata->label_curr_zoom = gtk_label_new(g_strdup_printf("%d",map_widget_get_current_zoom_level (adata->dmap)));
       gtk_table_attach_defaults(GTK_TABLE(adata->table), adata->label_curr_zoom, 8, 10, 18, 20);

    button = gtk_button_new_with_label("Zoom In");
    gtk_table_attach_defaults(GTK_TABLE(adata->table), button, 10, 13, 18, 20 );
    g_signal_connect(G_OBJECT(button), "clicked",
		     G_CALLBACK(zoom_in), adata);

    label = gtk_label_new("Maptype:");
       gtk_table_attach_defaults(GTK_TABLE(adata->table), label, 9, 12 ,0, 2 );

    adata->entry_maptype =  gtk_entry_new();
       gtk_table_attach_defaults(GTK_TABLE(adata->table), adata->entry_maptype, 12, 17, 0, 2 );
    gtk_entry_set_text (GTK_ENTRY (adata->entry_maptype),"Open Street" );

    button = gtk_button_new_with_label("Change");
    gtk_table_attach_defaults(GTK_TABLE(adata->table), button, 17, 20, 0, 2 );
    g_signal_connect(G_OBJECT(button), "clicked",
		     G_CALLBACK(change_maptype), adata);

    map_widget_set_screen_clicked_cb(adata->dmap, screen_clicked);
    gtk_widget_show_all(window);
    gtk_main();

    return 0;
}
