# -*- coding: utf-8 -*-
import gdata.youtube.service

#TODO: set the geodata, support for private videos, etc.

name = 'Youtube'
icon = 'youtube.png'
service = 'youtube'
has_settings = True

#Categories: ['term', 'label']
yt_cats = {
'Film & Animation':'Film',
'Autos & Vehicles':'Autos',
'Music':'Music',
'Pets & Animals':'Animals',
'Sports':'Sports',
'Travel & Events':'Travel',
'Gaming':'Games',
'Comedy':'Comedy',
'People & Blogs':'People', 
'News & Politics':'News',
'Entertainment':'Entertainment',
'Education':'Education',
'Howto & Style':'Howto',
'Nonprofits & Activism':'Nonprofit',
'Science & Technology':'Tech'
}

def get_initial_tags(filename):
    #[filename,title,summary,tags,category]
    tags = ['youtube', filename, '', '', '', 'People & Blogs']  
    return tags

def test_upload_needs(settings, all_files):
    ind, username, password = settings.get_from_file()
    
    if username == '' or password == '':
        return 'Empty username or password'

    for image in all_files:
        if image[2]=='' or image[3]=='' or image[4]=='' or image[5]=='':
            return "Please, add all fields to your videos"
    
    return True

def do_upload(image, dbpath):
    #FIXME: not login everytime
    settings = Settings(dbpath)
    ind, username, password = settings.get_from_file()
    youtube = Youtube(username, password)
    filename = image[1]
    title = image[2]
    desc = image[3]
    tags = image[4]
    cat = image[5]
    upload = youtube.upload_video(filename, title, desc, tags, cat)  
    return upload

def get_allowed_ftypes():
    sf = {
        'mkv': 'video/x-matroska', 
        'mov': 'video/quicktime',
        'qt': 'video/quicktime',        
        'mpg': 'video/mpeg',
        'mpeg': 'video/mpeg',
        'mpe': 'video/mpeg',
        'mp4': 'video/mp4',
        'avi': 'video/x-msvideo',
        'wmv': 'video/x-ms-wmv',
        '3g2': 'video/3gpp2',
        '3gp': 'video/3gpp',
        'm4v': 'video/m4v',
        'swf': 'application/x-shockwave-flash',
        'flv': 'video/x-flv'
        }    
    return sf

class Settings: 
    def __init__(self, dbpath):
        self.dbpath = dbpath
       
    def show_ui(self):
        import gtk       
        dialog = gtk.Dialog(title='Youtube settings', parent=None, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(500, 300)
        label1 = gtk.Label('Username')
        label2 = gtk.Label('Password')
        
        ind, username, password = self.get_from_file()
        
        entry1 = gtk.Entry()
        entry1.set_size_request(-1, 38)
        entry1.set_text(username)
        entry2 = gtk.Entry()
        entry2.set_size_request(-1, 38)
        entry2.set_text(password)
        entry2.set_property('hildon-input-mode', 'HILDON_GTK_INPUT_MODE_FULL')
        entry2.set_visibility(False)
        
        dialog.vbox.pack_start(label1, False, False, 10)
        dialog.vbox.pack_start(entry1, False, False, 10)        
        dialog.vbox.pack_start(label2, False, False, 10)        
        dialog.vbox.pack_start(entry2, False, False, 10)
               
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            self.save_to_file(entry1.get_text(), entry2.get_text())
            print entry1.get_text(), entry2.get_text()
        
        dialog.destroy()

    def get_from_file(self):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()        
        tables = []
        for table in cursor_sql.execute('select * from sqlite_master'):
            tables.append(table[1])

        if not 'Youtube' in tables:
            print 'creating new'
            cursor_sql.execute('CREATE TABLE Youtube (id INTEGER PRIMARY KEY, \
                            username text, password text)')                
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO Youtube VALUES (?, ?, ?)', \
                            (1, '', ''))  
            settings_db.commit()

            
        settings = []
        for table in settings_db.execute('select * from Youtube'):
            settings.append(table)
        
        settings_db.close()
        
        return settings[0]
    
    def save_to_file(self, username, password):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO Youtube VALUES (?, ?, ?)', \
                            (1, username, password))  
        settings_db.commit()
        cursor_sql.close()


class ADV_TAGS:
    def show_ui(self, image, kind, win):
        import gtk

        dialog = gtk.Dialog(title='Youtube advanced', parent=win, flags=0, buttons=("Save", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(600, 300)


        label1 = gtk.Label("Category")
        category_cb = gtk.combo_box_new_text()
        cat_keys = yt_cats.keys()
        for i in cat_keys:
           category_cb.append_text(i)
        if kind == 'simple':
            category_cb.set_active(cat_keys.index(image[5]))
        else:
            category_cb.set_active(0)            

        dialog.vbox.pack_start(label1, True, True, 0)  
        dialog.vbox.pack_start(category_cb, True, True, 0)   
            
        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_OK:
            #image=['youtube',filename,title,summary,tags,category]
            if kind == 'simple':
                image[5] = category_cb.get_active_text()
            else:
                cat_act = category_cb.get_active_text()
                for i in image:
                    i[5] = cat_act
            dialog.hide()
            return image
        else:
            dialog.hide()
            return image
        
        dialog.hide()


class Youtube:
    def __init__(self, username, password):

        self.service = gdata.youtube.service.YouTubeService()
        self.service.email = username
        self.service.password = password
        self.service.source = 'SharePy'
        self.service.developer_key = 'AI39si6_MBOWmevlE-WI3k6Me8lggQT88UjzrOIwB5TOVt7Siz7Ays0SOvZ4a3JCMtfQdmmZXFodIKFcJdFl_VMf113Xiw-QpQ'
        self.service.client_id = 'ytapi-DanielMartinYerg-SharePy-b78at369-0'
        self.service.ProgrammaticLogin()

    def upload_video(self, filename, title, summary, tags, category):
        my_media_group = gdata.media.Group(
            title=gdata.media.Title(text=title),
            description=gdata.media.Description(description_type='plain',
                                      text=summary),
            keywords=gdata.media.Keywords(text=tags),
            category=gdata.media.Category(
                text=yt_cats[category],
                scheme='http://gdata.youtube.com/schemas/2007/categories.cat',
                label=category),
            player=None)
        #gdata.media.Private
        #where = gdata.geo.Where()
        #where.set_location((37.0,-122.0))
        

        video_entry = gdata.youtube.YouTubeVideoEntry(media=my_media_group)
        #                                              geo=where)

        print video_entry
        try:
            new_entry = self.service.InsertVideoEntry(video_entry, filename)
            print new_entry
        except:
            new_entry = None
        
        return new_entry

