# -*- coding: utf-8 -*-
name = 'Blip.tv'
icon = 'blip.png'
service = 'blip'
has_settings = True

BLIP_UPLOAD_URL = "http://blip.tv/file/post"

MULTIPART_BOUNDARY = "-----------$$SomeFancyBoundary$$"

licenses = {
'No license (All rights reserved)':'-1',
'Creative Commons Attribution 2.0':'1',
'Creative Commons Attribution-NoDerivs 2.0':'2',
'Creative Commons Attribution-NonCommercial-NoDerivs 2.0':'3',
'Creative Commons Attribution-NonCommercial 2.0':'4',
'Creative Commons Attribution-NonCommercial-ShareAlike 2.0':'5',
'Creative Commons Attribution-ShareAlike 2.0':'6',
'Public Domain':'7',
'Creative Commons Attribution 3.0':'9',
'Creative Commons Attribution-NoDerivs 3.0':'10',
'Creative Commons Attribution-NonCommercial-NoDerivs 3.0':'11',
'Creative Commons Attribution-NonCommercial 3.0':'12',
'Creative Commons Attribution-NonCommercial-ShareAlike 3.0':'13',
'Creative Commons Attribution-ShareAlike 3.0':'14'
}

categories = {
'Default Category':'-1',
'Comedy':'2',
'Politics':'3',
'Citizen Journalism':'4',
'Music and Entertainment':'5',
'Sports':'6',
'Technology':'7',
'Personal or Auto-biographical':'8',
'Videoblogging':'9',
'Conferences and Other Events':'10',
'Literature':'11',
'Food & Drink':'12',
'Gaming':'13',
'Science':'14',
'Friends':'15',
'School and Education':'16',
'Web Development and Sites':'17',
'The Mainstream Media':'18',
'Documentary':'19',
'Educational':'21',
'The Environment':'22',
'Religion':'23',
'Travel':'24',
'Health':'25',
'Business':'26',
'Art':'27',
'Movies and Television':'28'
}

def get_initial_tags(filename):
    #[filename,title,desc,tags,license,category]
    tags = ['blip', filename, '', '', '', 'No license (All rights reserved)', 'Default Category']
    return tags

def test_upload_needs(settings, all_files):
    ind, username, password = settings.get_from_file()
    
    if username == '' or password == '':
        return 'Empty username or password'

    return True

def do_upload(image, dbpath):
    settings = Settings(dbpath)
    ind, username, password = settings.get_from_file()
    filename = image[1]
    title = image[2]
    desc = image[3]
    tags = image[4]
    license_id = licenses[image[5]]
    category_id = categories[image[6]]
    bliptv = BlipTV()
    upload = bliptv.upload(username, password, filename, title, desc, tags, \
              license_id, category_id)
    return upload

def get_allowed_ftypes():
    sf = {
        'mov': 'video/quicktime',
        'qt': 'video/quicktime',        
        'mpg': 'video/mpeg',
        'mpeg': 'video/mpeg',
        'mpe': 'video/mpeg',
        'mp4': 'video/mp4',
        'avi': 'video/x-msvideo',
        'wmv': 'video/x-ms-wmv',
        '3g2': 'video/3gpp2',
        '3gp': 'video/3gpp',
        'm4v': 'video/m4v',
        'asf': 'video/x-ms-asf',
        'flv': 'video/x-flv',
        'pdf': 'application/pdf'
        }    
    return sf

class Settings:
    def __init__(self, dbpath):
        self.dbpath = dbpath
        
    def show_ui(self):
        import gtk
        dialog = gtk.Dialog(title='Blip.tv settings', parent=None, flags=0, buttons=("OK", gtk.RESPONSE_ACCEPT, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(500, 300)
        label1 = gtk.Label('Username')
        label2 = gtk.Label('Password')
        
        ind, username, password = self.get_from_file()
        
        entry1 = gtk.Entry()
        entry1.set_size_request(-1, 38)
        entry1.set_text(username)
        entry2 = gtk.Entry()
        entry2.set_size_request(-1, 38)
        entry2.set_text(password)
        entry2.set_property('hildon-input-mode', 'HILDON_GTK_INPUT_MODE_FULL')
        entry2.set_visibility(False)
        
        dialog.vbox.pack_start(label1, False, False, 10)
        dialog.vbox.pack_start(entry1, False, False, 10)        
        dialog.vbox.pack_start(label2, False, False, 10)        
        dialog.vbox.pack_start(entry2, False, False, 10) 
               
        dialog.show_all()
        result = dialog.run()
        if result == gtk.RESPONSE_ACCEPT:
            self.save_to_file(entry1.get_text(), entry2.get_text())
            print entry1.get_text(), entry2.get_text()
        
        dialog.destroy()

    def get_from_file(self):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()        
        tables = []
        for table in cursor_sql.execute('select * from sqlite_master'):
            tables.append(table[1])

        if not 'Blip' in tables:
            print 'creating new'
            cursor_sql.execute('CREATE TABLE Blip (id INTEGER PRIMARY KEY, \
                            username text, password text)')                
            settings_db.commit()
            cursor_sql.execute('REPLACE INTO Blip VALUES (?, ?, ?)', \
                            (1, '', ''))  
            settings_db.commit()

            
        settings = []
        for table in settings_db.execute('select * from Blip'):
            settings.append(table)
        
        settings_db.close()
        
        return settings[0]
    
    def save_to_file(self, username, password):
        import sqlite3
        settings_db = sqlite3.connect(self.dbpath)
        cursor_sql = settings_db.cursor()
        cursor_sql.execute('REPLACE INTO Blip VALUES (?, ?, ?)', \
                            (1, username, password))  
        settings_db.commit()
        cursor_sql.close()


class ADV_TAGS:
    def show_ui(self, image, kind, win):
        import gtk

        dialog = gtk.Dialog(title='Blip.tv advanced', parent=win, flags=0, buttons=("Save", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CANCEL))
        dialog.set_size_request(600, 300)

        label1 = gtk.Label("License")
        license_cb = gtk.combo_box_new_text()
        lic_keys = licenses.keys()
        for i in lic_keys:
            license_cb.append_text(i)        
        if kind == 'simple':
            license_cb.set_active(lic_keys.index(image[5]))
        else:
            license_cb.set_active(0)

        label2 = gtk.Label("Category")
        category_cb = gtk.combo_box_new_text()
        cat_keys = categories.keys()
        for i in cat_keys:
            category_cb.append_text(i)        
        if kind == 'simple':        
            category_cb.set_active(cat_keys.index(image[6]))
        else:
            category_cb.set_active(0)
        
        dialog.vbox.pack_start(label1, True, True, 0)
        dialog.vbox.pack_start(license_cb, True, True, 0)        
        dialog.vbox.pack_start(label2, True, True, 0)       
        dialog.vbox.pack_start(category_cb, True, True, 0)   
            
        dialog.show_all()
        result = dialog.run()

        if result == gtk.RESPONSE_OK:
            #image = ['blip',filename,title,desc,tags,license,category]
            if kind == 'simple':
                image[5] = license_cb.get_active_text()
                image[6] = category_cb.get_active_text()
            elif kind == 'multiple':
                for i in image:
                    i[5] = license_cb.get_active_text()
                    i[6] = category_cb.get_active_text()             
                
            dialog.hide()
            return image
        else:
            dialog.hide()
            return image
        
        dialog.hide()



class BlipTV:
#    Copyright 2008 Michael Fötsch <foetsch@yahoo.com>
#    
#    Permission is hereby granted, free of charge, to any person obtaining
#    a copy of this software and associated documentation files (the
#    "Software"), to deal in the Software without restriction, including
#    without limitation the rights to use, copy, modify, merge, publish,
#    distribute, sublicense, and/or sell copies of the Software, and to
#    permit persons to whom the Software is furnished to do so, subject to
#    the following conditions:
#    
#    The above copyright notice and this permission notice shall be included
#    in all copies or substantial portions of the Software.
#    
#    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
#    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
#    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
#    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
#    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
#    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    def PostMultipart(self, url, fields, files):
        import httplib, urlparse
        """@brief Send multi-part HTTP POST request
        
        @param url POST URL
        @param fields A dict of {field-name: value}
        @param files A list of [(field-name, filename)]
        @return Status, reason, response (see httplib.HTTPConnection.getresponse())
        """
        content_type = 'multipart/form-data; boundary=%s' % MULTIPART_BOUNDARY
        data = []
        for field_name, value in fields.iteritems():
            data.append('--' + MULTIPART_BOUNDARY)
            data.append('Content-Disposition: form-data; name="%s"' % field_name)
            data.append('')
            data.append(value)
        for (field_name, filename) in files:
            data.append('--' + MULTIPART_BOUNDARY)
            data.append('Content-Disposition: form-data; name="%s"; filename="%s"'
                        % (field_name, filename))
            data.append('Content-Type: %s' % self.GetMimeType(filename))
            data.append('')
            data.append(open(filename).read())
        data.append('--' + MULTIPART_BOUNDARY + '--')
        data.append('')
        data = "\r\n".join(data)

        host, selector = urlparts = urlparse.urlsplit(url)[1:3]
        h = httplib.HTTPConnection(host)
        h.putrequest("POST", selector)
        h.putheader("content-type", content_type)
        h.putheader("content-length", len(data))
        h.endheaders()
        h.send(data)
        response = h.getresponse()
        return response.status, response.reason, response.read()    

    def GetMimeType(self, filename):
        import mimetypes
        return mimetypes.guess_type(filename)[0] or 'application/octet-stream'

    def upload(self, username, password, filename, title, description, tags, \
              license_id, category_id):
        """@brief Upload to blip.tv
        
        @param video_id Either the item ID of an existing post or None to upload
            a new video
        @param username, password
        @param title New title of the post
        @param description New description of the post
        @param filename Filename of the video to upload (if a @a video_id is specified),
            this file is uploaded as an additional format to the existing post)
        @return Response data
        """
        fields = {
            "post": "1",
            "skin": "xmlhttprequest",
            "userlogin": "%s" % str(username),
            "password": "%s" % str(password),
            "item_type": "file",
            "title": "%s" % title.encode("utf-8"),
            "description": "%s" % description.encode("utf-8"),
            "topics": "%s" % tags.encode("utf-8"),
            "license": "%s" % license_id.encode("utf-8"),
            "categories_id": "%s" % category_id.encode("utf-8"),
            }

        file_field = "file"
        if filename:
            fields[file_field + "_role"] = "Web"
            files = [(file_field, filename)]
        else:
            files = []
        
        print "Posting to", BLIP_UPLOAD_URL
        print "Please wait..."
        status, reason, response = self.PostMultipart(BLIP_UPLOAD_URL, fields, files)
        print "Done."

        return response
