#!/usr/bin/env python2.5
# -*- coding: UTF8 -*-
# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# SharePy: Multimedia uploader to diverse services.
# Version 1.0
#

import gtk
import gobject
import thread
import os, sys
from plugins import _plugin_manager
try:
    import hildon
    HILDON = True
    print 'hildon, yes'
except:
    HILDON = False
    print 'hildon, no'
    
try:
    import osso
    OSSO = True
    osso_c = osso.Context("net.yerga.sharepy", "1.0", False)
except:
    OSSO = False

try:
    import mokoui
    MOKO = True
    print 'moko, yes'
except:
    MOKO = False
    print 'moko, no'

#detect if is ran locally or not
runningpath = sys.path[0]

if '/usr/share' in runningpath:
    running_locally = False
else:
    running_locally = True
    
if running_locally:
    imgdir = 'pixmaps/'
    pluginicondir = 'plugins/icons/'
else:
    imgdir = '/usr/share/sharepy/pixmaps/'
    pluginicondir = '/usr/share/sharepy/plugins/icons/'

configpath = os.path.expanduser('~')+'/.sharepy/'
if not os.path.exists(configpath):
    os.mkdir(configpath)
dbpath = configpath + 'settings.db'


all_files = []
gtk.gdk.threads_init()

class SharePy:

    def __init__(self):
        if HILDON:
            self.program = hildon.Program()
            self.program.__init__()
            gtk.set_application_name('')
            self.window = hildon.Window()
            self.program.add_window(self.window) 
        else:
            self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
            
        self.service = 'flickr'
        self.cancel_upload = False
        self.taggingbox = False
        self.imglistbox = False
        self.uploadbox = False
        
        self.window.set_default_size(800, 480)  
        self.window.set_title('SharePy')
        self.window.connect("destroy", self.on_quit)
        self.window.connect("key-press-event", self.on_key_press)
        self.window.connect("window-state-event", self.on_window_state_change)
        self.window_in_fullscreen = False
        
        if HILDON:
            menu = gtk.Menu()
            self.window.set_menu(menu)
            about_menu = gtk.ImageMenuItem("About")
            about_img = gtk.Image()    
            about_img.set_from_file(imgdir + 'about.png')         
            about_menu.set_image(about_img) 
            about_menu.set_size_request(-1, 55)
            about_menu.connect("activate", self.on_about)
               
            menu.append(about_menu)            
            menu.show_all()
        else:
            #TODO: create a gtk.menubar
            pass
        
        self.notebook = gtk.Notebook()
        self.notebook.set_show_border(False)
        self.notebook.connect("switch_page", self.on_main_ntbk_changed)
        self.notebook.set_show_tabs(False)
        
        vbox1 = gtk.VBox()
        
        self.label1 = gtk.Label('Select a service where to upload files:')
        vbox1.pack_start(self.label1, False, False, 0)
        
        self.count_label = gtk.Label()
        self.count_label.set_text("0 files")
        
        self.back_btn = gtk.Button('Back')
        self.back_btn.connect("clicked", self.on_back_clicked)
        self.next_btn = gtk.Button('Next')
        self.next_btn.connect("clicked", self.on_next_clicked)
        self.manage_btn = gtk.Button('Manage Services')
        self.manage_btn.connect("clicked", self.manage_prefs)
        
        if MOKO:
            self.swin = mokoui.FingerScroll()
            self.swin.set_property('mode', 1)
        else:
            self.swin = gtk.ScrolledWindow()
            #TODO: quit the scrollbars, etc.
        
        self.services_trv = gtk.TreeView()
        self.services_trv.set_rubber_banding(True)
        self.services_trv.set_headers_visible(False)
        self.services_model = self.__create_services_model()
        self.services_trv.set_model(self.services_model)
        self._services_trv_columns(self.services_trv) 
            
        self.add_initial_plugins()    
        
        self.swin.add(self.services_trv)
        
        self.notebook.append_page(self.swin, gtk.Label('main'))
        
        vbox1.pack_start(self.notebook, True, True, 0)
        
        self.mainbar = gtk.HBox()
        self.mainbar.set_homogeneous(True)
        self.mainbar.set_size_request(-1, 55)
        vbox1.pack_start(self.mainbar, False, False, 0)
        
        self.mainbar.pack_start(self.count_label, False, False, 4)
        self.mainbar.pack_start(self.back_btn, True, True, 0)        
        self.mainbar.pack_start(self.next_btn, True, True, 0)
        self.mainbar.pack_start(self.manage_btn, True, True, 0)
        
        self.window.add(vbox1)
        
        self.window.show_all()

    def on_main_ntbk_changed(self, widget, dummy, page):
        if page == 0:
            self.label1.show()
            self.next_btn.set_label("Next")
            self.manage_btn.show()
            self.count_label.hide()
            self.back_btn.hide()
            self.mainbar.show()
            self.next_btn.show()
        elif page == 1:
            self.label1.hide()
            self.next_btn.set_label("Upload")
            self.manage_btn.hide()
            self.count_label.show()
            self.back_btn.show()
            self.mainbar.show()
            self.next_btn.show()

    def __create_services_model(self):
        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING, gobject.TYPE_STRING)
        return lstore

    def _services_trv_columns(self, treeview):       
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn('', renderer, pixbuf=0)
        column.set_expand(True)
        treeview.append_column(column)  
        
        renderer = gtk.CellRendererText()
        renderer.set_property('scale', 2)
        column = gtk.TreeViewColumn('Name', renderer, text=1)
        column.set_expand(True)
        treeview.append_column(column)

        column = gtk.TreeViewColumn('service', gtk.CellRendererText(), text=2)
        column.set_visible(False)
        treeview.append_column(column)
      

    def add_initial_plugins(self):
        pluglist = _plugin_manager.get_names_and_icons()

        for i in range(len(pluglist)):
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(pluginicondir + \
                                    pluglist[i][1], 90, 90)
            niter = self.services_model.append() 
            self.services_model.set(niter, 0, pixbuf, 1, pluglist[i][0], 2, \
                                    pluglist[i][2])        

    def on_next_clicked(self, widget):
        page = self.notebook.get_current_page()
        if page == 0:
            selection = self.services_trv.get_selection()
            if selection.count_selected_rows() == 0:
                utils.show_info_banner(widget, 'No selected item') 
                return

            prev_service = self.service
            self.service, a, b = utils.get_selected_from_treeview(self.services_trv, \
                                                        self.services_model, 2)
            #Check if it's created
            if self.imglistbox:
                self.notebook.set_current_page(self.notebook.page_num(self.imglistbox))
                if prev_service != self.service:
                    del all_files[:]
                    self.imglist_model.clear()
            else:
                self.create_imglist_page()
                self.notebook.append_page(self.imglistbox, gtk.Label('imglist'))
                self.notebook.show_all()
                self.notebook.set_current_page(self.notebook.page_num(self.imglistbox))

        if page == 1:
            if self.test_upload_info() is not None:
                self.mainbar.hide()
                if self.uploadbox:
                    self.notebook.set_current_page(self.notebook.page_num(self.uploadbox))
                else:
                    self.create_upload_page()
                    self.notebook.append_page(self.uploadbox, gtk.Label('upload'))
                    self.notebook.show_all()
                    self.notebook.set_current_page(self.notebook.page_num(self.uploadbox))
                self.upload_files()

    def on_back_clicked(self, widget):
        page = self.notebook.get_current_page()
        
        if page == 2:
            self.notebook.set_current_page(1)
        elif page == 3:
            self.notebook.set_current_page(1)
        else:
            self.notebook.prev_page()

    def create_imglist_page(self):
        self.imglistbox = gtk.HBox()

        if MOKO:
            swin = mokoui.FingerScroll()
            swin.set_property('mode', 1)
        else:
            swin = gtk.ScrolledWindow()
            #TODO: quit the scrollbars, etc.
        
        self.imglist_tv = gtk.TreeView()
        self.imglist_tv.set_rubber_banding(True)
        self.imglist_tv.set_headers_visible(False)
        selection = self.imglist_tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE) 
        self.imglist_model = self.__create_imglist_model()
        self.imglist_tv.set_model(self.imglist_model)
        self._imglist_tv_columns(self.imglist_tv)  
        
        swin.add(self.imglist_tv)

        vbox = gtk.VBox()
        vbox.set_size_request(100, -1)
        
        button1 = gtk.Button()
        image1 = gtk.Image()
        image1.set_from_file(imgdir+'add.png')
        button1.add(image1)
        button1.connect("clicked", self.add_img_to_list)
        
        button2 = gtk.Button()
        image2 = gtk.Image()
        image2.set_from_file(imgdir+'remove.png')
        button2.add(image2)
        button2.connect("clicked", self.delete_img_from_list)
        
        button3 = gtk.Button()
        image3 = gtk.Image()
        image3.set_from_file(imgdir+'edit.png')
        button3.add(image3)        
        button3.connect("clicked", self.show_tagging_page)
        
        button4 = gtk.Button()
        image4 = gtk.Image()
        image4.set_from_file(imgdir+'selectall.png')
        button4.add(image4)          
        button4.connect("clicked", self.select_all_images)
        
        button5 = gtk.Button()
        image5 = gtk.Image()
        image5.set_from_file(imgdir+'clear.png')
        button5.add(image5)           
        button5.connect("clicked", self.clear_image_list)
        
        vbox.pack_start(button1, True, True, 0)
        vbox.pack_start(button2, True, True, 0)
        vbox.pack_start(button3, True, True, 0)
        vbox.pack_start(button4, True, True, 0)
        vbox.pack_start(button5, True, True, 0)

        self.imglistbox.pack_start(swin, True, True, 0)
        self.imglistbox.pack_start(vbox, False, False, 0)
        
        return self.imglistbox
       
    def __create_imglist_model(self):
        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING, gobject.TYPE_STRING)
        return lstore
        
    def _imglist_tv_columns(self, treeview):       
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn('', renderer, pixbuf=0)
        treeview.append_column(column)  
        
        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        treeview.append_column(column)
        
        column = gtk.TreeViewColumn('Filename', gtk.CellRendererText(), text=2)
        column.set_visible(False)
        treeview.append_column(column)       

    def get_thumbnail_settings(self):
        from settings import UI
        UI = UI()
        ind, thumbn = UI.load_general_settings(dbpath)
        if thumbn == "1":
            thumbn = True
        else:
            thumbn = False
        return thumbn

    def add_img_to_list(self, widget):
        #FIXME: Not cool running in the PC. Hang (thread error).
        imgfiles = utils.file_browser(self.window, gtk.FILE_CHOOSER_ACTION_OPEN, \
                            "Select File", "", "", "")         
        #                    "Select File", self.img_path, "", "")                            
        if not imgfiles:
            return

        if HILDON:
            banner = hildon.hildon_banner_show_animation(widget, \
                                        'qgn_indi_pball_a', 'Adding files...')
        else:
            banner = gtk.MessageDialog(parent=None, flags=0, type=gtk.MESSAGE_INFO, buttons=gtk.BUTTONS_NONE, message_format="Adding files...")
            banner.show_all()
            
        thread.start_new_thread(self._do_add_img_to_list, (imgfiles, banner))

    def _do_add_img_to_list(self, imgfiles, banner):
        self.img_path = os.path.dirname(imgfiles[len(imgfiles)-1])  
        
        #getting supported filetypes from the plugins.
        sf = _plugin_manager.get_allowed_ftypes(self.service)
        
        #print 'allowed filetypes:', sf
        unsupported = False

        thumbnails_off = self.get_thumbnail_settings()
        
        imgfiles = self.detect_folders(imgfiles)
        
        for filename in imgfiles:
            extension = os.path.splitext(filename)
            
            if sf.has_key(extension[1][1:len(extension[1])].lower()):
                #print 'supported format'
                filetype = sf[extension[1][1:len(extension[1])].lower()].split('/')[0]
            else:
                #print extension, extension[1][1:len(extension[1])]
                filetype = None
                #utils.show_info_banner(widget, 'Unsupported format')
                #return

            if filetype == 'image':
                if thumbnails_off:
                    pixbuf = utils.file_to_pixbuf(imgdir + 'image.png')
                else:
                    pixbuf = utils.file_to_pixbuf(filename)
                    if pixbuf is None:
                        pixbuf = utils.file_to_pixbuf(imgdir + 'image.png')
            elif filetype == 'video':
                pixbuf = utils.file_to_pixbuf(imgdir + 'video.png')
            elif filetype == 'audio':
                pixbuf = utils.file_to_pixbuf(imgdir + 'audio.png')
            elif filetype == 'text' or filetype == 'application':  
                pixbuf = utils.file_to_pixbuf(imgdir + 'other.png')     
            else:       
                print 'some unsupported format'
                filename = None
                unsupported = True
            if filename is not None:
                niter = self.imglist_model.append()            
                self.imglist_model.set(niter, 0, pixbuf, 1, \
                                        os.path.basename(filename), 2, filename)
                
                #Get the initial tags depending on the service chosen                
                image = _plugin_manager.get_initial_tags(self.service, filename)
                   
                all_files.append(image)

        print all_files
        self.count_images()         
        if unsupported:
            utils.show_thread_error(banner, self.window, "Some unsupported file wasn't added")       
        else:
            banner.destroy()

    def detect_folders(self, imgfiles):
        for i in imgfiles:
            if os.path.isdir(i):
                newfiles = os.listdir(i)
                del imgfiles[imgfiles.index(i)]
                for j in range(len(newfiles)):
                    imgfiles.append(i + '/' + newfiles[j])
                for k in imgfiles:
                    if os.path.isdir(k):
                        self.detect_folders(imgfiles)

        return imgfiles

    def delete_img_from_list(self, widget):
        selection = self.imglist_tv.get_selection()
        if selection.count_selected_rows() == 0:
            utils.show_info_banner(widget, 'No selected item') 
            return

        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]   
        
        for i in iters:
            selname = selmodel.get_value(i, 2)
            selmodel.remove(i) 

            for j in range(len(all_files)):
                if all_files[j][1] == selname:          
                    del all_files[j]
                    break 
                    
        self.count_images()

    def select_all_images(self, widget):
        selection = self.imglist_tv.get_selection()
        selection.select_all()

    def clear_image_list(self, widget):
        self.imglist_model.clear()
        del all_files[:]
        self.count_images()

    def show_tagging_page(self, widget):
        selection = self.imglist_tv.get_selection()
        if selection.count_selected_rows() == 0:
            utils.show_info_banner(widget, 'No selected item') 
            return
            
        #Check if it's created
        self.mainbar.hide()
        if self.taggingbox:
            self.notebook.set_current_page(self.notebook.page_num(self.taggingbox))         
            self.set_description_entries()
        else:
            self.create_tagging_page()
            self.notebook.append_page(self.taggingbox, gtk.Label('tagging'))
            self.notebook.show_all()
            self.notebook.set_current_page(self.notebook.page_num(self.taggingbox))

    def create_tagging_page(self):    
        self.taggingbox = gtk.HBox()
        
        vbox1 = gtk.VBox()
        
        label1 = gtk.Label('Title')
        self.title_entry = gtk.Entry()
        label2 = gtk.Label('Tags')
        self.tags_entry = gtk.Entry()
        self.batch_label = gtk.Label('')
        hbox1 = gtk.HBox()
        hbox1.set_size_request(-1, 50)
        button1 = gtk.Button('Save')
        button1.connect("clicked", self.on_save_tagging)
        button2 = gtk.Button('Cancel')
        button2.connect("clicked", self.on_cancel_tagging)
        
        vbox1.pack_start(label1, False, False,0)
        vbox1.pack_start(self.title_entry, False, False,0)
        vbox1.pack_start(label2, False, False,0)
        vbox1.pack_start(self.tags_entry, False, False,0)
        vbox1.pack_start(self.batch_label, True, True,0)
        vbox1.pack_start(hbox1, False, False,0)
        
        hbox1.pack_start(button1, True, True, 0)
        hbox1.pack_start(button2, True, True, 0)        
        
        vbox2 = gtk.VBox()
        
        label4 = gtk.Label("Description")
        swin = gtk.ScrolledWindow()
        swin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        swin.set_shadow_type(gtk.SHADOW_IN)
        tv = gtk.TextView()
        tv.set_wrap_mode(gtk.WRAP_WORD)
        self.summary_buffer = tv.get_buffer()
        swin.add(tv)
        
        vbox2.pack_start(label4, False, False, 0)
        vbox2.pack_start(swin, True, True, 0)
        
        button_ext = gtk.Button(self.service+' advanced')
        button_ext.set_size_request(-1, 55)
        button_ext.connect("clicked", self.show_adv_tagging_ui)
        
        vbox2.pack_start(button_ext, False, False, 0)

        self.taggingbox.pack_start(vbox1, True, True, 0)
        self.taggingbox.pack_start(gtk.HSeparator(), False, False, 0)
        self.taggingbox.pack_start(vbox2, True, True, 0)

    def show_adv_tagging_ui(self, clicked):
        #image = get image
        selection = self.imglist_tv.get_selection()
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        if selection.count_selected_rows() > 1:
            images = []
            print 'tagging multiple files'
            for seliter in iters:
                filename = self.imglist_model.get_value(seliter, 2)
                for i in range(len(all_files)):
                    if all_files[i][1] == filename:           
                        images.append(all_files[i])         
            
            images = _plugin_manager.show_adv_tags(self.service, images, 'multiple', self.window)
        else:
            image = self.get_file_tags(selection)
            image = _plugin_manager.show_adv_tags(self.service, image, 'simple', self.window)

        print 'all_files:', all_files

    def set_description_entries(self):
        selection = self.imglist_tv.get_selection()

        if selection.count_selected_rows() > 1: 
            #print 'multiple'
            self.batch_label.set_text('You are tagging a batch of files')
            self.title_entry.set_text('')
            self.tags_entry.set_text('')
            self.summary_buffer.set_text('')
        else:
            self.batch_label.set_text('')
            image = self.get_file_tags(selection)
            self.title_entry.set_text(image[2])
            self.tags_entry.set_text(image[4])
            self.summary_buffer.set_text(image[3])

    def get_file_tags(self, selection):
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]    
        seliter = iters[0]
        filename = self.imglist_model.get_value(seliter, 2)    
    
        for i in range(len(all_files)):
            if all_files[i][1] == filename:           
                image = all_files[i]
                break 

        return image

    def on_save_tagging(self, widget):
        selection = self.imglist_tv.get_selection()
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]
        
        title = self.title_entry.get_text()        
        tags_txt = self.tags_entry.get_text()
        start, end = self.summary_buffer.get_bounds()   
        summary = self.summary_buffer.get_text(start, end)
        
        if selection.count_selected_rows() > 1:
            for seliter in iters:
                filename = self.imglist_model.get_value(seliter, 2)
                for i in range(len(all_files)):
                    if all_files[i][1] == filename:           
                        image = all_files[i]                
                        break
                image[2] = title
                image[3] = summary
                image[4] = tags_txt
        else:      
            image = self.get_file_tags(selection)
            image[2] = title
            image[3] = summary
            image[4] = tags_txt        
        
        print all_files
        self.notebook.grab_focus()
        self.notebook.set_current_page(self.notebook.page_num(self.imglistbox))    
            
    def on_cancel_tagging(self, widget):
        self.notebook.set_current_page(self.notebook.page_num(self.imglistbox))
        print all_files

    def count_images(self):
        self.count_label.set_text("%i files" % len(self.imglist_model))

    def create_upload_page(self):
        self.uploadbox = gtk.VBox()

        self.upinfo_title = gtk.Label('Uploading files...')
        
        self.upinfo_hbox = gtk.HBox()
        
        label2 = gtk.Label('Total:')
        self.total_img = gtk.Label('#')
        label4 = gtk.Label('  Actual:')
        self.actual_img = gtk.Label('#')
        self.upinfo_filename = gtk.Label('Filename')
        
        self.upinfo_hbox.pack_start(label2, False, True, 0)
        self.upinfo_hbox.pack_start(self.total_img, False, True, 0)
        self.upinfo_hbox.pack_start(label4, False, True, 0)
        self.upinfo_hbox.pack_start(self.actual_img, False, True, 0)
        self.upinfo_hbox.pack_start(self.upinfo_filename, True, False, 0)
        
        hbox2 = gtk.HBox()
        
        label7 = gtk.Label('')
        self.upinfo_pgbar = gtk.ProgressBar()
        label8 = gtk.Label('')
        
        hbox2.pack_start(label7, True, True, 0)
        hbox2.pack_start(self.upinfo_pgbar, True, True, 0)
        hbox2.pack_start(label8, True, True, 0)
        
        hbox3 = gtk.HBox()
        
        label9 = gtk.Label('')
        self.cancel_upinfo_btn = gtk.Button('Cancel')
        self.cancel_upinfo_btn.connect("clicked", self.on_cancel_upload)
        label10 = gtk.Label('')        
         
        hbox3.pack_start(label9, True, True, 0)
        hbox3.pack_start(self.cancel_upinfo_btn, True, True, 0)
        hbox3.pack_start(label10, True, True, 0)
        
        self.uploadbox.pack_start(self.upinfo_title, True, True, 0)
        self.uploadbox.pack_start(self.upinfo_hbox, True, True, 0)
        self.uploadbox.pack_start(hbox2, True, True, 0)
        self.uploadbox.pack_start(hbox3, True, True, 0)

    ## Upload files, and progressbar functions ##
    def on_cancel_upload(self, widget):
        self.cancel_upload = True

    def progress_timeout(self):
        self.upinfo_pgbar.pulse()
        return True

    def destroy_progress(self):
        if self.timer > 0:
            gobject.source_remove(self.timer)
        self.timer = 0

    def test_upload_info(self):
        if all_files == []:
            utils.show_info_banner(self.window, 'Not images in the list')
            return None  
            
        test = _plugin_manager.test_upload_needs(self.service, dbpath, all_files)
        if test is not True:
            utils.show_info_banner(self.window, test)
            return None
        
        return True
        
    def upload_files(self):
        self.cancel_upload = False
        self.cancel_upinfo_btn.hide()
        self.upinfo_hbox.show()
        self.upinfo_pgbar.show()
        self.total_img.set_text(str(len(self.imglist_model)))
        self.actual_img.set_text('1')
        self.upinfo_title.set_markup('<b>Uploading files...</b>')
        self.notebook.set_current_page(3)
        self.timer = gobject.timeout_add (100, self.progress_timeout)
        thread.start_new(self.to_do_upload, ())

    def to_do_upload(self):
        try:
            for image in all_files:
                if self.cancel_upload:
                    self.on_upload_complete('Upload canceled')
                    return
                self.upinfo_filename.set_text(os.path.basename(image[1]))
                i = 1  
                i = i + all_files.index(image)
                self.actual_img.set_text(str(i))

                upload = _plugin_manager.do_upload(self.service, image, dbpath)

            self.destroy_progress()
            self.on_upload_complete('Upload complete')
        except:
            upload = None

        if upload is None:
            self.upload_failed('Error uploading files\nPlease, check your settings and connection')

    def upload_failed(self, msg):
        self.destroy_progress()
        self.on_upload_complete(msg)
        self.mainbar.show()   
        self.next_btn.hide()
        self.manage_btn.show()
        
    def on_upload_complete(self, upinfo):
        self.upinfo_pgbar.hide()
        self.cancel_upinfo_btn.hide()
        self.upinfo_title.set_markup('<b>'+upinfo+'</b>')
        self.upinfo_filename.set_text('')
        self.upinfo_hbox.hide()
        self.mainbar.show()
        self.next_btn.hide()

    def manage_prefs(self, widget):
        from settings import UI
        UI = UI()
        prefsUI = UI.show_ui(dbpath, self.window)

    def on_quit(self, widget):
        gtk.main_quit()

    #Functions for fullscreen
    def on_window_state_change(self, widget, event, *args):           
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
        else:
            self.window_in_fullscreen = False

    #F6 fullscreen, F7 bigger font, F8 smaller font
    def on_key_press(self, widget, event, *args):  
        if event.keyval == gtk.keysyms.F6:
            if self.window_in_fullscreen:
                self.window.unfullscreen ()
            else:
                self.window.fullscreen () 

    def on_about(self, widget):
        dialog = gtk.AboutDialog()
        dialog.set_name("SharePy")
        dialog.set_version("1.0")
        dialog.set_copyright("Copyright © 2009")
        dialog.set_website("http://sharepy.garage.maemo.org")
        dialog.set_authors(["Daniel Martin Yerga <dyerga@gmail.com>\nThanks to Stephen Wing for the SharePy name.\nThanks to gerrymoth for his suggestions and support."])
        logo = gtk.gdk.pixbuf_new_from_file(imgdir + "sharepy.png")
        dialog.set_logo(logo)
        dialog.set_license("This program is released under the GNU\nGeneral Public License. Please visit \nhttp://www.gnu.org/copyleft/gpl.html\nfor details.")
        dialog.set_artists(["Logo from Gorilla iconset.\nIcons from Allblack iconset."])
        dialog.run()
        dialog.destroy()  

class Utils:
    def get_selected_from_treeview(self, treeview, model, setting):
        selection = treeview.get_selection()
        selected_model, selected_iter = selection.get_selected()
        if selected_iter:
            selected_name = model.get_value(selected_iter, setting)
        return selected_name, selected_iter, selected_model

    def show_thread_error(self, banner, widget, error_msg):
        banner.destroy()
        gtk.gdk.threads_enter()
        self.show_info_banner(widget, error_msg)
        gtk.gdk.threads_leave()
        return   
        
    def show_info_dialog(self, window, msg):
        if HILDON:
            dialog = hildon.hildon_note_new_information(window, msg)
        else:
            dialog = gtk.MessageDialog(parent=None, flags=0, type=gtk.MESSAGE_INFO, buttons=gtk.BUTTONS_CLOSE, message_format=msg)
        dialog.show_all()
        dialog.run()
        dialog.destroy() 

    def show_info_banner(self, widget, msg):
        if HILDON:
            hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)       
        else:
            dialog = gtk.MessageDialog(parent=None, flags=0, type=gtk.MESSAGE_INFO, buttons=gtk.BUTTONS_CLOSE, message_format=msg)
            dialog.show_all()
            dialog.run()
            dialog.destroy() 
            
    def file_browser(self, window, action, title, folder, filename, file_ext):
        if HILDON:
            file_dialog = hildon.FileChooserDialog(window, action=action)
        else:
            file_dialog = gtk.FileChooserDialog(parent=window, action=action, \
                    buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                      gtk.STOCK_OK, gtk.RESPONSE_OK))
                      
        file_dialog.add_button('Add entire folder', gtk.RESPONSE_YES)

        file_dialog.set_title(title)
        file_dialog.set_current_folder(folder)
        file_dialog.set_select_multiple(True)
        file_dialog.set_default_response(gtk.RESPONSE_CANCEL)
            
        result = file_dialog.run()
        if result == gtk.RESPONSE_OK:
            namefiles = file_dialog.get_filenames()
        elif result == gtk.RESPONSE_YES:
            file_dialog.hide()
            if HILDON:
                folder_dialog = hildon.FileChooserDialog(window, \
                            action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
            else:
                folder_dialog = gtk.FileChooserDialog(parent=window, \
                                action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, \
                                buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, \
                                gtk.STOCK_OK, gtk.RESPONSE_OK))
                                     
            folder_dialog.set_title('Select folder')
            folder_dialog.run()
            namefiles = folder_dialog.get_filenames()
            folder_dialog.destroy()
        else:
            namefiles = False
        file_dialog.destroy()

        return namefiles

    def file_to_pixbuf(self, filename):
        try:
            new_pixbuf = gtk.gdk.pixbuf_new_from_file(filename)

            ## Scale pixbuf
            w, h = self.set_thumbnail_size(new_pixbuf)
            image_pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename, int(w), int(h))

            del new_pixbuf    
        except:
            print 'Failed to create a thumbnail.'
            self.show_info_banner(gtk.Window(), 'Failed to create a thumbnail\nPossibly '+os.path.basename(filename)+' is corrupted')
            image_pixbuf = None
            
        return image_pixbuf
        
    def set_thumbnail_size(self, pixbuf):
        pix_width = pixbuf.get_width()
        pix_height = pixbuf.get_height()

        if pix_width > pix_height:
            w = 140
            h = float(pix_height)/float(pix_width) * 140
        elif pix_height > pix_width:
            h = 140
            w = float(pix_width)/float(pix_height) * 140
        elif pix_height == pix_width:
            h = 140
            w = 140
        else:
            print "Pixbuf size can't be calculated."

        return w, h
        

if __name__ == "__main__":
    utils = Utils()
    sharepy = SharePy()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()

