#Some code is from the canola-flickr-plugin 
#License: GPL3

import flickrapi
import os

API_KEY = '1b2186454462f42d30850835ee7dc594'
API_SECRET = 'bd1752724be0fe03'

def attributesFromDict(d, obj=None, objName="self"):
    '''see http://code.activestate.com/recipes/280381/'''
    if obj is None:
        obj = d.pop(objName)
    for n, v in d.iteritems():
        setattr(obj, n, v)

def authorize_on_flickr(utils, widget):
    flickr = Flickr('')
    res = flickr.login()
    if not res == True:
        utils.show_info_dialog(widget, 'Press when authorize from flickr')
        res = flickr.login()
        if not res == True:
            utils.show_info_banner(widget, \
                            "Error, could not get access to a flickr account!")
            print "Error, could not get access to a flickr account!"
            return -1
    else:
        utils.show_info_banner(widget, "You already have allowed Flickr access")        

class Flickr:
    def __init__(self, username, api_key=API_KEY, api_secret=API_SECRET):
        attributesFromDict(locals())

        self.flickr = flickrapi.FlickrAPI(api_key, api_secret)
        self.logged = False
        self.token  = None
        self.frob   = None

    def login(self):
        if not self.frob and not self.token:
            token, self.frob = self.flickr.get_token_part_one(perms='write')
            if not token:
                self.token = None
                return False
            else: self.token = token

        self.token = self.flickr.get_token_part_two((self.token, self.frob))
        if not self.token:
            self.logged = False
        else: self.logged = True
        return self.logged

    def delete_token(self):
        import os
        token = os.path.join(os.path.expanduser("~"), ".flickr", self.api_key, \
                             "auth.token")

        if os.path.exists(token):
            os.unlink(token)
            return True
        else:
            return False

    def upload(self, filename, title, summary, tags, public, friend, family, sets):
        #photos = [[filename, title, desc, tags, public, friend, family, [sets_id]]]
        photo_id = self.flickr.upload(filename=filename, title=title, \
                                    description=summary, tags=tags, \
                                    is_public=public, is_friend=friend, \
                                    is_family=family)
    
        upload_id = photo_id.photoid[0].text

        if sets != []:
            for j in range(len(sets)):
                self.flickr.photosets_addPhoto(photoset_id=sets[j], photo_id=upload_id)

        return upload_id

    def get_set_list(self):
        setlist = []
        lista = self.flickr.photosets_getList()
        
        for i in range(len(lista.photosets[0].photoset)):
            title = lista.photosets[0].photoset[i].title[0].text
            set_id = lista.photosets[0].photoset[i]['id']
            one_set = (set_id, title)
            setlist.append(one_set)
        
        return setlist
