#!/usr/bin/env python2.5
# -*- coding: UTF8 -*-
# Copyright (C) 2008 by Daniel Martin Yerga
# <dyerga@gmail.com>
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# SharePy: Share on Ovi uploader for Internet Tablets
# Version 0.2
#

import gtk
import gtk.glade
import hildon
import os
import gobject
import pango
import gtk.gdk
import share_on_ovi
import cPickle
import base64
import sys
import thread
import osso

osso_c = osso.Context("net.yerga.sharepy", "0.1", False)

#See if is running ins scratchbox, and set the directories in consequence
if os.path.exists('/scratchbox/login'):
    scratchbox = True
else:
    scratchbox = False

if scratchbox:
    appdir = ''
    imgdir = 'pixmaps/'
    glade_file = "sharepy.glade"
    homedir = ''
else:
    appdir = '/usr/share/sharepy/'
    imgdir = appdir + 'pixmaps/'
    glade_file = "/usr/share/sharepy/sharepy.glade" 
    homedir = '/home/user/.sharepy/'

all_images = []

gtk.gdk.threads_init()

class SharePy(hildon.Program):

    def __init__(self):
        self.program = hildon.Program()
        self.program.__init__()
        gtk.set_application_name('')

        self.window = hildon.Window()
        self.window.set_title('SharePy')
        self.window.set_default_size(800, 480)
        self.window.connect("destroy", self.on_quit)	
        self.window.connect("key-press-event", self.on_key_press)
        self.window.connect("window-state-event", self.on_window_state_change)	
        self.window_in_fullscreen = False
        self.program.add_window(self.window)

        self.cancel_upload = False
        
        self.glade=gtk.glade.XML(glade_file)
        gtkwindow = self.glade.get_widget("window1")
        vbox2 =  self.glade.get_widget("vbox1")
        vbox2.reparent(self.window)

        menu = gtk.Menu()
        self.window.set_menu(menu)
        about_menu = gtk.ImageMenuItem("About")
        about_img = gtk.Image()    
        about_img.set_from_file(imgdir + 'about.png')         
        about_menu.set_image(about_img) 
        about_menu.set_size_request(-1, 55)
        about_menu.connect("activate", self.on_about)
               
        menu.append(about_menu)            
        menu.show_all()
        
        self.config_file = os.path.join(homedir + "accounts")
        self.settings = Settings(self.config_file)

        self.main_ntbk = self.glade.get_widget("notebook1")
        self.main_ntbk.connect("switch_page", self.on_main_ntbk_changed)
        self.main_ntbk.set_show_tabs(False)
        
        self.home_btn = self.glade.get_widget("button1")
        self.home_btn.connect("clicked", self.show_page_notebook, self.main_ntbk, 0, 'home')
        self.settings_btn = self.glade.get_widget("button2")
        self.settings_btn.connect("clicked", self.show_page_notebook, self.main_ntbk, 1, None)        
        self.upload_btn = self.glade.get_widget("button3")
        self.upload_btn.connect("clicked", self.upload_files) 

        self.imglist_ntbk = self.glade.get_widget("notebook2")
        self.imglist_ntbk.set_show_tabs(False)   
             
        imglist_sw = self.glade.get_widget("scrolledwindow1")
        hildon.hildon_helper_set_thumb_scrollbar(imglist_sw, True)
        
        self.imglist_tv = self.glade.get_widget("treeview1")
        self.imglist_tv.set_rubber_banding(True)
        selection = self.imglist_tv.get_selection()
        selection.set_mode(gtk.SELECTION_MULTIPLE) 
        self.imglist_model = self.__create_imglist_model()
        self.imglist_tv.set_model(self.imglist_model)
        self._imglist_tv_columns(self.imglist_tv)        

        add_imagefiles_img = self.glade.get_widget("image1")
        add_imagefiles_img.set_from_file(imgdir + 'add.png')
        
        add_imagefiles_btn = self.glade.get_widget("button4")
        add_imagefiles_btn.connect("clicked", self.add_img_to_list)

        del_imagefiles_img = self.glade.get_widget("image2")
        del_imagefiles_img.set_from_file(imgdir + 'remove.png')

        del_imagefiles_btn = self.glade.get_widget("button5")
        del_imagefiles_btn .connect("clicked", self.delete_img_from_list)

        desc_imagefiles_img = self.glade.get_widget("image3")
        desc_imagefiles_img.set_from_file(imgdir + 'edit.png')

        desc_img_btn = self.glade.get_widget("button6")
        desc_img_btn.connect("clicked", self.show_page_notebook, self.imglist_ntbk, 1, 'desc')

        self.title_entry = self.glade.get_widget("entry5")

        self.tags_entry = self.glade.get_widget("entry4")

        summary_sw = self.glade.get_widget("scrolledwindow3")
        hildon.hildon_helper_set_thumb_scrollbar(summary_sw, True)

        self.channel_list = gtk.ListStore(gobject.TYPE_STRING)        
        self.channel_cb = self.glade.get_widget("comboboxentry1")
        self.channel_cb.set_model(self.channel_list)
        self.channel_cb.child.set_property("editable", False)
        
        self.channels_file = os.path.join(homedir + "channels") 
        channels = self.settings.load_channels(self.channels_file) 
        print 'channels: ', channels
        
        if channels == [] or channels == ['']: 
            for item in ['mymedia', 'public']:
                self.channel_list.append([item])
        else:
            for item in channels:
                self.channel_list.append([item])            

        self.channel_cb.set_active(0)
        
        summary_txtview = self.glade.get_widget("textview1")
        self.summary_buffer = summary_txtview.get_buffer()
        
        save_desc_btn = self.glade.get_widget("button15")
        save_desc_btn.connect("clicked", self.save_img_description)
        cancel_desc_btn = self.glade.get_widget("button16")
        cancel_desc_btn.connect("clicked", self.show_page_notebook, self.imglist_ntbk, 0, 'cancel_desc')

        self.batch_label = self.glade.get_widget("label16")

        ## Settings UI ##
        self.user_entry = self.glade.get_widget("entry1")
        self.user_entry.set_text(self.settings.username)
        self.password_entry = self.glade.get_widget("entry2")
        self.password_entry.set_text(self.settings.password)
        
        get_ch_btn = self.glade.get_widget("button8")
        get_ch_btn.connect("clicked", self.get_channels)
        
        self.channellist_cb = self.glade.get_widget("comboboxentry2")
        self.channellist_cb.set_model(self.channel_list)        
        self.channellist_cb.child.set_editable(False)
        self.channellist_cb.set_text_column(0)
        self.channellist_cb.set_active(0)
        
        ## Upload info UI ##
        self.upinfo_title = self.glade.get_widget("label9")
        self.upinfo_filename = self.glade.get_widget("label8")
        self.upinfo_pgbar = self.glade.get_widget("progressbar1")
        self.cancel_upinfo_btn = self.glade.get_widget("button7")
        self.cancel_upinfo_btn.connect("clicked", self.on_cancel_upload)
        
        ## destroying the gtk glade window ##
        gtkwindow.destroy()
		
        self.window.show_all()

    def on_main_ntbk_changed(self, widget, dummy, page):
        if page == 0:
            self.settings_btn.show()
            self.home_btn.hide()
            self.upload_btn.show()
        elif page == 1:
            self.settings_btn.hide()
            self.home_btn.show()
            self.upload_btn.hide()         
        elif page == 2:
            self.settings_btn.show()
            self.settings_btn.set_sensitive(False)           
            self.home_btn.show()
            self.home_btn.set_sensitive(False)
            self.upload_btn.hide()        
            self.upinfo_pgbar.show()
            self.cancel_upinfo_btn.show()

    def show_page_notebook(self, widget, notebook, page, option):
        if option == 'cancel_desc':
            notebook.grab_focus()
        elif option == 'desc':
            selection = self.imglist_tv.get_selection()
            if selection.count_selected_rows() == 0:
                utils.show_info_banner(widget, 'No selected item') 
                return
            # Setting the correct value to the widgets:
            self.set_description_entries()
        elif option == 'home':
            self.main_ntbk.grab_focus()
        notebook.set_current_page(page)

    def on_quit(self, widget):
        username = self.user_entry.get_text()
        password = self.password_entry.get_text()
        self.settings.save(self.config_file, username, password)
        
        channels =  []
        for i in range(len(self.channel_list)):
            channels.append(self.channel_list[i][0])
                  
        df_channel = self.channellist_cb.get_active_text()
        
        channels.remove(df_channel)
        channels.insert(0, df_channel)
        
        self.settings.save_channels(self.channels_file, channels)
        gtk.main_quit()

	#Functions for fullscreen
    def on_window_state_change(self, widget, event, *args):           
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
        else:
            self.window_in_fullscreen = False

    #F6 fullscreen, F7 bigger font, F8 smaller font
    def on_key_press(self, widget, event, *args):  
        if event.keyval == gtk.keysyms.F6:
            if self.window_in_fullscreen:
                self.window.unfullscreen ()
            else:
                self.window.fullscreen () 

    def __create_imglist_model(self):
        lstore = gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING, gobject.TYPE_STRING)
        return lstore
        
    def _imglist_tv_columns(self, treeview):       
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn('', renderer, pixbuf=0)
        treeview.append_column(column)  
        
        column = gtk.TreeViewColumn('Name', gtk.CellRendererText(), text=1)
        treeview.append_column(column)
        
        column = gtk.TreeViewColumn('Filename', gtk.CellRendererText(), text=2)
        column.set_visible(False)
        treeview.append_column(column)
        
    def add_img_to_list(self, widget):
        #TODO: thread, it can use many CPU (test this)
        #TODO: if unsupported, pass the next
        imgfiles = utils.file_browser(self.window, gtk.FILE_CHOOSER_ACTION_OPEN, \
                            "Select File", "/home/user/MyDocs/.images", "", "")                            
        if not imgfiles:
            return

        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', \
                                                        'Adding files, be patient please.')
        thread.start_new_thread(self._do_add_img_to_list, (imgfiles, banner))

    def _do_add_img_to_list(self, imgfiles, banner):
        sf = share_on_ovi.supported_formats    

        for filename in imgfiles:
            extension = os.path.splitext(filename)
            
            if sf.has_key(extension[1][1:len(extension[1])].lower()):
                #print 'supported format'
                filetype = sf[extension[1][1:len(extension[1])].lower()].split('/')[0]
            else:
                #print extension, extension[1][1:len(extension[1])]
                filetype = None
                #utils.show_info_banner(widget, 'Unsupported format')
                #return
            
            if filetype == 'image':
                pixbuf = utils.file_to_pixbuf(filename)
            elif filetype == 'video':
                pixbuf = utils.file_to_pixbuf(imgdir + 'video.png')
            elif filetype == 'audio':
                pixbuf = utils.file_to_pixbuf(imgdir + 'audio.png')
            elif filetype == 'text':  
                pixbuf = utils.file_to_pixbuf(imgdir + 'other.png')     
            else:       
                print 'some unsupported format'
                filename = None
                
                #utils.show_info_banner(widget, 'Unsupported format')
                #return
            if filename is not None:
                niter = self.imglist_model.append()            
                self.imglist_model.set(niter, 0, pixbuf, 1, os.path.basename(filename), 2, filename)
                df_channel = self.channellist_cb.get_active_text()
                #image = [imgfile, title, summary, category, [tags]]
                image = [filename, '', '', df_channel, ['']]
                all_images.append(image)

        banner.destroy()

    def delete_img_from_list(self, widget):
        selection = self.imglist_tv.get_selection()
        if selection.count_selected_rows() == 0:
            utils.show_info_banner(widget, 'No selected item') 
            return

        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]   
        
        for i in iters:
            selname = selmodel.get_value(i, 2)
            selmodel.remove(i) 

            for i in range(len(all_images)):
                if all_images[i][0] == selname:          
                    del all_images[i]
                    break        
        
    def set_description_entries(self):
        selection = self.imglist_tv.get_selection()
        if selection.count_selected_rows() > 1: 
            print 'multiple'
            self.batch_label.set_text('You are tagging a batch of files')
            self.title_entry.set_text('')
            self.tags_entry.set_text('')
            self.summary_buffer.set_text('')
            df_channel = self.channellist_cb.get_active_text()
            for i in range(len(self.channel_list)):
                if df_channel == self.channel_list[i][0]:
                    active = i            

            self.channel_cb.set_active(active)
            
            return 
        else:
            self.batch_label.set_text('')
            selmodel, selected = selection.get_selected_rows()
            iters = [selmodel.get_iter(path) for path in selected]    
            seliter = iters[0]
            filename = self.imglist_model.get_value(seliter, 2)    
        
            for i in range(len(all_images)):
                if all_images[i][0] == filename:           
                    image = all_images[i]
                    break 
                    
            #image = [imgfile, title, summary, category, [tags]] 
                               
            self.title_entry.set_text(image[1])
            
            taglist = image[4]
            tags = ''
            for tag in taglist:
                tags = tag + ', '
                
            tags = tags[:len(tags)-2] 
                   
            self.tags_entry.set_text(tags)
            self.summary_buffer.set_text(image[2])
            

            if image[3] == '':
                df_channel = self.channellist_cb.get_active_text()
            else:
                df_channel = image[3]
            
            for i in range(len(self.channel_list)):
                print i, self.channel_list[i][0]
                if df_channel == self.channel_list[i][0]:
                    active = i

            self.channel_cb.set_active(active)

    def save_img_description(self, widget):
        selection = self.imglist_tv.get_selection()
        selmodel, selected = selection.get_selected_rows()
        iters = [selmodel.get_iter(path) for path in selected]    

        title = self.title_entry.get_text()        
        tags_txt = self.tags_entry.get_text()
        tags = []
        for i in tags_txt.split(", "):
            for j in i.split(" ,"):
                for k in j.split(","):
                    for l in k.split("; "):
                        for m in l.split(" ;"):
                            for n in m.split(";"):
                                if (n != " " and n != ""):
                                    tags.append(n)        
            
        start, end = self.summary_buffer.get_bounds()   
        summary = self.summary_buffer.get_text(start, end) 
            
        channel = self.channel_cb.get_active_text()
          
        for seliter in iters:
            filename = self.imglist_model.get_value(seliter, 2)
            image = [filename, title, summary, channel, tags]       
            for i in range(len(all_images)):
                if all_images[i][0] == filename:           
                    all_images[i] = image
                    break        

        self.imglist_ntbk.grab_focus()
        self.imglist_ntbk.set_current_page(0)

        print all_images

    ## Upload files, and progressbar functions ##
    def on_cancel_upload(self, widget):
        self.cancel_upload = True

    def progress_timeout(self):
        self.upinfo_pgbar.pulse()
        return True
        
    def destroy_progress(self):
        if self.timer > 0:
            gobject.source_remove(self.timer)
        self.timer = 0
        
    def upload_files(self, widget):
        self.cancel_upload = False
        self.upinfo_title.set_markup('<b>Uploading files...</b>')
        self.main_ntbk.set_current_page(2)
        self.timer = gobject.timeout_add (100, self.progress_timeout)
        thread.start_new(self.to_do_upload, ())

    def to_do_upload(self):
        try:
            username = self.user_entry.get_text()
            password = self.password_entry.get_text()
            soo = share_on_ovi.ShareOnOvi(username, password)

            sf = share_on_ovi.supported_formats  
                  
            for image in all_images:
                if self.cancel_upload:
                    self.on_upload_complete('Upload canceled')
                    return
                filename = image[0]
                self.upinfo_filename.set_text(os.path.basename(filename))
                title = image[1]
                summary = image[2]
                channel = image[3]
                tags = image[4] 
                extension = os.path.splitext(filename)
                filetype = sf[extension[1][1:len(extension[1])].lower()]
                print filetype
                result = soo.upload(filename, title, summary, channel, tags, filetype)

            self.destroy_progress()
            self.on_upload_complete('Upload complete')
        except:
            print 'Error uploading files.'

        if result is None:
            print 'Error uploading files.'
            self.destroy_progress()
            self.on_upload_complete('Error uploading files')                        

    def on_upload_complete(self, upinfo):
        self.settings_btn.set_sensitive(True)
        self.home_btn.set_sensitive(True)
        self.upinfo_pgbar.hide()
        self.cancel_upinfo_btn.hide()
        self.upinfo_title.set_markup('<b>'+upinfo+'</b>')
        self.upinfo_filename.set_text('')

    ## Get Share on Ovi channel list ##
    def get_channels(self, widget):
        banner = hildon.hildon_banner_show_animation(widget, 'qgn_indi_pball_a', 'Getting channel list')
        thread.start_new(self.get_channels_from_ovi, (banner,widget))
              
    def get_channels_from_ovi(self, banner, widget):
        try: 
            username = self.user_entry.get_text()
            password = self.password_entry.get_text()
            soo = share_on_ovi.ShareOnOvi(username, password)    
            channels = soo.getChannels()
            self.channel_list.clear()
            for item in channels:
                self.channel_list.append([item])
            self.channellist_cb.set_active(0)
        except:
            print 'Error getting channels'
            gtk.gdk.threads_enter()
            utils.show_info_banner(widget, 'Error getting channels')
            gtk.gdk.threads_leave()
            
        banner.destroy()
        #for i in range(len(self.channel_list)):
        #    print 'a: ', self.channel_list[i][0]

    def on_about(self, widget):
        dialog = gtk.AboutDialog()
        dialog.set_name("SharePy")
        dialog.set_version("0.1")
        dialog.set_copyright("Copyright © 2008")
        dialog.set_website("http://sharepy.garage.maemo.org")
        dialog.set_authors(["Daniel Martin Yerga <dyerga@gmail.com>\nThanks to gerrymoth for the SharePy name."])
        logo = gtk.gdk.pixbuf_new_from_file(imgdir + "sharepy.png")
        dialog.set_logo(logo)
        dialog.set_license("This program is released under the GNU\nGeneral Public License. Please visit \nhttp://www.gnu.org/copyleft/gpl.html\nfor details.")
        dialog.set_artists(["Logo from Gorilla iconset.\nIcons from Allblack iconset."])
        dialog.run()
        dialog.destroy()   
    
class Utils:
    def get_selected_from_treeview(self, treeview, model, setting):
        selection = treeview.get_selection()
        selected_model, selected_iter = selection.get_selected()
        if selected_iter:
            selected_name = model.get_value(selected_iter, setting)
        return selected_name, selected_iter, selected_model

    def show_info_banner(self, widget, msg):
        hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', msg)       

    def file_browser(self, window, action, title, folder, filename, file_ext):
        file_dialog = hildon.FileChooserDialog(window, action=action)
        file_dialog.set_title(title)
        file_dialog.set_select_multiple(True)
        file_dialog.set_default_response(gtk.RESPONSE_CANCEL)
        #if (action==gtk.FILE_CHOOSER_ACTION_SAVE):
        #    file_dialog.set_current_name(filename)
        #    file_dialog.set_current_folder(folder)
            
        result = file_dialog.run()
        if result == gtk.RESPONSE_OK:
            namefiles = file_dialog.get_filenames()
            #namefile = file_dialog.get_filename()
            #if (action==gtk.FILE_CHOOSER_ACTION_SAVE):
            #    namefile, extension = os.path.splitext(namefile)
            #    namefile = namefile + "." + file_ext
        else:
            namefiles = False
        file_dialog.destroy()

        return namefiles

    def file_to_pixbuf(self, filename):
        new_pixbuf = gtk.gdk.pixbuf_new_from_file(filename)

        ## Scale pixbuf
        w, h = self.set_thumbnail_size(new_pixbuf)
        image_pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename, int(w), int(h))

        del new_pixbuf    
        
        return image_pixbuf
        
    def set_thumbnail_size(self, pixbuf):
        pix_width = pixbuf.get_width()
        pix_height = pixbuf.get_height()
		
        if pix_width > pix_height:
            w = 140
            h = float(pix_height)/float(pix_width) * 140
        elif pix_height > pix_width:
            h = 140
            w = float(pix_width)/float(pix_height) * 140
        elif pix_height == pix_width:
            h = 140
            w = 140
        else:
            print "Pixbuf size can't be calculated."

        return w, h
        
class Settings:
    def __init__(self, filename="", username="", password=""):
        self.username = username
        self.password = password
        if (filename != ""):
            try:
                configfile = open(filename, 'rb')
                self.username = cPickle.load(configfile)
                self.password = cPickle.load(configfile)
                dec_pass=base64.decodestring(self.password)
                self.password=dec_pass
                configfile.close()
            except:
                print 'Error loading settings.'

    def save(self, filename, username, password):
        try:
            save_file = open(filename, 'wb')
            cPickle.dump(username, save_file)
            enc_pass=base64.encodestring(password)
            password=enc_pass
            cPickle.dump(password, save_file)
            save_file.close()
        except:
            print "Error saving settings."

    def save_channels(self, filename, channels):
        try:
            savefile = open(filename, 'wb')
            for channel in channels:
                cPickle.dump(channel, savefile) 
            savefile.close()
        except:
            print 'Error saving channels.'        

    def load_channels(self, filename):
        try:
            channels = []
            loadfile = open(filename, 'rb')
            lines = loadfile.readlines()
            loadfile.close()
            loadfile = open(filename, 'rb')
            for channel in range(len(lines)/2):
                channels.append(cPickle.load(loadfile))
            loadfile.close()    
        except:
            print 'Error loading channels.'
            channels = []

        return channels

if __name__ == "__main__":
    sharepy = SharePy()
    utils = Utils()
    gtk.gdk.threads_enter()
    gtk.main()
    gtk.gdk.threads_leave()
