#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# MA  02110-1301, USA.
#

import glob
import os
from distutils.core import setup

# files to install
inst_desktop = ['sharepy.desktop']
inst_py = ['sharepy.py', 'sharepy.glade', 'share_on_ovi.py']
pixmaps = ['pixmaps/edit.png', 'pixmaps/add.png', 'pixmaps/remove.png', \
'pixmaps/audio.png', 'pixmaps/other.png', 'pixmaps/video.png', \
'pixmaps/sharepy.png', 'pixmaps/about.png']
inst_dbus = [ 'sharepy.service' ]
backup_conf  = ['sharepy-backup.conf']
inst_icon = ['sharepy.png' ]
inst_icon_sca = ['pixmaps/sharepy.png']

data_files = [
  ('share/applications/hildon', inst_desktop),
  ('share/sharepy',   inst_py),
  ('share/sharepy/pixmaps',   pixmaps),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
  ('share/dbus-1/services',   inst_dbus),
  ('/etc/osso-backup/applications/',   backup_conf),
]

setup(
  name         = 'sharepy',
  version      = '0.1',
  description  = 'Share on Ovi uploader',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'https://garage.maemo.org/projects/sharepy',
  data_files   = data_files
)
