#ifndef PLAYER_H
#define PLAYER_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <vector>

#include "Card.h"
#include "Table.h"

class Player
{
public:
  std::vector<Card> hand;

public:
  virtual ~Player();

  virtual void Initialize();

  bool HasCardsInHand() const;
  void PutCard(const Card& card);

  virtual SolutionSet PlayCard(const Table& table, size_t round) = 0;

  virtual void CardsPlayed(std::vector<Card>& cards,
                           bool ownCards,
                           size_t round);

  virtual void RoundFinished(size_t round,
                             size_t pointsMe, size_t pointsOther);

  virtual void PrintStatistics();
};

#endif

