#ifndef FADETEXT_H
#define FADETEXT_H

/*
  This file is part of "Scopa" - An italian card game.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <vector>

#include <Lum/Object.h>

#include <Lum/Model/Action.h>

class FadeText : public Lum::Object
{
private:
  std::vector<std::wstring>        texts;
  std::vector<Lum::OS::FontExtent> extents;
  std::vector<Lum::OS::Color>      colors;
  size_t                           text;
  Lum::OS::FontRef                 font;
  size_t                           fadeStep;
  Lum::Model::ActionRef            timerAction;
  Lum::Model::ActionRef            fadeFinishedAction;

private:
  void Fade();

public:
  FadeText();
  ~FadeText();

  void AddText(const std::wstring& text);
  void SetText(size_t text);

  void SetFadeFinishedAction(Lum::Model::Action* action);

  void CalcSize();

  void Draw(int x, int y, size_t w, size_t h);

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg);
};

#endif
