#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-
 
"""
 *
 *  Copyright (C) 2007 Christoph Würstle
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *
"""
 
import gobject
import time
import random
import logging

import gtk

import libspeichern
import string


class Kopfzeile(gtk.HBox):
	
	__gsignals__ = {
 		'reload_notes' : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,()),
 	}

	def comboCategoryChanged(self, widget=None, data=None):
		logging.debug("comboCategoryChanged")
		if (self.lastCategory!=self.comboCategory.get_active()):
			sql="UPDATE categories SET liste=? WHERE id=1"
			self.db.speichereSQL(sql,(self.comboCategory.get_active(),))
			
		self.emit("reload_notes")
	
	def searchEntryChanged(self, widget=None, data=None):
		logging.debug("searchEntryChanged")
		self.emit("reload_notes")
		

	def getCategory(self):
		entry = self.comboCategory.get_child()
		category=entry.get_text()
		if (category=="all"):
			category="%"
		if (category==""):
			category="undefined"
			self.comboCategory.set_active(1)
			self.comboCategory.show()
		return category
	
	def defineThisCategory(self):
		category=self.getCategory()
		
		model = self.comboCategory.get_model()
		n=len(self.comboCategory.get_model())
		i=0
		active=-1
		cats=[]
		while i<n:
			
			if (model[i][0]==category): 
				#self.comboCategory.set_active(i)
				active=i
			if (model[i][0]!="%"):
				cats.append(model[i][0])
			i+=1
		
		if (active==-1)and(category!="%"):
			self.comboCategory.append_text(category)
			sql="INSERT INTO categories  (id,liste) VALUES (0,?)"
			self.db.speichereSQL(sql,(category,))
			self.comboCategory.set_active(i)
			
	def getSearchPattern(self):
		return self.searchEntry.get_text()


	def loadCategories(self):
		sql="CREATE TABLE categories (id TEXT , liste TEXT)"
		self.db.speichereSQL(sql)
		
		sql="SELECT id,liste FROM categories WHERE id=0 ORDER BY liste"
		rows=self.db.ladeSQL(sql)
		self.cats=[]
		if (rows!=None)and(len(rows)>0):
			for row in rows:
				self.cats.append(row[1])
				
			
		sql="SELECT * FROM categories WHERE id=1"
		rows=self.db.ladeSQL(sql)
		cats=None
		if (rows==None)or(len(rows)==0):
			sql="INSERT INTO categories (id, liste) VALUES (1,1)"
			self.db.speichereSQL(sql)
			
		#self.comboCategory.clear()
		while len(self.comboCategory.get_model())>0:
			self.comboCategory.remove_text(0)
			
		self.comboCategory.append_text('all')
		self.comboCategory.append_text('undefined')
		
		if (self.cats!=None)and(len(self.cats)>0):
			for cat in self.cats:
				#print cat
				self.comboCategory.append_text(cat)
				
		sql="SELECT * FROM categories WHERE id=1"
		rows=self.db.ladeSQL(sql)
		if (rows!=None)and(len(rows)>0):
			self.comboCategory.set_active(int(rows[0][1]))
		else:	
			self.comboCategory.set_active(1)
			
		self.lastCategory=self.comboCategory.get_active()


	def __init__(self,db):
		
		self.db=db

		gtk.HBox.__init__(self,homogeneous=False, spacing=3)
		logging.info("libkopfzeile, init")
		
		label=gtk.Label("Search:  ")
		self.pack_start(label, expand=False, fill=True, padding=0)
		
		self.searchEntry=gtk.Entry()
		self.pack_start(self.searchEntry, expand=True, fill=True, padding=0)
		self.searchEntry.connect("changed", self.searchEntryChanged, None)
		
		label=gtk.Label("   ")
		self.pack_start(label, expand=True, fill=True, padding=0)
		
		label=gtk.Label("Category:  ")
		self.pack_start(label, expand=False, fill=True, padding=0)
		
		self.comboCategory = gtk.combo_box_entry_new_text()

		self.pack_start(self.comboCategory, expand=True, fill=True, padding=0)
		
		self.loadCategories()
		
		self.comboCategory.connect("changed", self.comboCategoryChanged, None)
		
		



