#!/usr/bin/python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import evas
import ecore
import ecore.evas
import terra.ui.list
import terra.ui.scrollbar

ee = ecore.evas.SoftwareX11(w=300, h=300)

canvas = ee.evas

bg = canvas.Rectangle(color=(0, 0, 0, 255))
bg.size = canvas.size
bg.show()
ee.data["bg"] = bg

colors = (
    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),

    (128, 0, 0, 255),
    (0, 128, 0, 255),
    (0, 0, 128, 255),
    (128, 255, 0, 255),
    (0, 128, 255, 255),
    (255, 0, 128, 255),

    (255, 128, 0, 255),
    (0, 255, 128, 255),
    (128, 0, 255, 255),

    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),

    (128, 0, 0, 255),
    (0, 128, 0, 255),
    (0, 0, 128, 255),
    (128, 255, 0, 255),
    (0, 128, 255, 255),
    (255, 0, 128, 255),

    (255, 128, 0, 255),
    (0, 255, 128, 255),
    (128, 0, 255, 255),
    )


class RowRenderer(evas.ClippedSmartObject, terra.ui.list.RowRenderer):
    def __init__(self, canvas):
        evas.ClippedSmartObject.__init__(self, canvas)
        self.r = self.Rectangle()
        self.r.show()
        self.f = self.Rectangle()
        self.f.show()
        self.s = self.Rectangle(color=(255, 255, 255, 255))

    def resize(self, w, h):
        self.r.resize(w, h)
        self.f.resize(10, h)
        self.s.resize(w - 40, 5)
        self.s.center_set(*self.r.center_get())

    def value_set(self, value):
        self.r.color_set(*value)

    def state_set(self, state):
        if state == self.STATE_FIRST:
            self.f.color_set(255, 255, 255, 255)
        elif state == self.STATE_LAST:
            self.f.color_set(0, 0, 0, 255)
        else:
            self.f.color_set(128, 128, 128, 255)

    def selected_set(self, set):
        if set:
            self.s.show()
        else:
            self.s.hide()


lst = terra.ui.list.KineticList(canvas, RowRenderer, colors)
lst.size = canvas.size
lst.show()
ee.data["lst"] = lst

knob = canvas.Rectangle(color=(200, 200, 200, 200))
knob.show()

sb = terra.ui.scrollbar.Scrollbar(canvas, knob)
sb.show()
ee.data["sb"] = sb


def position_changed_cb(lst, percent):
    sb.value_set(percent)
lst.position_changed_cb_set(position_changed_cb)


def on_resize(ee):
    canvas = ee.evas
    ee.data["bg"].size = canvas.size

    lst = ee.data["lst"]
    lst.size = canvas.size

    sb = ee.data["sb"]
    sb.resize(20, canvas.size[1])
    sb.top_right_set(canvas.size[0], 0)
    sb.scale_set(lst.visible_rows_scale_get())
ee.callback_resize = on_resize
on_resize(ee) # to enforce sb recalc


def on_key_down(obj, event):
    lst = ee.data["lst"]
    if event.keyname == "Escape":
        ecore.main_loop_quit()
    elif event.keyname == "0":
        lst.position_set(0.0)
    elif event.keyname == "1":
        lst.position_set(1.0)
    elif event.keyname == "5":
        lst.position_set(0.5)
    elif event.keyname == "Down":
        p = lst.position_get() + 0.01
        lst.position_set(p)
    elif event.keyname == "Up":
        p = lst.position_get() - 0.01
        lst.position_set(p)
bg.focus = True
bg.on_key_down_add(on_key_down)

ee.show()
ecore.main_loop_begin()
