#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

from evas import ClippedSmartObject

__all__ = ("Scrollbar",)

class Scrollbar(ClippedSmartObject):
    def __init__(self, canvas, knob):
        ClippedSmartObject.__init__(self, canvas)
        self._scale = 1.0
        self._value = 0.0
        self.knob = knob
        self.knob.resize(1, 1)
        self.member_add(self.knob)

    def resize(self, w, h):
        x, y = self.pos_get()
        self._knob_recalc(x, y, w, h)

    def _knob_recalc(self, x, y, w, h):
        kh = int(self._scale * h)
        dy = h - kh
        ky = y + int(self._value * dy)
        self.knob.geometry_set(x, ky, w, kh)

    def value_set(self, value):
        self._value = float(value)
        self._knob_recalc(*self.geometry_get())

    def value_get(self):
        return self._value

    value = property(value_get, value_set)

    def scale_set(self, scale):
        self._scale = float(scale)
        self._knob_recalc(*self.geometry_get())

    def scale_get(self):
        return self._scale

    scale = property(scale_get, scale_set)
