#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Copyright (C) 2009 ProFUSION embedded systems
#
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Gustavo Sverzut Barbieri <gustavo.barbieri@profusion.mobi>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import sys
import zipimport
from os.path import basename, dirname, splitext


class ModuleLoader(object):
    def __init__(self, moddir, modname):
        self._moddir = moddir
        self._modname = modname

    def load(self):
        if self._moddir.endswith(".zip"):
            path = self._moddir
            prefix = splitext(basename(self._moddir))[0]
        else:
            path = dirname(self._moddir)
            prefix = basename(self._moddir)

        name = "%s.%s" % (prefix, self._modname)

        if path not in sys.path:
            sys.path.insert(0, path)

        r = __import__(name)
        for p in self._modname.split("."):
            r = getattr(r, p)
        return r
