from distutils.core import setup, Extension
from distutils.command.build import build
import subprocess
import os
import sys

datadir = '/usr/share'
defsdir = datadir+'/pygtk/2.0/defs'
includedir = '/usr/include'

def gen_auto_file(filename, subproc_args):
    proc = subprocess.Popen(
        subproc_args,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE
    )
    cmdresult = proc.stdout
    error = proc.stderr
#   Print disabled to avoid problems with scratchbox
#   print >>sys.sdterr, error.read()
    if cmdresult:
        new_file = open(filename, 'w')
        new_file.write(cmdresult.read())
    new_file.close()

class PyGconfBuild(build):
    def run(self):
        """Create the temporary files used to compile the hildon module:
        -gconf.c
        -gconf-types.h.in
        -gconf-types.c.in
        -vfs.c
        -vfs-types.h.in
        -vfs-types.c.in"""
        # Generate enum/flags run-time information
        GCONF_TYPE_FILES = [
            includedir+'/gconf/2/gconf/gconf.h',
        ]

        gen_auto_file('gconf/gconf-types.h.in', ['/bin/sh', './gen-enum-h']+GCONF_TYPE_FILES)
        gen_auto_file('gconf/gconf-types.c.in', ['/bin/sh', './gen-enum-c']+GCONF_TYPE_FILES)

        # Creation of ".c" files, using pygtk-codegen-2.0
        gconf_override_filename = 'gconf/gconf.override'
        gconf_defs_filename = 'gconf/gconf.defs'

        gconf_parameter = [
            '--override', gconf_override_filename,
            '--prefix', 'pygconf',
            gconf_defs_filename,
        ] 
        gen_auto_file('gconf/gconf.c', ['/bin/sh', 'pygtk-codegen-2.0']+gconf_parameter)

        build.run(self)


compile_args = [
        '-Os',
        '-DXTHREADS',
        '-DXUSE_MTSAFE_API',
#        '-DGCONF_DISABLE_DEPRECATED',
#        '-ansi',
#        '-pedantic',
#        '-Wno-long-long',
#        '-g',
#        '-rdynamic',
]

gconf = Extension('gconf',
    sources=['gconf/gconf.c',
             'gconf/gconfmodule.c',
             'gconf/gconf-fixes.c',
             'gconf/gconf-types.c'],
    libraries = ['gconf-2',
                 'glib-2.0'],
    include_dirs=['/usr/include',
                  '/usr/include/gconf/2',
                  '/usr/include/glib-2.0',
                  '/usr/lib/glib-2.0/include',
                  '/usr/include/pygtk-2.0'],
    extra_compile_args=compile_args,
)

gnomevfs = Extension('gnomevfs',
    sources=['gnomevfs/gnome-vfs-python-method.c',
             'gnomevfs/vfs-drive.c',
             'gnomevfs/vfs-uri.c',
             'gnomevfs/vfs-async-handle.c',
             'gnomevfs/vfs-file-info.c',
             'gnomevfs/vfs-volume-monitor.c',
             'gnomevfs/vfsmodule.c',
             'gnomevfs/vfs-context.c',
             'gnomevfs/vfs-volume.c',
             'gnomevfs/vfs-dir-handle.c',
             'gnomevfs/vfs-handle.c',
             'gnomevfs/vfs-xfer-progress-info.c'],
    libraries = ['gnomevfs-2',
                 'glib-2.0'],
    include_dirs=['/usr/include',
                  '/usr/include/gnome-vfs-2.0',
                  '/usr/include/gnome-vfs-module-2.0',
                  '/usr/include/glib-2.0',
                  '/usr/lib/glib-2.0/include',
                  '/usr/include/pygtk-2.0'],
    extra_compile_args=compile_args+['-DGNOME_VFS_PYTHON_DIR="/usr/lib/gnome-vfs-2.0/modules"'],
)

setup(
    name = 'gnome',
    version = '0.1',
    description = 'Python bindings for gconf.',
    author = 'Luciano Miguel Wolf',
    author_email = 'luciano.wolf@indt.org.br',
    url = 'http://www.maemo.org',
    ext_package = 'gnome',
    ext_modules = [gconf, gnomevfs],
    cmdclass={'build': PyGconfBuild}
)

# vim:ts=4:sw=4:et:sm:ai
