#!/usr/bin/python

import sys
import os
import time
import re
try:
	import pygtk
	pygtk.require("2.0")
except:
	pass
try:
	import gtk
	import gtk.glade
	import gobject
except:
	sys.exit(1)

import hildon
import osso
import conic
#import dbus

from gnome import gconf
import threading

gtkrunning = False

#Class for running rdesktop-cli threads
class rdpThread(threading.Thread) :
	global gtkrunning
	def __init__(self, name, host, parameters):
		self.parameters = parameters
		self.host = host
		self.name = name
		self.online = False #Assume online, just in case...
		self.connection = conic.Connection()
		self.checkedConn = False
		self.connection.connect("connection-event", self.conn_event, 0x1234)
		assert(self.connection.request_connection(conic.CONNECT_FLAG_NONE))
		threading.Thread.__init__ ( self, name="test" )
	def conn_event(self, connection, event, magic):
		status = event.get_status()
		if status == conic.STATUS_CONNECTED:
			#print "online!\n"
			self.online = True
		elif status == conic.STATUS_DISCONNECTED:
			#print "offline...\n"
			self.online = False
		self.checkedConn = True
	def run(self):
		while self.checkedConn == False:
			time.sleep(0.1)
		if self.online == False:
			gtk.gdk.threads_enter()
			self.ErrPopUp("Sorry, could not connect to the internet.\nConnection to \""+self.name+"\" failed.")
			gtk.gdk.threads_leave();
			return False
		#print "rdesktop-cli " + self.parameters + " " + self.host
                self.ossoc = osso.Context("pyrdesktop", "1.6.0", False)
		self.note = osso.SystemNote(self.ossoc)
                self.note.system_note_infoprint("Connecting to '" + self.name + "'")
		result = os.system("rdesktop-cli " + self.parameters + " " + self.host)
		needEnter = False
		#for thread in threading.enumerate():
		#	if thread.getName() == "gtk":
		#		needEnter = True
		if gtkrunning == True :
			needEnter = True
		if needEnter == True :
			gtk.gdk.threads_enter()
		if result == 512 : #This isn't actually an error, just a connection closed weird...
			print "" #We just need something here...
		elif result == 256 : #Connection refused, either no internet or bad host
			#self.ErrPopUp("Sorry, there was an error connecting to "+self.name+".\nConnection refused.")
			if self.online == True :
				tryagain = self.TimedPopUp("Sorry, there was an error connecting to \""+self.name+"\".\nConnection refused.  Will try again in",6)
				if tryagain == True :
					rdpThread(self.name, self.host, self.parameters).start()
			else :
				self.ErrPopUp("Sorry, there was an error connecting to "+self.name+".\nConnection refused.")
		elif result == 0 : #Exited fine
			print "" #We just need something here...
		elif result == 2 : #User control-Ced it...  So, they should know they did it, do nothing
			print ""
		else : #Some unknown error, tell them the error code (to report back, hopefully), and exit.
			#self.ErrPopUp("Sorry, there was an error in the remote desktop connection with \""+self.name+"\".\nError code: "+str(result))
			if self.online == True :
				tryagain = self.TimedPopUp("Sorry, there was an error in the remote desktop connection with \""+self.name+"\".\nError code: "+str(result)+".  Will try again in",6)
				if tryagain == True :
					rdpThread(self.name, self.host, self.parameters).start()
			else :
				self.ErrPopUp("Sorry, there was an error in the remote desktop connection with \""+self.name+"\".\nError code: "+str(result))
		#self.TimedPopUp("Test in", 5)
		if needEnter == True :
			gtk.gdk.threads_leave()
		#return True
	def ErrPopUp(self,msg):
		error_dialog = gtk.MessageDialog(None,0,gtk.MESSAGE_ERROR,gtk.BUTTONS_CLOSE,msg)
		def close(dialog, response, editor):
			editor.about_dialog = None
			dialog.destroy()
		error_dialog.connect("response", close, self)
		error_dialog.run()
	def TimedPopUp(self, msg, secs) :
		#OK -- -5, Cancel -- -6
		self.msg = msg
		self.secs = secs
		self.return_val = False
		self.error_dialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK_CANCEL, self.msg + " " + str(self.secs) + " seconds.")
		def close(dialog, response, editor) :
			if response == -5 :
				editor.return_val = True
			editor.about_dialog = None
			dialog.destroy()
		self.error_dialog.connect("response", close, self)
		def update_dlg(parent) :
			parent.secs = parent.secs - 1
			if parent.secs == 0 :
				parent.error_dialog.response(-5)
				return False #to kill the loop
			else :
				parent.error_dialog.set_markup(parent.msg + " " + str(parent.secs) + " seconds.")
				return True # Keep the loop going...
		gobject.timeout_add(1000, update_dlg, self)
		self.error_dialog.run()
		return self.return_val
		
class rdesktop:

	def __init__(self):
		if os.path.isfile("/usr/local/lib/rdesktop.glade") :
			self.gladefile = "/usr/local/lib/rdesktop.glade"  
		elif os.path.isfile("./rdesktop.glade") :
			self.gladefile = "./rdesktop.glade"  

		self.wTree = gtk.glade.XML(self.gladefile)
		self.window = self.wTree.get_widget("wnd_main")
		if (self.window):
			self.window.connect("destroy", self.cancel)

		self.name = self.wTree.get_widget("entry_name")
		self.host = self.wTree.get_widget("entry_host")
		self.username = self.wTree.get_widget("entry_username")
		self.password = self.wTree.get_widget("entry_password")
		self.domain = self.wTree.get_widget("entry_domain")
		self.sharemem = self.wTree.get_widget("check_memcards")
		self.sharedocs = self.wTree.get_widget("check_mydocs")
		self.colordepth = self.wTree.get_widget("cmb_color")
		self.sound = self.wTree.get_widget("cmb_sound")
		self.recent = self.wTree.get_widget("lst_recent")
		self.toolbar = self.wTree.get_widget("toolbar")
		self.mainMenu = self.wTree.get_widget("menu_main")

		#Advanced Preferences Dialog -- Advanced Tab
		self.pref_console = self.wTree.get_widget("pref_console")
		self.dlg_advanced = self.wTree.get_widget("dlg_advanced")
		self.pref_compression = self.wTree.get_widget("pref_compression")
		self.pref_bitmap = self.wTree.get_widget("pref_bitmap")
		self.pref_encryption = self.wTree.get_widget("pref_encryption")
                
                #Advanced Preferences Dialog -- Experience Tab
                self.cmb_exp_preset = self.wTree.get_widget("cmb_exp_preset")
                self.chk_exp_desktop = self.wTree.get_widget("chk_exp_desktop")
                self.chk_exp_font = self.wTree.get_widget("chk_exp_font")
                self.chk_exp_composition = self.wTree.get_widget("chk_exp_composition")
                self.chk_exp_drag = self.wTree.get_widget("chk_exp_drag")
                self.chk_exp_animation = self.wTree.get_widget("chk_exp_animation")
                self.chk_exp_themes = self.wTree.get_widget("chk_exp_themes")
                self.chk_exp_bitmap = self.wTree.get_widget("chk_exp_bitmap")
                
                #Advanced Preferences Dialog -- General
		self.pref_cancel = self.wTree.get_widget("pref_cancel")
		self.pref_save = self.wTree.get_widget("pref_save")

		#About dialog
		self.dlg_about = self.wTree.get_widget("dlg_about")

		#Hooray hildon!
		self.app = hildon.Program()
		self.window.set_title("gui")
		self.app.add_window(self.window)

		#Redo the menu from the glade file...
		menu = gtk.Menu()
		for child in self.mainMenu.get_children():
			child.reparent(menu)
		self.window.set_menu(menu)

		self.mainMenu.destroy()

		#Get the profile list set up...
		self.column = gtk.TreeViewColumn("recent", gtk.CellRendererText(), text=0)
		self.profname = gtk.TreeViewColumn("profname", gtk.CellRendererText(), text=1)	
		self.recent.append_column(self.column)
		self.recent.append_column(self.profname)
		self.recentList = gtk.ListStore(str,str)
		self.recent.set_model(self.recentList)
		self.profname.set_visible(False)
		#We load the profiles down a bit lower, once GConf is already set up

		#Make sure these have the first value selected (not no value)		
		self.colordepth.set_active(0)
		self.sound.set_active(0)
                self.cmb_exp_preset.set_active(0)

		#Hooray hildon! :-P  Don't autocapitalize host, username, password, and don't predict for password
		self.host.set_property('hildon-input-mode', (1 << 0 | 1 << 1 | 1 << 2))
		self.username.set_property('hildon-input-mode', (1 << 0 | 1 << 1 | 1 << 2))
		self.password.set_property('hildon-input-mode', (1 << 0 | 1 << 1 | 1 << 2 | 1 << 29))
		
		#Keep track of which profile is selected -- This will be the number as a string ex: "1"
		self.current_profile = ""

		#Setup GConf and load profiles
		self.client = gconf.client_get_default()
		if self.client.dir_exists("/apps/rdesktop") == True :
			#Find all profiles, and add them to the list
			self.dirs = self.client.all_dirs("/apps/rdesktop")
			for profile in self.dirs :
				self.recentList.append([self.client.get_string(profile+"/name"),profile])
			load_prof = self.client.get_string("/apps/rdesktop/load_prof")
			if load_prof != None :
				self.load_profile("", "", "", "/apps/rdesktop/prof"+load_prof)
                                self.current_profile = load_prof
		else :
			#No preferences?  Just make the /apps/rdesktop dir, and everything should work fine
			self.client.add_dir("/apps/rdesktop", gconf.CLIENT_PRELOAD_NONE)
                        
                self.changing_preset = False

		self.about_dialog = None  #-- Not sure if I need these two
		self.error_dialog = None  #-- lines...

		dic = {
			# Process signal from button
			"connect" : self.connect,
			"quit" : self.cancel,
			"closeme" : self.cancel,
			"new_profile" : self.new_profile,
			"save_profile" : self.save_profile,
			"delete_profile" : self.delete_profile,
			"load_prof" : self.load_profile,
			"exit_prog" : gtk.main_quit,
			"show_extra" : self.show_extra,
			"show_about" : self.show_about,
			"save_advanced" : self.ok_advanced,
			"cancel_advanced" : self.cancel_advanced,
                        "exp_preset_change" : self.exp_preset_change,
                        "change_exp" : self.change_exp}
		self.wTree.signal_autoconnect(dic)
		
	def ErrPopUp(self,msg):
		error_dialog = gtk.MessageDialog(None,0,gtk.MESSAGE_ERROR,gtk.BUTTONS_CLOSE,msg)
		def close(dialog, response, editor):
			editor.about_dialog = None
			dialog.destroy()
		error_dialog.connect("response", close, self)
		# error_dialog.connect("delete-event", delete_event, self)
		self.error_dialog = error_dialog
		error_dialog.run()
                
        def change_exp(self, widget) :
                #Called when an experience box is toggled
                #To avoid confusion, this should change the experience combo to "Custom"
                if self.changing_preset == False :
                        self.cmb_exp_preset.set_active(4)
        
        def reset_exp_checks(self) :
                self.chk_exp_desktop.set_active(False)
                self.chk_exp_font.set_active(False)
                self.chk_exp_composition.set_active(False)
                self.chk_exp_drag.set_active(False)
                self.chk_exp_animation.set_active(False)
                self.chk_exp_themes.set_active(False)
                self.chk_exp_bitmap.set_active(False)
        
        def exp_preset_change(self, widget) : #If we change the presets, update the checkboxes
                #I was smart when writing this function, to avoid rewriting code
                #The presets just add on themselves going up...
                self.changing_preset = True
		preset = self.cmb_exp_preset.get_active()
		if preset < 4 :
		    self.reset_exp_checks()
		    if preset >= 0 :
			    self.chk_exp_bitmap.set_active(True)
		    if preset >= 1 :
			    self.chk_exp_themes.set_active(True)
		    if preset >= 2 :
			    self.chk_exp_animation.set_active(True)
			    self.chk_exp_drag.set_active(True)
			    self.chk_exp_composition.set_active(True)
		    if preset >= 3 :
			    self.chk_exp_font.set_active(True)
			    self.chk_exp_desktop.set_active(True)
                #if self.cmb_exp_preset.get_active() == 4 :
                #        self.reset_exp_checks()
                #At first, I thought selecting "Custom" should clear the checkboxes...
                #  I changed my mind...
                self.changing_preset = False

	def ok_advanced(self, widget) :
		self.dlg_advanced.hide()

	def cancel_advanced(self, widget) :
                #Reset the Advanced Tab
		self.pref_console.set_active(self._tempconsole)
		self.pref_compression.set_active(self._tempcompress)
		self.pref_bitmap.set_active(self._tempbitmap)
		self.pref_encryption.set_active(self._tempencryption)
                #Reset the experience tab
                self.cmb_exp_preset.set_active(self._tempexp_preset)
                self.chk_exp_desktop.set_active(self._tempexp_desktop)
                self.chk_exp_font.set_active(self._tempexp_font)
                self.chk_exp_composition.set_active(self._tempexp_composition)
                self.chk_exp_drag.set_active(self._tempexp_drag)
                self.chk_exp_animation.set_active(self._tempexp_animation)
                self.chk_exp_themes.set_active(self._tempexp_themes)
                self.chk_exp_bitmap.set_active(self._tempexp_bitmap)
		self.dlg_advanced.hide()

	def show_extra(self,widget):
		#self.dlg_advanced.show()
		self._tempconsole = self.pref_console.get_active()
		self._tempcompress = self.pref_compression.get_active()
		self._tempbitmap = self.pref_bitmap.get_active()
		self._tempencryption = self.pref_encryption.get_active()
                #Temporary variables for experience tab
                self._tempexp_preset = self.cmb_exp_preset.get_active()
                self._tempexp_desktop = self.chk_exp_desktop.get_active()
                self._tempexp_font = self.chk_exp_font.get_active()
                self._tempexp_composition = self.chk_exp_composition.get_active()
                self._tempexp_drag = self.chk_exp_drag.get_active()
                self._tempexp_animation = self.chk_exp_animation.get_active()
                self._tempexp_themes = self.chk_exp_themes.get_active()
                self._tempexp_bitmap = self.chk_exp_bitmap.get_active()
		result = self.dlg_advanced.run()
		if result == 1 :
			self.ok_advanced("")
		else :
			self.cancel_advanced("")

	def show_about(self, widget):
		response = self.dlg_about.run()
		self.dlg_about.hide()

	def save_profile(self,widget):
		if self.current_profile == "" :
			#This is a new profile!  We'll name the profiles with numbers (prof1, prof2, ...)...
			#First, find all directories under /apps/rdesktop
			dirs = self.client.all_dirs("/apps/rdesktop")
			if dirs == () :
				#There are no profiles... this is the first one!
				self.client.add_dir("/apps/rdesktop/prof1", gconf.CLIENT_PRELOAD_NONE)
				#Now, save the information
				self.save("prof1")
				#Finally, the newly saved profile should be added to the list, and selected...  TODO: Actually add to list, and select
				self.current_profile = "1"
			else :
				#There are some profiles... figure out the last one, and add one to the number...
				#This regex simply searches for all numbers
				p = re.compile("\d+")
				#Find the first number (There'll only be one) and add one to its value
				num = int(p.findall(dirs[-1])[0]) + 1
				#Create the directory for the profile
				self.client.add_dir("/apps/rdesktop/prof"+str(num),gconf.CLIENT_PRELOAD_NONE)
				#And run the magic save function
				self.save("prof"+str(num))
				#Then, set current_profile to the current profile
				self.current_profile = str(num)
			#And, finally, add the profile to the profile list on the left...
			self.recentList.append([self.client.get_string("/apps/rdesktop/prof"+self.current_profile+"/name"),"/apps/rdesktop/prof"+self.current_profile])
		else :
			#This is really simple... since there's already a profile, we just need to save it!
			if self.name.get_text() == self.client.get_string("/apps/rdesktop/prof"+self.current_profile+"/name") :
				reload = True #Reload the list if we rename the profile...
			else :
				reload = False
			self.save("prof" + self.current_profile)
			if reload == True :
				self.recentList.clear()
				self.dirs = self.client.all_dirs("/apps/rdesktop")
				for profile in self.dirs :
					self.recentList.append([self.client.get_string(profile+"/name"),profile])

	def connect(self,widget):
		#Fullscreen, keep window manager keybindings, and username
		to_run = "-f"

		#Username
		if self.username.get_text() != "" :
			to_run = to_run + " -u \"" + self.username.get_text()+"\""

		#Domain
		if self.domain.get_text() != "" :
			to_run = to_run + " -d \"" + self.domain.get_text()+"\""

		#Password
		if self.password.get_text() != "" :
			to_run = to_run + " -p \"" + self.password.get_text()+"\""

		#Give it a good title...
		to_run = to_run + " -T \""+self.name.get_text()+"\""

		# Share media cards?
		if self.sharemem.get_active() == True :
			to_run = to_run + " -r disk:mmc1=/media/mmc1,mmc2=/media/mmc2"

		#Share MyDocs?
		if self.sharedocs.get_active() == True :
			to_run = to_run + " -r disk:MyDocs=/home/user/MyDocs"

		#RDP Compression?
		if self.pref_compression.get_active() == True :
			to_run = to_run + " -z"

		#RDP Encryption?
		if self.pref_encryption.get_active() == False :
			to_run = to_run + " -E"

		#Color depth handling
		if self.colordepth.get_active() == 0 :
			to_run = to_run + " -a 8"
		elif self.colordepth.get_active() == 1 :
			to_run = to_run + " -a 15"
		elif self.colordepth.get_active() == 2 :
			to_run = to_run + " -a 16"
		else :
			to_run = to_run + " -a 24"

		#Persistant bitmap caching
		if self.pref_bitmap.get_active() == True :
			to_run = to_run + " -P"

		# Sound handling
		if self.sound.get_active() == 0 :
			to_run = to_run + " -r sound:off"
		elif self.sound.get_active() == 1 :
			to_run = to_run + " -r sound:local"
		else :
			to_run = to_run + " -r sound:remote"

		#Console mode? -- I wasn't sure how this worked, but appearently it's required sometimes...
		if self.pref_console.get_active() == True :
			to_run = to_run + " -0"
                        
                #TODO: RDP Experience Falgs! -x
                #Check for Presets first... we can have those pre-defined
                tempexp = 0x00
                if self.chk_exp_desktop.get_active() == False :
                        tempexp = tempexp | 0x01
                if self.chk_exp_font.get_active() == False :
                        tempexp = tempexp | 0x80
                if self.chk_exp_composition.get_active() == False :
                        tempexp = tempexp | 0x20
                if self.chk_exp_drag.get_active() == False :
                        tempexp = tempexp | 0x02
                if self.chk_exp_animation.get_active() == False :
                        tempexp = tempexp | 0x04
                if self.chk_exp_themes.get_active() == False :
                        tempexp = tempexp | 0x08
                if self.chk_exp_bitmap.get_active() == False :
                        tempexp = tempexp | 0x40
                to_run = to_run + " -x " + str(tempexp)

		#Now run it! -- I'd like to be able to keep the GUI open, but I need to figure out threading, first...
		#self.window.hide()
		#while gtk.events_pending():
		#	gtk.main_iteration()

		rdpThread(self.name.get_text(), self.host.get_text(), to_run).start()
		#Because we don't store the thread anywhere, we now loose control of the thread...
		# But that's ok, because we don't need to do anything with it!

	def cancel(self,widget) :
		#print "quitting @ cancel...?"
		if self.current_profile != "" :
			self.client.set_string("/apps/rdesktop/load_prof", self.current_profile)
		gtk.main_quit()

	def save(self,prof) :
		self.client.set_string("/apps/rdesktop/"+prof+"/name", self.name.get_text())
		self.client.set_string("/apps/rdesktop/"+prof+"/server", self.host.get_text())
		self.client.set_string("/apps/rdesktop/"+prof+"/username", self.username.get_text())
		self.client.set_string("/apps/rdesktop/"+prof+"/password", self.password.get_text())
		self.client.set_string("/apps/rdesktop/"+prof+"/domain", self.domain.get_text())
		self.client.set_bool("/apps/rdesktop/"+prof+"/mountMMC", self.sharemem.get_active())
		self.client.set_bool("/apps/rdesktop/"+prof+"/mountMyDocs", self.sharedocs.get_active())
		self.client.set_int("/apps/rdesktop/"+prof+"/colordepth", self.colordepth.get_active())
		self.client.set_int("/apps/rdesktop/"+prof+"/sound", self.sound.get_active())
		self.client.set_bool("/apps/rdesktop/"+prof+"/console", self.pref_console.get_active())
		self.client.set_bool("/apps/rdesktop/"+prof+"/compression", self.pref_compression.get_active())
		self.client.set_bool("/apps/rdesktop/"+prof+"/bitmap", self.pref_bitmap.get_active())
		self.client.set_bool("/apps/rdesktop/"+prof+"/encryption", self.pref_encryption.get_active())
                self.client.set_int("/apps/rdesktop/"+prof+"/exp_preset", self.cmb_exp_preset.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_desktop", self.chk_exp_desktop.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_font", self.chk_exp_font.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_composition", self.chk_exp_composition.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_drag", self.chk_exp_drag.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_animation", self.chk_exp_animation.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_themes", self.chk_exp_themes.get_active())
                self.client.set_bool("/apps/rdesktop/"+prof+"/exp_bitmap", self.chk_exp_bitmap.get_active())

	def new_profile(self,widget) :
		#This is just a placeholder - Not anymore!
		#self.ErrPopUp("You clicked the new profile button!")
		self.current_profile = ""
		self.name.set_text("")
		self.host.set_text("")
		self.username.set_text("")
		self.password.set_text("")
		self.domain.set_text("")
		self.sharemem.set_active(False)
		self.sharedocs.set_active(False)
		self.colordepth.set_active(0)
		self.sound.set_active(0)
		self.pref_console.set_active(False)
		self.pref_compression.set_active(True)
		self.pref_bitmap.set_active(True)
		self.pref_encryption.set_active(True)
                self.cmb_exp_preset.set_active(0)
                self.chk_exp_desktop.set_active(False)
                self.chk_exp_font.set_active(False)
                self.chk_exp_composition.set_active(False)
                self.chk_exp_drag.set_active(False)
                self.chk_exp_animation.set_active(False)
                self.chk_exp_themes.set_active(False)
                self.chk_exp_bitmap.set_active(True)

	def delete_profile(self, widget) :
		#This is just a placeholder
		#self.ErrPopUp("You clicked the delete profile button!  Deleting "+self.current_profile)
		#self.client.recursive_unset("/apps/rdesktop/prof"+self.current_profile,0)
		keys = self.client.all_entries("/apps/rdesktop/prof"+self.current_profile)
		for key in keys :
			self.client.unset(key.get_key())
		self.client.remove_dir("/apps/rdesktop/prof" + self.current_profile)
		self.new_profile("")
		#I think the easiest way to do this is to just reload all profiles
		self.recentList.clear()
		self.dirs = self.client.all_dirs("/apps/rdesktop")
		for profile in self.dirs :
			self.recentList.append([self.client.get_string(profile+"/name"),profile])
		#For whatever reason, sometimes blanks show up in the list box after deleting a profile
		#Let's reload the list agian, just to avoid that...
		self.recentList.clear()
		self.dirs = self.client.all_dirs("/apps/rdesktop")
		for profile in self.dirs :
			self.recentList.append([self.client.get_string(profile+"/name"),profile])

	def load_profile(self, widget, path, view_column, profile="") :
		#selection = self.recent.get_selection()
		if path != "" :
			profile = str(self.recentList.get_value(self.recentList.get_iter(path),1))
		self.name.set_text(self.client.get_string(profile + "/name"))
		self.host.set_text(self.client.get_string(profile + "/server"))
		self.username.set_text(self.client.get_string(profile + "/username"))
		self.password.set_text(self.client.get_string(profile + "/password"))
		self.domain.set_text(self.client.get_string(profile + "/domain"))
		self.sharemem.set_active(self.client.get_bool(profile + "/mountMMC"))
		self.sharedocs.set_active(self.client.get_bool(profile + "/mountMyDocs"))
		self.colordepth.set_active(self.client.get_int(profile + "/colordepth"))
		self.sound.set_active(self.client.get_int(profile + "/sound"))
		self.pref_console.set_active(self.client.get_bool(profile + "/console"))
		self.pref_compression.set_active(self.client.get_bool(profile + "/compression"))
		self.pref_bitmap.set_active(self.client.get_bool(profile + "/bitmap"))
		self.pref_encryption.set_active(self.client.get_bool(profile + "/encryption"))
                self.cmb_exp_preset.set_active(self.client.get_int(profile + "/exp_preset"))
                self.chk_exp_desktop.set_active(self.client.get_bool(profile + "/exp_desktop"))
                self.chk_exp_font.set_active(self.client.get_bool(profile + "/exp_font"))
                self.chk_exp_composition.set_active(self.client.get_bool(profile + "/exp_composition"))
                self.chk_exp_drag.set_active(self.client.get_bool(profile + "/exp_drag"))
                self.chk_exp_animation.set_active(self.client.get_bool(profile + "/exp_animation"))
                self.chk_exp_themes.set_active(self.client.get_bool(profile + "/exp_themes"))
                self.chk_exp_bitmap.set_active(self.client.get_bool(profile + "/exp_bitmap"))
		p = re.compile("\d+")
		num = p.findall(profile)[0]
		#self.ErrPopUp("selected prof"+num)
		self.current_profile = num

def startGTK() :
	gtk.main()
	#sys.exit(1)

if __name__ == "__main__":
	gtk.set_application_name("rdesktop")
	title = 'rdesktop'
	handle = rdesktop()
	#bus = dbus.SystemBus(private=True)
	gtk.gdk.threads_init()
	#threading.Thread(target=startGTK,name="gtk").start()
	gtkrunning = True
	gtk.main()
	gtkrunning = False
	#while threading.activeCount() > 1:
		#for thread in threading.enumerate():
			#print thread.getName()
	#	time.sleep(1)
	#sys.exit(1)
	time.sleep(1)
	#print "Quitting... ?"
