/*
 * This file is part of pwsafe
 *
 * Copyright (C) 2005 HolisTech Limited
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include <src/preferences.h>

#include <gconf/2/gconf/gconf.h>
#include <gconf/2/gconf/gconf-client.h>

/* private */

const gchar* conf_paths[]={ 
/* pay no attention to the code behind the curtain... matches order of conf_type...  */
	"/apps/maemo/pwsafemaemo/file0",
	"/apps/maemo/pwsafemaemo/icon_size"
};

/* functions */

gchar *conf_get_string(conf_type type) {
	GConfClient *gc_client;
	gchar *result=NULL;
	g_assert(type<=CONF_LAST_CONF_TYPE);
	g_type_init();
	gc_client = gconf_client_get_default();
	if (gc_client) {
		result=gconf_client_get_string(gc_client, conf_paths[type], NULL);
		g_object_unref(gc_client);
	}
	return result;
}

void conf_save_string(conf_type type, char *txt) {
	GConfClient *gc_client;
	g_assert(type<=CONF_LAST_CONF_TYPE);
	g_type_init();
	gc_client = gconf_client_get_default();
	if (gc_client) {
		gconf_client_set_string(gc_client, conf_paths[type], txt, NULL);
		g_object_unref(gc_client);
	}
}
