// maybe call this powerin

#define MAEMO_CHANGES
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>
#include <X11/Xatom.h>

// HILDON_HARDKEY_MENU == GDK_F4 == XK_F4 
#define GLOBAL_HOTKEY XK_F4

#define HILDON_IM_WINDOW_ID_FORMAT 32

static Window get_window_id(Atom window_atom)
{
    // This code from hildon-input-method-framework
    // Retrieves the X window id of the IM

    Window result = None;
    unsigned long n = 0;
    unsigned long extra = 0;
    gint format = 0;
    gint status = 0;

    Atom realType;
    union
    {
        Window *win;
        unsigned char *val;
    } value;

    status = XGetWindowProperty(GDK_DISPLAY(), GDK_ROOT_WINDOW(), window_atom, 0L, 4L, 0,
                                XA_WINDOW, &realType, &format, &n, &extra, (unsigned char **) &value.val);

    if (status == Success && realType == XA_WINDOW && format == HILDON_IM_WINDOW_ID_FORMAT && n == 1 && value.win != None)
    {
        result = value.win[0];
        XFree(value.val);
    }
    else
        g_warning("Unable to get the window id");

    return result;
}

static void im_context_commit(GtkIMContext *ctx, const gchar *str, GtkWidget *widget)
{
    g_debug("in commit");
    if (*str != '\0')
    {
        g_debug("commit %s", str);

        //gtk_widget_hide(window);

        gunichar c = g_utf8_get_char(str);
        g_debug("key %s", gdk_keyval_name(gdk_unicode_to_keyval(c)));

        // gdk key symbols are identical in value to X keysyms so we use gdk conversion function
        KeySym sym = gdk_unicode_to_keyval(c);
        g_debug("unicode %d, sym 0x%x", c, (unsigned int)sym);

        KeyCode ctrl = XKeysymToKeycode(GDK_DISPLAY(), XStringToKeysym("Control_L"));

        //gtk_window_set_accept_focus(window, FALSE);

        int min, max, numcodes;
        XDisplayKeycodes(GDK_DISPLAY(), &min, &max);
        KeySym *mapping;
        mapping = XGetKeyboardMapping(GDK_DISPLAY(), min, max-min+1, &numcodes);
        g_debug("min %d max %d numcodes %d", min, max, numcodes);
        mapping[(max-min-1)*numcodes] = sym;
        XChangeKeyboardMapping(GDK_DISPLAY(), min, numcodes, mapping, (max-min));
        XFlush(GDK_DISPLAY());
        XFree(mapping);

        KeyCode code = XKeysymToKeycode(GDK_DISPLAY(), sym);
        if (!code)
            code = 254;

        //gtk_window_iconify(GTK_WINDOW(widget));
        if (!code)
        {
            g_warning("keycode for sym 0x%x not found", (unsigned int)sym);
        }
        else
        {
            //XTestFakeKeyEvent(GDK_DISPLAY(), ctrl, True, CurrentTime);
            XTestFakeKeyEvent(GDK_DISPLAY(), code, True, CurrentTime);
            XTestFakeKeyEvent(GDK_DISPLAY(), code, False, CurrentTime);
            //XTestFakeKeyEvent(GDK_DISPLAY(), ctrl, False, CurrentTime);
        }
        XFlush(GDK_DISPLAY());

        //gtk_widget_show(window);
    }
    //gtk_im_context_set_client_window(ctx, GTK_WIDGET(widget)->window);
    //hildon_gtk_im_context_show(ctx);
    //gtk_im_context_focus_in(ctx);

    GdkScreen *screen = gdk_screen_get_default();
    GdkWindow *active = gdk_screen_get_active_window(screen);
    Atom atom = gdk_x11_get_xatom_by_name("_HILDON_IM_WINDOW");
    Window im_window = get_window_id(atom);
    g_debug("got im window 0x%x active 0x%x", (unsigned int)im_window, (unsigned int)GDK_WINDOW_XID(active));
    GdkWindow *im = gdk_window_foreign_new(im_window);
    //hildon_gtk_im_context_hide(ctx);
    gdk_window_hide(im);
    XSetTransientForHint(GDK_DISPLAY(), im_window, GDK_WINDOW_XID(active));
    gdk_window_show(im);    
    //gdk_window_set_transient_for(im, active);
    /*
    hildon_gtk_im_context_show(ctx);
    gtk_im_context_focus_in(ctx);
    gtk_im_context_set_client_window(ctx, GTK_WIDGET(widget)->window);
    gdk_window_show(im);    
    */
}

static gboolean event_keypress(GtkWidget *widget, GdkEventKey *event, GdkWindow *active)
{
    g_debug("Key pressed : 0x%x (%s)", event->keyval, gdk_keyval_name(event->keyval));
    return FALSE;
}

GdkFilterReturn test_filter(GdkXEvent *gdk_xevent, GdkEvent *event, GdkWindow *active)
{
    GdkEventKey *keyevent;
    XEvent *xevent   = (XEvent *) gdk_xevent;
    KeyCode keycode  = xevent->xkey.keycode;
    guint modifiers  = xevent->xkey.state;
    g_debug("in filter win: %lx type: %d", xevent->xany.window, xevent->type);
    if (xevent->type == KeyPress) 
    {
        g_debug("win 0x%x key %d", ((GdkEventAny *)event)->window, keycode);
        event->type = GDK_KEY_PRESS;
        keyevent = (GdkEventKey *) event;
        keyevent->hardware_keycode  = keycode;
        keyevent->keyval            = 0;
        keyevent->length            = 0;
        keyevent->send_event        = FALSE;
        keyevent->state             = (GdkModifierType) modifiers;
        keyevent->string            = NULL;
        keyevent->time              = GDK_CURRENT_TIME;
        keyevent->window            = active;
        
        g_debug("send to window 0x%x", (unsigned int)GDK_WINDOW_XID(active));
        return GDK_FILTER_TRANSLATE;
    }
    else if (xevent->type == ClientMessage) 
    {
        g_debug("client message %d", xevent->xclient.message_type);
    }

    return GDK_FILTER_CONTINUE;
}

static void event_realize(GtkWidget *widget, gpointer data)
{
    gtk_window_move(GTK_WINDOW(widget), -1, -1);
    g_debug("event realize");
}

static gboolean test_blah(GdkWindow *active)
{
    Atom atom = gdk_x11_get_xatom_by_name("_HILDON_IM_WINDOW");
    Window im_window = get_window_id(atom);
    g_debug("got im window 0x%x active 0x%x", (unsigned int)im_window, (unsigned int)GDK_WINDOW_XID(active));
    GdkWindow *im = gdk_window_foreign_new(im_window);

    gdk_window_hide(im);
    XFlush(GDK_DISPLAY());
    XSetTransientForHint(GDK_DISPLAY(), im_window, GDK_WINDOW_XID(active));
    XSetTransientForHint(GDK_DISPLAY(), im_window, 0x1400003);
    XFlush(GDK_DISPLAY());
    gdk_window_show(im);
    return FALSE;
}

/*
void key_grab (gchar *key) 
{
    //XGrabKey(dpy, XKeysymToKeycode(dpy, key), modmask, root, True, GrabModeAsync, GrabModeAsync);
    //XGrabKey(dpy, XKeysymToKeycode(dpy, key), LockMask | modmask, root, True, GrabModeAsync, GrabModeAsync);
}


some_function()
{
    KeySym grabbed_key;
    XEvent event;

    if (!(dpy = XOpenDisplay(NULL)))
        fprintf (stderr, "Can't open Display %s", XDisplayName(NULL));

    screen = DefaultScreen(dpy);
    root = RootWindow(dpy, screen);

    key_grab ();

    for (;;)
    {
        XNextEvent(dpy, &event);

        switch (event.type)
        {
            case KeyPress:
                grabbed_key = XKeycodeToKeysym(dpy, event.xkey.keycode, 0);

                if (key == grabbed_key)
                {
                    WHATEVER_YOU_WANT_IT_TO_DO ();
                    break;
                }
            default:
                break;
        }
    }
}
*/

int main(int argc, char *argv[])
{
    gtk_init(&argc, &argv);

    int event_base, error_base, major_version, minor_version;
    if (! XTestQueryExtension(GDK_DISPLAY(), &event_base, &error_base, &major_version, &minor_version))
    {
        g_critical("XTest not supported");
        return 1;
    }

    GdkScreen *screen = gdk_screen_get_default();
    GdkWindow *active = gdk_screen_get_active_window(screen);
    if (!active)
    {
        g_critical("Could not get active window");
        return 1;
    }

    /*
    int num;
    KeySym *syms = XGetKeyboardMapping(GDK_DISPLAY(), 65, 1, &num);
    g_debug("ret %d", num);
    int i;
    for (i = 0; i < num; i++)
    {
        g_debug("%d 0x%x", i, (unsigned int) syms[i]);
    }
    */

    GtkWindow *window = GTK_WINDOW(g_object_new(GTK_TYPE_WINDOW,
                                                "decorated", FALSE,
                                                "default-height", 1,
                                                "default-width", 1,
                                                "accept-focus", FALSE,
                                                "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION,
                                                NULL));

    g_signal_connect(GTK_WIDGET(window), "realize", G_CALLBACK(event_realize), NULL);
    g_signal_connect(G_OBJECT(window), "key_press_event", G_CALLBACK(event_keypress), active);


    gpointer widget_class = g_type_class_ref(GTK_TYPE_WIDGET); // have to first load this to avoid errors
	GtkIMContext *im_context = gtk_im_multicontext_new(); // the context for the keyboard input method
    g_signal_connect(im_context, "commit", G_CALLBACK(im_context_commit), window);
    gtk_widget_show_all(GTK_WIDGET(window));
    gtk_im_context_set_client_window(im_context, active);
    hildon_gtk_im_context_show(im_context);
    gtk_im_context_focus_in(im_context);

    Window root = GDK_WINDOW_XID(gdk_get_default_root_window());
    XGrabKey(GDK_DISPLAY(), XKeysymToKeycode(GDK_DISPLAY(), XK_F4), AnyModifier, root, False, GrabModeAsync, GrabModeAsync);

    gdk_window_add_filter(NULL, (GdkFilterFunc)test_filter, active);
    
    //hildon_gtk_im_context_hide(ctx);
    gtk_im_context_set_client_window(im_context, GTK_WIDGET(window)->window);
    g_timeout_add(1000, (GSourceFunc)test_blah, active);

    gtk_main();

    XUngrabKey(GDK_DISPLAY(), AnyKey, AnyModifier, root);
 
    g_object_unref(widget_class);
    gtk_im_context_hide(im_context);
    gtk_im_context_reset(im_context);
    g_object_unref(im_context);
    g_object_unref(active);
    return 0;
}
