#ifndef UTILS_H
#define UTILS_H

#include <glib.h>

#define warn_and_return(...) do { g_warning(__VA_ARGS__); return; } while(0)
#define warn_and_return_null(...) do { g_warning(__VA_ARGS__); return NULL; } while(0)
#define warn_and_return_false(...) do { g_warning(__VA_ARGS__); return FALSE; } while(0)

void store_init();
void store_uninit();
void store_free_all();
const gchar *store_get_variable(const gchar *name);
void store_set_variable(const gchar *name, const gchar *val);
const gchar *string_ref(gchar *str);
const gchar *string_ref_dup(const gchar *str);
void string_unref(const gchar *str);
const gchar *store_temp_string(gchar *str);
void temp_strings_free();
GList *add_or_move_to_front(GList *list, gpointer data);

#endif
