#ifndef LAUNCHER_H
#define LAUNCHER_H

#include <glib.h>

typedef struct _LaunchMode LaunchMode;

void launcher_init();
void launcher_uninit();
LaunchMode *current_mode();
gboolean launcher_run_handler(const gchar *name);
gboolean mode_run_handler(LaunchMode *mode, const gchar *name);
const gchar *mode_get_name(LaunchMode *mode);
const gchar *mode_get_namespace(LaunchMode *mode);
gboolean load_initial_mode(const char *initial_mode);
gchar *find_file(const gchar *namespace, const gchar *extension);

#endif
