#ifndef ACTIONS_H
#define ACTIONS_H

#include <glib-object.h>

typedef union 
{
    const gchar *v_str;
    gpointer v_ptr;
} DataValueType;

typedef struct _ActionData ActionData;

typedef void (*DataFreeFn)(ActionData *data);
typedef const char *(*SysVarFn)();

/* fills in val from data. returns FALSE on error. caller zeroes out GValue before call and owns the GValue after the call */
typedef gboolean (*DataToValFn)(ActionData *data, GValue *val); 

typedef struct
{
    DataToValFn getval;         /* primary function to take a ActionData and fill in a GValue */
    DataFreeFn free;            /* Called to free data. Can be NULL. */
    gboolean dynamic;           /* TRUE if calling getval again could give a different result */
} ActionDataType;

struct _ActionData
{
    ActionDataType *type;
    DataValueType val;
};

typedef const gchar *(*CallGetArgFn)(gpointer call, int n);
typedef GArray ActionList;
typedef GValueArray ArgumentList;
typedef void (*ActionFn)(ArgumentList *args);

const gchar *g_value_to_string(GValue *val);
GValue *get_argument(ArgumentList *list, int arg);
#define get_argument_str(args, n) g_value_to_string(get_argument(args, n))
int get_num_args(ArgumentList *args);

void actions_init();
void actions_uninit();
void actions_run(ActionList *actions);
ActionList *actions_parse(gchar **actions, gsize numactions);
void actions_free(ActionList *actions);

void call_stack_push(ArgumentList *args);
void call_stack_pop();

void action_sys_variable_define(const gchar *name, SysVarFn fn);
void action_data_subst_define(const gchar *name, ActionDataType *type);
void action_define(const gchar *name, ActionFn fn, int fixed_args, gboolean variable_args);

void data_string_free(ActionData *data);

#endif
