#ifndef MCE_H
#define MCE_H

#include <mce/dbus-names.h>
#include <mce/mode-names.h>

gboolean mce_request_change_devicelock_code(Powered *server, gchar *oldcode, gchar *salt, gchar *newcode, gboolean *result, GError **error);
gboolean mce_request_get_devicelock_mode(Powered *server, gchar **mode, GError **error);
gboolean mce_request_get_tklock_mode(Powered *server, gchar **mode, GError **error);
gboolean mce_request_get_version(Powered *server, gchar **version, GError **error);
gboolean mce_request_req_powerup(Powered *server, GError **error);
gboolean mce_request_req_tklock_mode_change(Powered *server, gchar *mode, GError **error);
gboolean mce_request_req_trigger_powerkey_event(Powered *server, gboolean longpress, GError **error);
gboolean mce_request_validate_devicelock_code(Powered *server, gchar *code, gchar *salt, gboolean *result, GError **error);
gboolean mce_request_set_alarm_mode(Powered *server, gchar *mode, GError **error);

// many mce dbus requests are mapped directly to powered requests
#define mce_request_get_device_mode powered_request_get_device_mode
#define mce_request_get_display_status powered_request_get_display_status
#define mce_request_get_inactivity_status powered_request_get_inactivity_status
#define mce_request_req_device_mode_change powered_request_set_device_mode
#define mce_request_req_display_blanking_pause  powered_request_display_blanking_pause
#define mce_request_req_display_state_dim powered_request_display_dim
#define mce_request_req_display_state_off powered_request_display_off
#define mce_request_req_display_state_on powered_request_display_on
#define mce_request_req_powerup powered_request_powerup
#define mce_request_req_reboot powered_request_reboot
#define mce_request_req_shutdown powered_request_shutdown
#define mce_request_req_led_pattern_activate powered_request_activate_led_pattern
#define mce_request_req_led_pattern_deactivate powered_request_deactivate_led_pattern
#define mce_request_req_led_enable powered_request_enable_led
#define mce_request_req_led_disable powered_request_disable_led

void mce_init(Powered *server, DBusGProxy *bus);

#define mce_send_signal(server, args...) do { if (server->emulate_mce) send_dbus_signal(server->dbus, MCE_SIGNAL_PATH, MCE_SIGNAL_IF, args); } while (0)
#endif
