/*
  Copyright (c) 2007-2008 Austin Che

  For communicating with BME
  Most of this was reverse-engineered and is not guaranteed to be correct
*/

#include <stdio.h>
#include <glib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <dbus/dbus.h>

#include "powered.h"

#define BME_SOCKET "/tmp/bme-dbus-socket"

static GIOChannel *bme;

static gboolean read_from_bme(GIOChannel *source, GIOCondition condition, gpointer data)
{
    g_debug("read from bme");
    return TRUE;                // don't remove this event source    
}

void bme_init(Powered *server)
{
    return;

    struct sockaddr_un addr;

    int bmesock = socket(PF_UNIX, SOCK_STREAM, 0);
    if (bmesock < 0) 
        g_error("bme socket failed");

    memset(&addr, 0, sizeof(addr));
    addr.sun_family = AF_UNIX;
    strcpy(addr.sun_path, BME_SOCKET);
    unlink(BME_SOCKET);
    if (bind(bmesock, (struct sockaddr *)&addr, sizeof(addr)) < 0)
    {
        close(bmesock);
        g_error("bme bind failed");
    }
  
    if (listen(bmesock, 1) < 0)   // we only expect one client (bme)
    {
        close(bmesock);
        g_error("bme listen failed");
    }

    g_debug("Created bme socket");

    // BME is actually at /tmp/.bmesrv
    // not sure what /tmp/bme-dbus-socket is for...
    //accept(bmesock, 
    bme = g_io_channel_unix_new(bmesock);
    g_io_add_watch(bme, G_IO_IN, read_from_bme, server);
    g_io_add_watch(bme, G_IO_PRI, read_from_bme, server);
    g_io_add_watch(bme, G_IO_ERR, read_from_bme, server);
    g_io_add_watch(bme, G_IO_HUP, read_from_bme, server);
      /*

    g_io_channel_set_flags(server->dsme, G_IO_FLAG_NONBLOCK, NULL);
    g_io_channel_set_encoding(server->dsme, NULL, NULL);
    g_io_channel_set_buffered(server->dsme, FALSE);
    g_io_channel_set_close_on_unref(server->dsme, TRUE);
    */
}

void bme_uninit(Powered *server)
{
}
