#!/bin/sh

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/powerlaunch
NAME=powerlaunch
DESC="Powerlaunch"
PIDFILE=/var/run/$NAME.pid
INITFILE=/etc/init.d/$NAME
DSMETOOL=/usr/sbin/dsmetool
DSMETOOL_PARAMETERS="-G users -U user -n -1 -f "
STOP_PARAMETERS="-k "
# HOME for GTK theming...
HOME=/home/user
. /etc/osso-af-init/af-defines.sh
. /etc/osso-af-init/osso-gtk.defs

# abort if no executable exists
test -x $DAEMON || exit 0

set -e

# default values that can be overridden in /etc/default/powerlaunch
SYSTEMUI_STOP=true
SYSTEMUI_START=true
POWERLAUNCH_OPTS=

if [ -r /etc/default/powerlaunch ]; then
    . /etc/default/powerlaunch
fi

powerlaunch_start()
{
	if ! pidof $DAEMON > /dev/null; then
		printf "Starting $DESC: $NAME"
		$DSMETOOL $DSMETOOL_PARAMETERS "$DAEMON $POWERLAUNCH_OPTS"
		printf ".\n"
	fi
}

case "$1" in
start)
    if [ "$START_POWERLAUNCH" != "true" ]; then
          echo "Not starting powerlaunch: disabled by /etc/default/powerlaunch."
          exit 0
    fi
    if [ "$SYSTEMUI_STOP" == "true" ]; then
      if pidof systemui > /dev/null; then
          printf "systemui is running...stopping\n"
          if [ -x "`which invoke-rc.d 2>/dev/null`" ]; then
              invoke-rc.d osso-systemui stop || exit $?
          else
             /etc/init.d/osso-systemui stop || exit $?
          fi
      fi
    fi

    powerlaunch_start
	;;

stop)
	printf "Stopping: $DESC: $NAME"
	$DSMETOOL $STOP_PARAMETERS $DAEMON
    sleep 2

	if pidof $DAEMON > /dev/null; then
		$DSMETOOL -S 9 $STOP_PARAMETERS "$DAEMON $POWERLAUNCH_OPTS"
		sleep 1
	fi								
	printf ".\n"

    if [ "$SYSTEMUI_START" == "true" ]; then
      if ! pidof systemui > /dev/null; then
        if [ -x "`which invoke-rc.d 2>/dev/null`" ]; then
            invoke-rc.d osso-systemui start || exit $?
        else
            /etc/init.d/osso-systemui start || exit $?
        fi
      fi
    fi
	;;

restart|force-reload)
	printf "Restarting $DESC: $NAME"
    $DSMETOOL $STOP_PARAMETERS $DAEMON
	sleep 2
	if pidof $DAEMON > /dev/null; then
	  $DSMETOOL -S 9 $STOP_PARAMETERS $DAEMON
	  sleep 1
	fi
	    
    powerlaunch_start
	printf ".\n"
	;;

*)
	printf "Usage: $INITFILE {start|stop|restart|force-reload}\n" >&2
	exit 1
	;;
esac

exit 0
