#ifndef MULTIVIEW_H
#define MULTIVIEW_H

#include "View.h"

#include <Lum/Object.h>

class MultiView : public Lum::Group
{
private:
  std::list<Base::ViewPtr> views;
  Base::ViewPtr            current;

public:
  MultiView();
  ~MultiView();

  bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);

  void CalcSize();
  void Layout();

  void AddView(Base::ViewPtr view);
  void ShowView(const std::wstring& name, Base::View::DataPtr data);
};

typedef MultiView *MultiViewPtr;

#endif
