#include "Search.h"

#include "../Database.h"

#include "../Data.h"

#include <Lum/Base/Util.h>

#include <Lum/Button.h>
#include <Lum/Menu.h>
#include <Lum/String.h>
#include <Lum/Space.h>

#include <Lum/Model/Selection.h>

#include <iostream>

namespace Views {

  class DataEntry : public Lum::Model::ListTable::Entry
  {
  public:
    ::Base::DataPtr data;

  public:
    DataEntry(Lum::Model::ListTable* table, ::Base::DataPtr data)
    : Lum::Model::ListTable::Entry(table),data(data)
    {
      // no code
    }

    std::wstring GetString(size_t column) const
    {
      switch (column) {
      case 1:
        return data->GetType()->GetName();
      case 2:
        return data->GetDisplayText();
      default:
        return L"";
      }
    }

    bool IsGreater(const Lum::Model::ListTable::Entry* other, size_t column) const
    {
      ::Base::DataPtr tmp=dynamic_cast<const DataEntry*>(other)->data;

      if (data->GetType()->GetName()==tmp->GetType()->GetName()) {
        return data->GetDisplayText()>tmp->GetDisplayText();
      }
      else {
        return data->GetType()->GetName()>tmp->GetType()->GetName();
      }
    }
  };

  Search::Search()
  : View(L"Search"),
    viewAction(new Lum::Model::Action),
    searchAction(new Lum::Model::Action),
    model(new Lum::Model::ListTable(2)),
    searchValue(new Lum::Model::String()),
    table(NULL),top(NULL)
  {
    searchValue->Set(L"");

    AttachModel(viewAction);
    AttachModel(searchAction);
  }

  Search::~Search()
  {
    UnattachModel(searchAction);
    UnattachModel(viewAction);

    delete top;
  }

  void Search::FillList()
  {
    model->Off();

    model->Clear();

    if (searchValue->Get()!=L"") {
      ::Base::DataConstIterator iter;

      iter=database->database.begin();
      while (iter!=database->database.end()) {
        for (size_t x=0; x<=(*iter)->GetType()->GetMaxAttribute(); x++) {
          if ((*iter)->GetAttribute(x).find(searchValue->Get())!=std::string::npos) {
            model->Append(new DataEntry(model,*iter));
            break;
          }
        }

        iter++;
      }

      model->Sort(1);
    }

    model->On();
  }

  bool Search::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (top!=NULL) {
      return visitor.Visit(top);
    }

    return true;
  }

  void Search::CalcSize()
  {
    Lum::Button           *button;
    Lum::Menu             *menu;
    Lum::String           *string;
    Lum::Panel            *horiz;
    Lum::Model::HeaderRef headerModel;

    top=new Lum::VPanel();
    top->SetParent(this);
    top->SetFlex(true,true);

    horiz=new Lum::HPanel();
    horiz->SetFlex(true,false);

    string=new Lum::String();
    string->SetFlex(true,false);
    string->SetModel(searchValue);
    string->SetReturnAction(searchAction);
    horiz->Add(string);

    button=new Lum::Button();
    button->SetFlex(false,true);
    button->SetModel(searchAction);
    button->SetText(L"_Search");
    horiz->Add(button);

    top->Add(horiz);

    top->Add(new Lum::VSpace());

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Type",Lum::Base::Size::stdCharWidth,8);
    headerModel->AddColumn(L"Description",Lum::Base::Size::stdCharWidth,50);

    table=new Lum::Table();
    table->SetFlex(true,true);
    table->SetShowHeader(true);
    table->SetModel(model);
    table->SetHeaderModel(headerModel);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(viewAction);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",viewAction);
    table->SetMenu(menu->GetWindow());

    top->Add(table);

    top->CalcSize();

    width=top->GetOWidth();
    height=top->GetOHeight();
    minWidth=top->GetOMinWidth();
    minHeight=top->GetOMinHeight();
    maxWidth=top->GetOMaxWidth();
    maxHeight=top->GetOMaxHeight();

    View::CalcSize();
  }

  void Search::Layout()
  {
    top->Resize(width,height);
    top->Move(x,y);

    View::Layout();
  }

  void Search::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==viewAction && viewAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t           line;
        Base::View::Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        data=new ::Base::View::Data(dynamic_cast< DataEntry*>(this->model->GetEntry(line))->data);
        GUI::GetInstance()->ShowView(data->data->GetType()->GetName(),data);
      }
    }
    else if (model==searchAction && searchAction->IsFinished()) {
      FillList();
    }
    else {
      View::Resync(model,msg);
    }
  }

  void Search::Load(::Base::View::DataPtr data=NULL)
  {
    FillList();
  }

  void Search::Vanish()
  {
    model->Clear();
  }
}
