#include "People.h"

#include "Person.h"

#include "../Database.h"

#include "../Data/Person.h"

#include <Lum/Base/Util.h>

#include <Lum/Button.h>
#include <Lum/Menu.h>
#include <Lum/Space.h>

#include <Lum/Model/Selection.h>

#include <iostream>

namespace Views {

  class PeopleEntry : public Lum::Model::ListTable::Entry
  {
  public:
    ::Data::PersonPtr person;

  public:
    PeopleEntry(Lum::Model::ListTable* table, ::Data::PersonPtr person)
    : Lum::Model::ListTable::Entry(table),person(person)
    {
      // no code
    }

    std::wstring GetString(size_t column) const
    {
      switch (column) {
      case 1:
        return person->GetAttribute(::Data::Person::PersonType::name);
      case 2:
        return person->GetAttribute(::Data::Person::PersonType::surename);
      default:
        return L"";
      }
    }

    bool IsGreater(const Lum::Model::ListTable::Entry* other, size_t column) const
    {
      ::Data::PersonPtr tmp=dynamic_cast<const PeopleEntry*>(other)->person;

      if (person->GetAttribute(::Data::Person::PersonType::name)==tmp->GetAttribute(::Data::Person::PersonType::name)) {
        return person->GetAttribute(::Data::Person::PersonType::surename)>tmp->GetAttribute(::Data::Person::PersonType::surename);
      }
      else {
        return person->GetAttribute(::Data::Person::PersonType::name)>tmp->GetAttribute(::Data::Person::PersonType::name);
      }
    }
  };

  People::People()
  : View(L"People"),
    viewAction(new Lum::Model::Action),
    addAction(new Lum::Model::Action),
    deleteAction(new Lum::Model::Action),
    model(new Lum::Model::ListTable(2)),
    table(NULL),top(NULL)
  {
    AttachModel(viewAction);
    AttachModel(addAction);
    AttachModel(deleteAction);
  }

  People::~People()
  {
    UnattachModel(deleteAction);
    UnattachModel(addAction);
    UnattachModel(viewAction);

    delete top;
  }

  void People::FillList()
  {
    model->Off();

    model->Clear();

    ::Base::DataConstIterator iter;

    iter=database->database.begin();
    while (iter!=database->database.end()) {
      ::Data::PersonPtr person;

      if ((person=dynamic_cast< ::Data::PersonPtr>(*iter))!=NULL) {
        model->Append(new PeopleEntry(model,person));
      }

      iter++;
    }

    model->Sort(1);

    model->On();
  }

  bool People::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (top!=NULL) {
      return visitor.Visit(top);
    }

    return true;
  }

  void People::CalcSize()
  {
    Lum::Menu             *menu;
    Lum::Model::HeaderRef headerModel;

    top=new Lum::VPanel();
    top->SetParent(this);
    top->SetFlex(true,true);

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Name",Lum::Base::Size::stdCharWidth,15,true);
    headerModel->AddColumn(L"Surename",Lum::Base::Size::stdCharWidth,15);

    table=new Lum::Table();
    table->SetFlex(true,true);
    table->SetShowHeader(true);
    table->SetModel(model);
    table->SetHeaderModel(headerModel);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(viewAction);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",viewAction);
    menu->AddActionItem(L"Add",addAction);
    menu->AddActionItem(L"Delete",deleteAction);
    table->SetMenu(menu->GetWindow());

    top->Add(table);

    top->CalcSize();

    width=top->GetOWidth();
    height=top->GetOHeight();
    minWidth=top->GetOMinWidth();
    minHeight=top->GetOMinHeight();
    maxWidth=top->GetOMaxWidth();
    maxHeight=top->GetOMaxHeight();

    View::CalcSize();
  }

  void People::Layout()
  {
    top->Resize(width,height);
    top->Move(x,y);

    View::Layout();
  }

  void People::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==viewAction && viewAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t line;
        Person::Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        data=new ::Base::View::Data(dynamic_cast< PeopleEntry*>(this->model->GetEntry(line))->person);
        GUI::GetInstance()->ShowView(L"Person",data);
      }
    }
    else if (model==addAction && addAction->IsFinished()) {
      Person::Data *data;

      data=new ::Base::View::Data(new ::Data::Person());
      GUI::GetInstance()->ShowView(L"Person",data);
    }
    else if (model==deleteAction && deleteAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t         line;
        ::Data::Person *person;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        person=dynamic_cast< PeopleEntry*>(this->model->GetEntry(line))->person;
        database->Remove(person);
        FillList();
      }
    }
    else {
      View::Resync(model,msg);
    }
  }

  void People::Load(::Base::View::DataPtr data=NULL)
  {
    FillList();
  }

  void People::Vanish()
  {
    model->Clear();
  }
}
