#include "Notes.h"

#include "Note.h"

#include "../Database.h"

#include "../Data/Note.h"

#include <Lum/Base/Util.h>

#include <Lum/Button.h>
#include <Lum/Menu.h>
#include <Lum/Space.h>

#include <Lum/Model/Selection.h>

#include <iostream>

namespace Views {

  class NotesEntry : public Lum::Model::ListTable::Entry
  {
  public:
    ::Data::NotePtr note;

  public:
    NotesEntry(Lum::Model::ListTable* table, ::Data::NotePtr note)
    : Lum::Model::ListTable::Entry(table),note(note)
    {
      // no code
    }

    std::wstring GetString(size_t column) const
    {
      std::wstring result;
      size_t       pos;

      switch (column) {
      case 1:
        result=note->GetAttribute(::Data::Note::NoteType::text);
        pos=result.find(L'\n');
        if (pos!=std::wstring::npos) {
          return result.substr(0,pos)+L"...";
        }
        else {
          return result;
        }
      default:
        return L"";
      }
    }

    bool IsGreater(const Lum::Model::ListTable::Entry* other, size_t column) const
    {
      ::Data::NotePtr tmp=dynamic_cast<const NotesEntry*>(other)->note;

      return note->GetAttribute(::Data::Note::NoteType::text)>tmp->GetAttribute(::Data::Note::NoteType::text);
    }
  };

  Notes::Notes()
  : View(L"Notes"),
    viewAction(new Lum::Model::Action),
    addAction(new Lum::Model::Action),
    deleteAction(new Lum::Model::Action),
    model(new Lum::Model::ListTable(1)),
    table(NULL),top(NULL)
  {
    AttachModel(viewAction);
    AttachModel(addAction);
    AttachModel(deleteAction);
  }

  Notes::~Notes()
  {
    UnattachModel(deleteAction);
    UnattachModel(addAction);
    UnattachModel(viewAction);

    delete top;
  }

  void Notes::FillList()
  {
    model->Off();

    model->Clear();

    ::Base::DataConstIterator iter;

    iter=database->database.begin();
    while (iter!=database->database.end()) {
      ::Data::NotePtr note;

      if ((note=dynamic_cast< ::Data::NotePtr>(*iter))!=NULL) {
        model->Append(new NotesEntry(model,note));
      }

      iter++;
    }

    model->Sort(1);

    model->On();
  }

  bool Notes::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (top!=NULL) {
      return visitor.Visit(top);
    }

    return true;
  }

  void Notes::CalcSize()
  {
    Lum::Menu             *menu;
    Lum::Model::HeaderRef headerModel;

    top=new Lum::VPanel();
    top->SetParent(this);
    top->SetFlex(true,true);

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Text",Lum::Base::Size::stdCharWidth,10);

    table=new Lum::Table();
    table->SetFlex(true,true);
    table->SetShowHeader(true);
    table->SetModel(model);
    table->SetHeaderModel(headerModel);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(viewAction);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",viewAction);
    menu->AddActionItem(L"Add",addAction);
    menu->AddActionItem(L"Delete",deleteAction);
    table->SetMenu(menu->GetWindow());

    top->Add(table);

    top->CalcSize();

    width=top->GetOWidth();
    height=top->GetOHeight();
    minWidth=top->GetOMinWidth();
    minHeight=top->GetOMinHeight();
    maxWidth=top->GetOMaxWidth();
    maxHeight=top->GetOMaxHeight();

    View::CalcSize();
  }

  void Notes::Layout()
  {
    top->Resize(width,height);
    top->Move(x,y);

    View::Layout();
  }

  void Notes::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==viewAction && viewAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t     line;
        Note::Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        data=new ::Base::View::Data(dynamic_cast< NotesEntry*>(this->model->GetEntry(line))->note);
        GUI::GetInstance()->ShowView(L"Note",data);
      }
    }
    else if (model==addAction && addAction->IsFinished()) {
      Note::Data *data;

      data=new ::Base::View::Data(new ::Data::Note());
      GUI::GetInstance()->ShowView(L"Note",data);
    }
    else if (model==deleteAction && deleteAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t         line;
        ::Data::Note   *note;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        note=dynamic_cast< NotesEntry*>(this->model->GetEntry(line))->note;
        database->Remove(note);
        FillList();
      }
    }
    else {
      View::Resync(model,msg);
    }
  }

  void Notes::Load(::Base::View::DataPtr data=NULL)
  {
    FillList();
  }

  void Notes::Vanish()
  {
    model->Clear();
  }
}
