#include "MSISDN.h"

#include "../Database.h"

#include "../Data/MSISDN.h"

#include <Lum/Base/Util.h>

#include <Lum/Model/Selection.h>

#include <Lum/Label.h>

#include <iostream>

namespace Views {

  MSISDN::MSISDN()
  : DataView(L"MSISDN")
  {
    number=new Lum::Model::String();

    RegisterModel(number);
  }

  void MSISDN::RegisterDataViews(Lum::Tab*& tab)
  {
    Lum::Label  *label;
    Lum::String *string;

    panel=new Lum::VPanel();
    panel->SetFlex(true,true);

    label=new Lum::Label();
    label->SetFlex(true,false);

    string=new Lum::String();
    string->SetFlex(true,false);
    string->SetModel(number);
    label->AddLabel(L"MSISDN",string);

    panel->Add(label);

    tab->Add(L"MSISDN",panel);

    DataView::RegisterDataViews(tab);
  }

  void MSISDN::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!msisdn->IsRegistered()) {
        database->Insert(msisdn);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,msisdn);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      if (!number->Empty()) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void MSISDN::Load(DataPtr viewData)
  {
    SetViewData(viewData);

    msisdn=dynamic_cast< ::Data::MSISDN*>(viewData->data);

    assert(msisdn!=NULL);

    number->Set(msisdn->msisdn);

    DataView::Load(viewData);
  }

  void MSISDN::Vanish()
  {
    DataView::Vanish();

    msisdn=NULL;
  }

  void MSISDN::Save()
  {
    msisdn->msisdn=number->Get();
  }
}
