#include "EMail.h"

#include "../Database.h"

#include "../Data/EMail.h"

#include <Lum/Base/Util.h>

#include <Lum/Model/Selection.h>

#include <Lum/Label.h>
#include <Lum/Text.h>

#include <iostream>

namespace Views {

  EMail::EMail()
  : DataView(L"EMail")
  {
    address=new Lum::Model::String();

    RegisterModel(address);
  }

  void EMail::RegisterDataViews(Lum::Tab*& tab)
  {
    Lum::Label  *label;
    Lum::String *string;

    panel=new Lum::VPanel();
    panel->SetFlex(true,true);

    label=new Lum::Label();
    label->SetFlex(true,false);

    string=new Lum::String();
    string->SetFlex(true,false);
    string->SetModel(address);
    label->AddLabel(L"EMail",string);

    panel->Add(label);

    tab->Add(L"EMail",panel);

    DataView::RegisterDataViews(tab);
  }

  void EMail::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!email->IsRegistered()) {
        database->Insert(email);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,email);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      if (!address->Empty()) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void EMail::Load(DataPtr viewData)
  {
    SetViewData(viewData);

    email=dynamic_cast< ::Data::EMail*>(viewData->data);

    assert(email!=NULL);

    address->Set(email->email);

    DataView::Load(viewData);
  }

  void EMail::Vanish()
  {
    DataView::Vanish();

    email=NULL;
  }

  void EMail::Save()
  {
    email->email=address->Get();
  }
}
