#include "Date.h"

#include "../Database.h"

#include "../Data/Date.h"

#include <Lum/Base/String.h>

#include <Lum/Model/Selection.h>
#include <Lum/Model/Table.h>

#include <Lum/Boolean.h>
#include <Lum/Button.h>
#include <Lum/Combo.h>
#include <Lum/DateSelect.h>
#include <Lum/Label.h>
#include <Lum/String.h>
#include <Lum/Text.h>
#include <Lum/TimeSelect.h>

namespace Views {

  Date::Date()
  : DataView(L"Date")
  {
    description=new Lum::Model::String();
    startDate=new Lum::Model::Calendar();
    endDate=new Lum::Model::Calendar();
    repeat=new Lum::Model::SizeT();
    repeatEndDate=new Lum::Model::Calendar();
    repeatInterval=new Lum::Model::String();
    wholeDay=new Lum::Model::Boolean();
    startTime=new Lum::Model::Time();
    endTime=new Lum::Model::Time();

    RegisterModel(description);
    RegisterModel(startDate);
    RegisterModel(endDate);
    RegisterModel(repeat);
    RegisterModel(repeatEndDate);
    RegisterModel(repeatInterval);
    RegisterModel(wholeDay);
    RegisterModel(startTime);
    RegisterModel(endTime);
  }

  void Date::RegisterDataViews(Lum::Tab*& tab)
  {
    Lum::Combo                      *combo;
    Lum::Label                      *label;
    Lum::String                     *string;
    Lum::DateSelect                 *select;
    Lum::Model::ListTableRef        model;
    Lum::Model::ListTable::StdEntry *entry;
    Lum::Boolean                    *boolean;
    Lum::TimeSelect                 *timeSelect;

    panel=new Lum::VPanel();
    panel->SetFlex(true,true);

    label=new Lum::Label();
    label->SetFlex(true,false);

    string=new Lum::String();
    string->SetFlex(true,false);
    string->SetModel(description);
    label->AddLabel(new Lum::Text(L"Description"),string);

    select=new Lum::DateSelect();
    select->SetModel(startDate);
    label->AddLabel(new Lum::Text(L"Start date"),select);

    select=new Lum::DateSelect();
    select->SetModel(endDate);
    label->AddLabel(new Lum::Text(L"End date"),select);

    panel->Add(label);

    tab->Add(L"Date",panel);

    panel=new Lum::VPanel();
    panel->SetFlex(true,true);

    label=new Lum::Label();
    label->SetFlex(true,false);

    model=new Lum::Model::ListTable(1);

    entry=new Lum::Model::ListTable::StdEntry(model);
    entry->SetString(1,L"No repetition");
    model->Append(entry);

    entry=new Lum::Model::ListTable::StdEntry(model);
    entry->SetString(1,L"Daily");
    model->Append(entry);

    entry=new Lum::Model::ListTable::StdEntry(model);
    entry->SetString(1,L"Weekly");
    model->Append(entry);

    entry=new Lum::Model::ListTable::StdEntry(model);
    entry->SetString(1,L"Monthly");
    model->Append(entry);

    entry=new Lum::Model::ListTable::StdEntry(model);
    entry->SetString(1,L"Yearly");
    model->Append(entry);

    combo=new Lum::IndexCombo();
    combo->SetFlex(true,false);
    combo->SetModel(repeat);
    combo->SetTableModel(model);
    label->AddLabel(L"Repeat",combo);

    select=new Lum::DateSelect();
    select->SetModel(repeatEndDate);
    label->AddLabel(L"End date",select);

    string=new Lum::String();
    string->SetFlex(true,false);
    string->SetModel(repeatInterval);
    label->AddLabel(L"Interval",string);

    boolean=new Lum::Boolean();
    boolean->SetModel(wholeDay);
    label->AddLabel(L"Whole day",boolean);

    timeSelect=new Lum::TimeSelect();
    timeSelect->SetModel(startTime);
    label->AddLabel(L"Start time",timeSelect);

    timeSelect=new Lum::TimeSelect();
    timeSelect->SetModel(endTime);
    label->AddLabel(L"End time",timeSelect);

    panel->Add(label);

    tab->Add(L"Repetition",panel);

    DataView::RegisterDataViews(tab);
  }

  void Date::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!date->IsRegistered()) {
        database->Insert(date);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,date);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      unsigned long tmp;

      if (!startDate->IsNull() && !endDate->IsNull() && endDate->Get()<startDate->Get()) {
        endDate->Set(startDate->Get());
      }

      if (!description->Empty() &&
          !repeatInterval->IsNull() &&
          Lum::Base::WStringToNumber(repeatInterval->Get(),tmp)) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }

      if (!repeat->IsNull() && repeat->Get()!=::Data::Date::DateType::noRepeat) {
        repeatEndDate->Enable();
        repeatInterval->Enable();
      }
      else {
        repeatEndDate->Disable();
        repeatInterval->Disable();
      }

      if (!wholeDay->IsNull() && !wholeDay->Get()) {
        startTime->Enable();
        endTime->Enable();

        if (startTime->IsNull()) {
          startTime->SetToNow();
        }
        if (endTime->IsNull()) {
          endTime->SetToNow();
          endTime->IncHour();
        }

        if (endTime->Get()<startTime->Get()) {
          endTime->Set(startTime->Get());
        }
      }
      else {
        startTime->Disable();
        endTime->Disable();
        startTime->SetNull();
        endTime->SetNull();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void Date::Load(DataPtr viewData)
  {
    SetViewData(viewData);

    date=dynamic_cast< ::Data::Date*>(viewData->data);
    assert(date!=NULL);

    //Push();

    description->Set(date->description);
    startDate->Set(date->startDate);
    endDate->Set(date->endDate);
    repeat->Set(date->repeat);
    repeatEndDate->Set(date->repeatEndDate);
    repeatInterval->Set(Lum::Base::NumberToWString(date->repeatInterval));
    wholeDay->Set(date->wholeDay);
    if (!date->wholeDay) {
      startTime->Set(date->startTime);
      endTime->Set(date->endTime);
    }

    //Push();

    DataView::Load(viewData);
  }

  void Date::Vanish()
  {
    DataView::Vanish();

    date=NULL;
  }

  void Date::Save()
  {
    date->description=description->Get();
    date->startDate=startDate->Get();
    date->endDate=endDate->Get();
    date->repeat=(::Data::Date::DateType::RepeatMode)repeat->Get();
    date->repeatEndDate=repeatEndDate->Get();
    Lum::Base::WStringToNumber(repeatInterval->Get(),date->repeatInterval);
    date->wholeDay=wholeDay->Get();
    if (!date->wholeDay) {
      date->startTime=startTime->Get();
      date->endTime=endTime->Get();
    }
  }
}
