#ifndef GUI_H
#define GUI_H

#include "View.h"
#include "MultiView.h"

#include <stack>

#include <Lum/Model/Action.h>

#include <Lum/Button.h>
#include <Lum/Dialog.h>

class GUI : public Lum::Dialog
{
private:
  class StackEntry
  {
  public:
    std::wstring      view;
    Base::View::Data* data;
  };

private:
  static GUI *instance;

private:
  MultiViewPtr          multi;
  Lum::Model::ActionRef previousAction;
  Lum::Model::ActionRef firstAction;
  Lum::Model::ActionRef aboutAction;

public:
  std::list<Base::ViewPtr> views;
  Base::ViewPtr            defaultView;
  std::stack<StackEntry>   stack;

private:
  void SetView(const StackEntry& entry);

public:
  GUI();
  ~GUI();

  static GUI* GetInstance();

  void RegisterDefaultView(Base::ViewPtr view);
  void RegisterView(Base::ViewPtr view);

  void ShowView(const std::wstring& name, Base::View::DataPtr data);

  void PreInit();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

  void GotoHome();
  void GotoPrevious();
};

#endif
