void oneResultSignal_cb(DBusGProxy *proxy, gchar *name, gchar *company, guint typeInfo, gchar *type, gchar *value, guint elementId, guint valueId, gint retCode, AppData *appData) {
	gchar *res;
	
	if (retCode >= CI_NO_ERROR) {
		res = g_strdup_printf("oneResultSignal_cb name=%s eltId %d valueId %d\n", name, elementId, valueId);
		gtk_text_buffer_insert_at_cursor(appData->buffer, res, -1);
		g_free(res);
	}
	
	if (retCode < CI_NO_ERROR || (elementId == CI_LAST_ELEMENT_ID && valueId==CI_LAST_VALUE_ID)) {
		res = g_strdup_printf("endResultSignal_cb RetCode=%d \n", retCode);
		gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
		g_free(res);

		dbus_g_proxy_disconnect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
			G_CALLBACK(oneResultSignal_cb), appData);

		g_object_unref (proxy);

	}

}

void callDbusSignal_cb(GtkButton *widget, gpointer data) {
	AppData *appData = (AppData *) data;
	DBusGConnection *connection;
	GError *error;
	DBusGProxy *proxy;
	gboolean availability = FALSE;
	
	gchar *searchText;
	guint requestedInfos = appData->requestedInfos;
	gchar *res;
	guint upperLimit;
	
	g_type_init ();

	searchText = g_strdup(gtk_entry_get_text(GTK_ENTRY(appData->searchEntry)));
	upperLimit = (guint) gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(appData->limitEntry));

	res = g_strdup_printf("Search -%s-\nRequestedInfos %X\nMultipleSel %d\nShowGui %d\n", searchText, requestedInfos, appData->multipleSel, appData->showGui);
	gtk_text_buffer_set_text (appData->buffer, res, -1);
	g_free(res);
	
	error = NULL;
	connection = dbus_g_bus_get (DBUS_BUS_SESSION,
			       &error);
	if (connection == NULL)
	{
		g_printerr ("Failed to open connection to bus: %s\n",
		  error->message);
		g_error_free (error);
		return;
	}

	/* Create a proxy object for the "bus driver" (name "org.freedesktop.DBus") */

	proxy = dbus_g_proxy_new_for_name (connection,
				     CONTACTINFOS_DBUS_NAME,
				     CONTACTINFOS_DBUS_PATH,
				     CONTACTINFOS_DBUS_INTERFACE);


	/* Connection to signal 
	Has DBus doesn't support structures and complex array yet
	We'll work it out via several signals
	And we have to add a final signal !
	*/
	dbus_g_object_register_marshaller(
		dbus_glib_marshal_contactinfos_VOID__STRING_STRING_UINT_STRING_STRING_UINT_UINT_INT,
		G_TYPE_NONE,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_UINT,
		G_TYPE_INT,
		G_TYPE_INVALID);

	dbus_g_proxy_add_signal(proxy,
		CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_STRING,
		G_TYPE_STRING,
		G_TYPE_UINT,
		G_TYPE_UINT,
		G_TYPE_INT,
		G_TYPE_INVALID);

	dbus_g_proxy_connect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_CALLBACK(oneResultSignal_cb), appData, NULL);
	
/* Not supported by DBus yet
	dbus_g_object_register_marshaller(
		dbus_glib_marshal_contactinfos_VOID__BOXED_POINTER,
		G_TYPE_NONE,
		G_TYPE_BOXED,
		G_TYPE_POINTER,
		G_TYPE_INVALID);
	
	dbus_g_proxy_add_signal(proxy,
		CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_TYPE_BOXED,
		G_TYPE_POINTER,
		G_TYPE_INVALID);

	dbus_g_proxy_connect_signal(proxy, CONTACTINFOS_DBUS_RESULTS_SIGNAL,
		G_CALLBACK(resultFoundSignal_cb), appData, NULL);
*/

	/* Start DBus Call */
	error = NULL;
	com_nokia_contactinfos_get_contact_infos (
								proxy, 
								requestedInfos, 
								searchText, 
								appData->showGui, 
								appData->confirm, 
								appData->multipleSel, 
								upperLimit, 
								&availability, 
								&error);
	g_free(searchText);
	if (error) {
		res  = g_strdup_printf("Error\n  Code = %d\n  Message = %s\n", error->code, error->message);
		gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
		g_free(res);
	} else {
		if (availability) {
			res  = g_strdup_printf("callDbusSignal_cb No Error\nWaiting for an answer ...\n");
			gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
			g_free(res);
		} else {
			res  = g_strdup_printf("callDbusSignal_cb No Error\nForget it ...\n");
			gtk_text_buffer_insert_at_cursor (appData->buffer, res, -1);
			g_free(res);
		}
	}
/*
	g_object_unref (proxy);
*/
}
