/*
 * This file is part of phonelink
 *
 * Copyright (C) 2008 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "phonelink.h"

/*
#include "dbus/dbus-service.h"
#include "dbus/dbus-error.h"
*/

#include <glib.h>

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>
#include <dbus/dbus-glib-bindings.h>
#include <dbus/dbus-glib-lowlevel.h>

 
 gboolean send_and_unref(DBusConnection *connection, DBusMessage *message) {
	 
	if (!dbus_connection_send(connection, message, NULL)) {
#ifdef DEBUG
		g_printf("send_and_unref Failure ! (\nDBusConnection *connection=%p, \nDBusMessage *message=%p \n", connection, message);
#endif
		dbus_message_unref(message);
		return FALSE;
	}

	dbus_connection_flush(connection);
	dbus_message_unref(message);

#ifdef DEBUG
	g_printf("send_and_unref Success ! (\nDBusConnection *connection=%p, \nDBusMessage *message=%p \n", connection, message);
#endif
	return TRUE;
}

void append_dbus_args(DBusMessage *message, int first_arg_type, ...) {

	dbus_bool_t ret;
	va_list ap;

	va_start(ap, first_arg_type);
	ret = dbus_message_append_args_valist(message, first_arg_type, ap);
	va_end(ap);

	if (ret == FALSE) {
		g_printf("dbus_message_append_args failed");
	}
}

gboolean sendDBusIncomingCallSignal(const gchar *number, const gchar *name) {

	DBusGConnection *gConnection;
	GError *error = NULL;
	DBusMessage *signal;
	DBusConnection *connection;
	gboolean ret;
	
	gchar *_name;
	gchar *_number;
	

	error = NULL;
	gConnection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
	if (gConnection == NULL) 	{
		g_printerr ("Failed to open connection to bus: %s\n", error->message);
		g_error_free (error);
		return FALSE;
	}

#ifdef DEBUG
	g_printf("sendDBusIncomingCallSignal(\nDBusConnection *connection=%p, \number=%s,  \nname=%s", gConnection, number, name);
#endif
	
	connection = dbus_g_connection_get_connection(gConnection);

	signal = dbus_message_new_signal(PHONELINK_DBUS_PATH, PHONELINK_DBUS_INTERFACE, PHONELINK_DBUS_INCOMING_CALL_SIGNAL);
	if (signal == NULL) {
		g_printf("Out of memory during dbus_message_new_signal()");
		return FALSE;
	}

#ifdef DEBUG
	g_printf("sendDBusIncomingCallSignal before append_dbus_args\n");
#endif
	
	if (name) {
		_name = g_strdup(name);
	} else {
		_name = g_strdup("");
	}
	if (number) {
		_number = g_strdup(number);
	} else {
		_number = g_strdup("");
	}
	
	
	dbus_message_append_args(signal,
		DBUS_TYPE_STRING, &_number,
		DBUS_TYPE_STRING, &_name,
		DBUS_TYPE_INVALID);
	
#ifdef DEBUG
	g_printf("sendDBusIncomingCallSignal before send and unref\n");
#endif
	ret = send_and_unref(connection, signal);
	
	g_free(_name);
	g_free(_number);
	
	return ret;
}

