/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "RateDialog.h"

#include <Lum/Base/L10N.h>

#include <Lum/Edit/Edit.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Combo.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>
#include <Lum/Text.h>
#include <Lum/View.h>

#include "Globals.h"
#include <iostream>
RateDialog::RateDialog(Rating &rating)
: rating(rating),
  commitAction(new Lum::Model::Action()),
  comment(new Lum::Edit::Text()),
  score(new Lum::Model::SizeT(4)),
  success(false)
{
  commitAction->Disable();

  Observe(comment);
  Observe(commitAction);
  Observe(GetClosedAction());

  comment->SetText(rating.comment);
  if (rating.score>=0) {
    score->Set(rating.score+1);
  }
}

void RateDialog::PreInit()
{
  Lum::IndexCombo          *combo;
  Lum::Edit::Edit          *edit;
  Lum::Label               *label;
  Lum::Model::ListTableRef rates;
  Lum::Panel               *vert;
  Lum::Text                *text;

  vert=Lum::VPanel::Create();

  text=new Lum::Text();
  text->SetFlex(true,false);
  text->AddText(L"Rate ",
                Lum::OS::Font::normal,
                Lum::OS::display->GetFont(Lum::OS::Display::fontScaleCaption1));
  text->AddText(rating.package+ L" "+rating.version,
                Lum::OS::Font::italic,
                Lum::OS::display->GetFont(Lum::OS::Display::fontScaleCaption1));

  vert->Add(text);

  vert->AddSpace();

  label=Lum::Label::Create(true,true);

  rates=new Lum::Model::ListTable();

  for (size_t i=0; i<=5; i++) {
    Lum::Model::ListTable::StdEntry *entry;
    //Lum::Panel                      *panel;

    entry=new Lum::Model::ListTable::StdEntry(rates);
    /*
    panel=new Lum::HPanel();

    for (size_t j=1; j<=5; j++) {
      Lum::Image *image;

      image=new Lum::Image();
      if (j<=i) {
        image->SetImage(fullStar);
      }
      else {
        image->SetImage(emptyStar);
      }
      panel->Add(image);

    }

    entry->SetObject(1,panel);*/

    entry->SetString(1,std::wstring(i,L'*'));

    rates->Append(entry);
  }

  combo=new Lum::IndexCombo();
  //combo->SetMinWidth(Lum::Base::Size::stdCharWidth,10);
  combo->SetMinWidth(Lum::Base::Size::pixel,120);
  combo->SetModel(score);
  combo->SetTableModel(rates);
  label->AddLabel(L"Rate:",combo);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,35);
  edit->SetMinHeight(Lum::Base::Size::stdCharWidth,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetModel(comment);

  label->AddLabel(L"Comment:",Lum::View::Create(edit,true,true));

  vert->Add(label);
  vert->AddSpace();
  vert->Add(Lum::ButtonRow::CreateOkCancel(commitAction,GetClosedAction(),true,false));

  SetMain(vert);

  Dialog::PreInit();
}

void RateDialog::Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
{
  if (model==commitAction && commitAction->IsFinished()) {
    rating.score=(int)score->Get()-1;
    rating.comment=comment->GetText();
    success=true;

    Exit();
  }
  else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }
  else if (model==comment) {
    const Lum::Edit::Text::TextChangedMsg *textChanged;

    if ((textChanged=dynamic_cast<const Lum::Edit::Text::TextChangedMsg*>(&msg))!=NULL) {
      if (comment->GetSize()>0) {
        commitAction->Enable();
      }
      else {
        commitAction->Disable();
      }
    }
  }

  Dialog::Resync(model,msg);
}

bool RateDialog::HasSuccess() const
{
  return success;
}

bool GetRate(Lum::Dialog *parent, Rating &rating)
{
  RateDialog *dialog;
  bool       success;

  dialog=new RateDialog(rating);
  dialog->SetParent(parent);

  if (dialog->Open()) {
    dialog->EventLoop();
    dialog->Close();
  }

  success=dialog->HasSuccess(),

  delete dialog;

  return success;
}
