#ifndef UPLOAD_H
#define UPLOAD_H

/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/Progress.h>

#include "Configuration.h"

class UploadTask : public Lum::Dlg::ProgressTask
{
private:
  std::wstring      username;
  std::wstring      password;
  std::string       buffer;
  std::string       error;
  std::list<Rating> jobs;

public:
  UploadTask();

  void SetLogin(const std::wstring& username, const std::wstring& password);
  void SetJobs(const std::list<Rating>& jobs);

  void Run();

  void AppendToBuffer(const char* text, size_t size);

  bool HasError() const;
  std::wstring GetError() const;
  void GetFinishedJobs(std::set<Rating>& finishedJobs) const;
};

#endif

