/*
  MaemoRate - Rate maemo packages
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "PackageList.h"

// apt-pkg
#include <apt-pkg/error.h>
#include <apt-pkg/init.h>
#include <apt-pkg/cachefile.h>
#include <apt-pkg/pkgcachegen.h>
#include <apt-pkg/sourcelist.h>

#include <Lum/Base/String.h>

#include "Configuration.h"
#include "Package.h"

class PkgProgress : public OpProgress
{
  PackageListTask* task;

public:
  PkgProgress(PackageListTask *task)
   : task(task)
  {
    // no code
  }

  void Update()
  {
    task->SetAction(Lum::Base::StringToWString(Op));
    task->SetProgress(Percent);
  }
};

PackageListTask::PackageListTask(Lum::Model::ListTableRef& packages)
: packages(packages)
{
  // no code
}

void PackageListTask::Run()
{
  if (!pkgInitConfig(*_config) || !pkgInitSystem(*_config,_system)) {
    std::cout << "Cannot initialize!" << std::endl;
    return;
  }

  pkgSourceList *srcList=NULL;
  MMap          *map=NULL;

  if (_config->FindB("APT::Cache::Generate",true) == false) {
    map=new MMap(*new FileFd(_config->FindFile("Dir::Cache::pkgcache"),
                             FileFd::ReadOnly),MMap::Public|MMap::ReadOnly);
  }
  else {
    // Open the cache file
    srcList=new pkgSourceList;
    srcList->ReadMainList();

    // Generate it and map it
    PkgProgress prog(this);
    pkgMakeStatusCache(*srcList,prog,&map,true);
  }

  if (_error->PendingError()) {
    _error->DumpErrors();
    return;
  }

  pkgCache cache(map);

  SetAction(L"Selecting to be rated packages...");

  for (pkgCache::PkgIterator iter=cache.PkgBegin(); !iter.end(); iter++) {
    if (iter->CurrentState==pkgCache::State::Installed) {
      if (iter.Section()!=NULL && strlen(iter.Section())>strlen("user/") && strncmp(iter.Section(),"user/",5)==0) {
        Rating                           rating;
        std::set<Rating>::const_iterator r;

        rating.package=Lum::Base::StringToWString(iter.Name());
        rating.version=Lum::Base::StringToWString(iter.CurrentVer().VerStr());

        r=ratings.find(rating);

        if (r==ratings.end() || !r->pushed) {
          Package *entry;

          pkgRecords Recs(cache);
          pkgRecords::Parser &P = Recs.Lookup(iter.CurrentVer().FileList());

          entry=new Package(packages,
                            Lum::Base::StringToWString(iter.Name()),
                            Lum::Base::StringToWString(iter.CurrentVer().VerStr()),
                            Lum::Base::StringToWString(P.ShortDesc()),
                            r!=ratings.end() ? r->score : -1);

          packages->Append(entry);
        }
      }
      else {
        continue;
      }
    }
  }
}

