/*
  Kandis - A tea steepming timer.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Configuration.h"

#include <algorithm>
#include <iostream>

#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Config/Config.h>

std::set<Rating>  ratings;
bool              configurationChanged=false;
std::wstring      username;
std::wstring      password;
std::wstring      ossoVersion;

bool operator<(const Rating& r1, const Rating& r2)
{
  if (r1.package==r2.package) {
    return r1.version<r2.version;
  }
  else {
    return r1.package<r2.package;
  }
}

bool operator==(const Rating& r1, const Rating& r2)
{
  if (r1.package==r2.package) {
    return r1.version==r2.version;
  }
  else {
    return r1.package==r2.package;
  }
}

bool LoadConfig()
{
  Lum::Config::Node      *top;
  Lum::Config::ErrorList errors;
  Lum::Base::Path        path(Lum::Base::Path::GetApplicationConfigPath());

  top=Lum::Config::LoadConfigFromXMLFile(path.GetPath(),errors);

  if (top==NULL) {
    return false;
  }

  if (top->GetName()!=L"MaemoRate") {
    std::cerr << "'" << Lum::Base::WStringToString(path.GetPath()) << "' is a valid config file!" << std::endl;
    delete top;
    return false;
  }

  for (Lum::Config::Node::NodeList::const_iterator iter=top->GetChildren().begin();
       iter!=top->GetChildren().end();
       ++iter) {
    Lum::Config::Node *node=*iter;

    if (node->GetName()==L"Rating") {
      Rating rating;

      if (node->GetAttribute(L"package",rating.package) &&
          node->GetAttribute(L"version",rating.version) &&
          node->GetAttribute(L"score",rating.score) &&
          node->GetAttribute(L"comment",rating.comment) &&
          node->GetAttribute(L"pushed",rating.pushed)) {
        ratings.insert(rating);
      }
    }
    else if (node->GetName()==L"Login") {
      node->GetAttribute(L"username",username);
      node->GetAttribute(L"password",password);
    }
  }

  delete top;

  return true;
}

bool SaveConfig()
{
  Lum::Config::Node *top,*node;
  Lum::Base::Path   path(Lum::Base::Path::GetApplicationConfigPath());
  std::wstring      config;
  bool              res;

  top=new Lum::Config::Node();
  top->SetName(L"MaemoRate");

  if (!username.empty()) {
    node=new Lum::Config::Node();
    node->SetName(L"Login");
    node->SetAttribute(L"username",username);
    node->SetAttribute(L"password",password);

    top->Add(node);
  }


  for (std::set<Rating>::const_iterator iter=ratings.begin(); iter!=ratings.end(); ++iter) {
    node=new Lum::Config::Node();
    node->SetName(L"Rating");
    node->SetAttribute(L"package",iter->package);
    node->SetAttribute(L"version",iter->version);
    node->SetAttribute(L"score",iter->score);
    node->SetAttribute(L"comment",iter->comment,true);
    node->SetAttribute(L"pushed",iter->pushed);

    top->Add(node);
  }

  Lum::Base::Status status;

  status=path.CreateDirRecursive();

  if (!status) {
    std::cerr << "Cannot create config directory '" << Lum::Base::WStringToString(path.GetDir()) << "': " << Lum::Base::WStringToString(status.GetDescription()) << std::endl;
    return false;
  }

  res=Lum::Config::SaveConfigToXMLFile(path.GetPath(),top);

  delete top;

  return res;
}

