/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "appdata.h"

static void on_info_clicked(GtkButton *button, gpointer data) {
  info_dialog((appdata_t*)data);
}

static void on_node_add_clicked(GtkButton *button, gpointer data) {
  map_action_set((appdata_t*)data, MAP_ACTION_NODE_ADD);
}

static void on_way_add_clicked(GtkButton *button, gpointer data) {
  map_action_set((appdata_t*)data, MAP_ACTION_WAY_ADD);
}

static void on_way_node_add_clicked(GtkButton *button, gpointer data) {
  map_action_set((appdata_t*)data, MAP_ACTION_WAY_NODE_ADD);
}

static void on_way_cut_clicked(GtkButton *button, gpointer data) {
  map_action_set((appdata_t*)data, MAP_ACTION_WAY_CUT);
}

static void on_trash_clicked(GtkButton *button, gpointer data) {
  map_delete_selected((appdata_t*)data);
}

static void on_ok_clicked(GtkButton *button, gpointer data) {
  printf("User ok\n");
  map_action_ok((appdata_t*)data);
}

static void on_cancel_clicked(GtkButton *button, gpointer data) {
  printf("User cancel\n");
  map_action_cancel((appdata_t*)data);
}

/* enable/disable ok and cancel button */
void icon_bar_map_cancel_ok(appdata_t *appdata, 
              gboolean cancel, gboolean ok) {
  iconbar_t *iconbar = appdata->iconbar;
  gtk_widget_set_sensitive(iconbar->ok, ok);
  gtk_widget_set_sensitive(iconbar->cancel, cancel);
}

void icon_bar_map_item_selected(appdata_t *appdata, 
		map_item_t *map_item, gboolean selected) {
  iconbar_t *iconbar = appdata->iconbar;

  gtk_widget_set_sensitive(iconbar->info, selected);
  gtk_widget_set_sensitive(iconbar->trash, selected);

  if(selected && map_item && map_item->type == MAP_TYPE_WAY) {
    gtk_widget_set_sensitive(iconbar->way_node_add, TRUE);
    gtk_widget_set_sensitive(iconbar->way_cut, TRUE);
  } else {
    gtk_widget_set_sensitive(iconbar->way_node_add, FALSE);
    gtk_widget_set_sensitive(iconbar->way_cut, FALSE);
  }
}

/* if a user action is on progress, then disable all buttons that */
/* cause an action to take place */
void icon_bar_map_action_idle(appdata_t *appdata, gboolean idle) {
  gint i;
  GtkWidget *action_widgets[] = {
    appdata->iconbar->node_add,
    appdata->iconbar->way_add,
    NULL
  };

  for(i=0;action_widgets[i];i++) 
    gtk_widget_set_sensitive(action_widgets[i], idle);

  /* special handling for icons that depend on further state */
  if(!idle) {
    gtk_widget_set_sensitive(appdata->iconbar->way_node_add, FALSE);
    gtk_widget_set_sensitive(appdata->iconbar->way_cut, FALSE);
  } else {
    if(appdata->map->selected.type == MAP_TYPE_WAY) {
      gtk_widget_set_sensitive(appdata->iconbar->way_node_add, TRUE);
      gtk_widget_set_sensitive(appdata->iconbar->way_cut, TRUE);
    } else {
      gtk_widget_set_sensitive(appdata->iconbar->way_node_add, FALSE);
      gtk_widget_set_sensitive(appdata->iconbar->way_cut, FALSE);
    }
  }
}

GtkWidget *icon_add(GtkWidget *vbox, appdata_t *appdata, 
		    char *icon_str, 
		    void(*func)(GtkButton*, gpointer)) {
  GtkWidget *but = gtk_button_new();
  GtkWidget *icon = gtk_image_new_from_pixbuf(
		      icon_load(appdata, icon_str)); 
  gtk_button_set_image(GTK_BUTTON(but), icon);
  gtk_signal_connect(GTK_OBJECT(but), "clicked",
		     (GtkSignalFunc)func, appdata);

  gtk_box_pack_start(GTK_BOX(vbox), but, FALSE, FALSE, 0);
  return but;
}

static GtkWidget *tool_add(GtkWidget *toolbar, appdata_t *appdata, 
		    char *icon_str, 
		    void(*func)(GtkButton*, gpointer)) {
  GtkWidget *item = 
    GTK_WIDGET(gtk_tool_button_new(icon_widget_load(appdata, icon_str), NULL));

  if(func)
    gtk_signal_connect(GTK_OBJECT(item), "clicked",
		       (GtkSignalFunc)func, appdata);

  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), GTK_TOOL_ITEM(item), -1);

  return item;
}

GtkWidget *iconbar_new(appdata_t *appdata) {
  appdata->iconbar = g_new0(iconbar_t, 1);
  iconbar_t *iconbar = appdata->iconbar;

  GtkWidget *vbox = gtk_vbox_new(FALSE, 0);

  GtkWidget *toolbar = gtk_toolbar_new();
  gtk_toolbar_set_orientation(GTK_TOOLBAR(toolbar), GTK_ORIENTATION_VERTICAL);
  gtk_toolbar_set_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_ICONS);

  /* -------------------------------------------------------- */
  iconbar->trash = tool_add(toolbar, appdata, "trash", on_trash_clicked);

  /* -------------------------------------------------------- */
  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(),-1);
  iconbar->info = tool_add(toolbar, appdata, "info", on_info_clicked);

  /* -------------------------------------------------------- */
  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(),-1);

  iconbar->node_add = tool_add(toolbar, appdata, "node_add", 
			       on_node_add_clicked);

  /* -------------------------------------------------------- */
  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(),-1);

  iconbar->way_add = tool_add(toolbar, appdata, "way_add", 
			      on_way_add_clicked);
  iconbar->way_node_add = tool_add(toolbar, appdata, "way_node_add", 
			      on_way_node_add_clicked);
  iconbar->way_cut = tool_add(toolbar, appdata, "way_cut", 
			      on_way_cut_clicked);


  gtk_box_pack_start(GTK_BOX(vbox), toolbar, TRUE, TRUE, 0);

  /* -------------------------------------------------------- */

  GtkWidget *hbox = gtk_hbox_new(FALSE, 0);
  iconbar->ok = icon_add(hbox, appdata, "ok", on_ok_clicked);
  iconbar->cancel = icon_add(hbox, appdata, "cancel", on_cancel_clicked);
  gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  
  /* --------------------------------------------------------- */  

  icon_bar_map_item_selected(appdata, NULL, FALSE);
  icon_bar_map_cancel_ok(appdata, FALSE, FALSE);

  return vbox;
}
